/*
 * Decompiled with CFR 0.152.
 */
package cn.maxpixel.mcdecompiler.util;

import cn.maxpixel.mcdecompiler.Info;
import cn.maxpixel.mcdecompiler.deps.gson.Gson;
import cn.maxpixel.mcdecompiler.deps.gson.GsonBuilder;
import cn.maxpixel.mcdecompiler.deps.gson.JsonDeserializationContext;
import cn.maxpixel.mcdecompiler.deps.gson.JsonDeserializer;
import cn.maxpixel.mcdecompiler.deps.gson.JsonElement;
import cn.maxpixel.mcdecompiler.deps.gson.JsonParseException;
import cn.maxpixel.mcdecompiler.deps.gson.JsonPrimitive;
import cn.maxpixel.mcdecompiler.deps.gson.JsonSerializationContext;
import cn.maxpixel.mcdecompiler.deps.gson.JsonSerializer;
import cn.maxpixel.mcdecompiler.deps.gson.annotations.SerializedName;
import cn.maxpixel.mcdecompiler.deps.jansi.Ansi;
import cn.maxpixel.mcdecompiler.deps.jansi.AnsiConsole;
import cn.maxpixel.mcdecompiler.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.function.Supplier;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public final class Logging {
    private static final Logger PARENT;
    private static final StackWalker WALKER;
    private static final LogConfiguration CONFIG;
    private static final Level LEVEL;

    private Logging() {
    }

    public static Logger getLogger() {
        return Logger.getLogger(WALKER.walk(stream -> ((String[])stream.limit(3L).map(StackWalker.StackFrame::getClassName).filter(s -> !s.startsWith("cn.maxpixel.mcdecompiler.util.Logging")).toArray(String[]::new))[0]));
    }

    public static Logger getLogger(String name) {
        if (name == null) {
            return Logging.getLogger();
        }
        Logger logger = Logger.getLogger(name);
        logger.setParent(PARENT);
        logger.setLevel(LEVEL);
        return logger;
    }

    static {
        WALKER = StackWalker.getInstance();
        CONFIG = LogConfiguration.fromInputStream(Logging.class.getClassLoader().getResourceAsStream("logging.json"));
        Level l = Logging.CONFIG.globalLevel;
        if (!Info.IS_DEV && System.console() != null) {
            AnsiConsole.systemInstall();
            Runtime.getRuntime().addShutdownHook(new Thread(AnsiConsole::systemUninstall));
        }
        PARENT = Logger.getLogger("cn.maxpixel.mcdecompiler");
        PARENT.setUseParentHandlers(false);
        PARENT.setLevel(l);
        StdoutHandler handler = new StdoutHandler();
        handler.setLevel(l);
        PARENT.addHandler(handler);
        LEVEL = l;
    }

    private static final class LogConfiguration {
        private static final Gson GSON = new GsonBuilder().registerTypeAdapter((Type)((Object)Level.class), new LevelJsonSerializer()).create();
        @SerializedName(value="global_level")
        public final Level globalLevel = Level.INFO;

        private LogConfiguration() {
        }

        public static LogConfiguration fromInputStream(InputStream is) {
            LogConfiguration logConfiguration;
            block8: {
                InputStream inputStream = is;
                try {
                    logConfiguration = GSON.fromJson((Reader)new InputStreamReader(is, StandardCharsets.UTF_8), LogConfiguration.class);
                    if (inputStream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw Utils.wrapInRuntime(e);
                    }
                }
                inputStream.close();
            }
            return logConfiguration;
        }

        private static final class LevelJsonSerializer
        implements JsonSerializer<Level>,
        JsonDeserializer<Level> {
            private LevelJsonSerializer() {
            }

            @Override
            public Level deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return switch (json.getAsString().toUpperCase()) {
                    case "OFF" -> Level.OFF;
                    case "SEVERE" -> Level.SEVERE;
                    case "WARNING" -> Level.WARNING;
                    case "INFO" -> Level.INFO;
                    case "CONFIG" -> Level.CONFIG;
                    case "FINE" -> Level.FINE;
                    case "FINER" -> Level.FINER;
                    case "FINEST" -> Level.FINEST;
                    case "ALL" -> Level.ALL;
                    default -> throw new JsonParseException("Unknown log level");
                };
            }

            @Override
            public JsonElement serialize(Level src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(src.getName());
            }
        }
    }

    private static final class StdoutHandler
    extends Handler {
        private boolean doneHeader;

        private StdoutHandler() {
            this.setFormatter(new LogFormatter());
        }

        @Override
        public void publish(LogRecord record) {
            String msg;
            if (!this.isLoggable(record)) {
                return;
            }
            try {
                msg = this.getFormatter().format(record);
            }
            catch (Exception ex) {
                this.reportError(null, ex, 5);
                return;
            }
            try {
                if (!this.doneHeader) {
                    System.out.print(this.getFormatter().getHead(this));
                    this.doneHeader = true;
                }
                System.out.print(msg);
            }
            catch (Exception ex) {
                this.reportError(null, ex, 1);
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }
    }

    private static final class LogFormatter
    extends Formatter {
        private static final ZoneId zone = ZoneId.systemDefault();

        private LogFormatter() {
        }

        @Override
        public String format(LogRecord record) {
            Ansi ansi = Ansi.ansi();
            if (record.getLevel() == Level.FINEST) {
                ansi.fgGreen();
            } else if (record.getLevel() == Level.FINER) {
                ansi.fgBlue();
            } else if (record.getLevel() == Level.FINE) {
                ansi.fgCyan();
            } else if (record.getLevel() == Level.CONFIG) {
                ansi.fg(Ansi.Color.WHITE);
            } else if (record.getLevel() == Level.INFO) {
                ansi.fgBright(Ansi.Color.WHITE);
            } else if (record.getLevel() == Level.WARNING) {
                ansi.fgBrightYellow();
            } else if (record.getLevel() == Level.SEVERE) {
                ansi.fgBrightRed();
            } else {
                ansi.fgGreen();
            }
            ansi.a('[');
            DateTimeFormatter.ISO_LOCAL_DATE_TIME.formatTo(LocalDateTime.ofInstant(record.getInstant(), zone), ansi);
            return ansi.a("] [").a(record.getLoggerName()).a("] [").a(record.getLevel()).a("] ").a(LogFormatter.getMessage(record.getSourceClassName(), record.getSourceMethodName(), record.getMessage(), record.getParameters(), record.getThrown())).newline().reset().toString();
        }

        private static StringBuilder getMessage(String sourceClass, String sourceMethod, String message, Object[] params, Throwable thrown) {
            StringBuilder builder = new StringBuilder();
            if (sourceClass != null) {
                builder.append("[").append(sourceClass);
                if (sourceMethod != null) {
                    builder.append('/').append(sourceMethod);
                }
                builder.append("] ");
            } else if (sourceMethod != null) {
                builder.append("[Method ").append(sourceMethod).append("] ");
            }
            if (message != null) {
                if (params != null && params.length > 0) {
                    int paramLength = params.length;
                    if (params[paramLength - 1] instanceof Throwable) {
                        thrown = (Throwable)params[--paramLength];
                    }
                    for (int i = 0; i < paramLength; ++i) {
                        Object object = params[i];
                        if (!(object instanceof Supplier)) continue;
                        Supplier s = (Supplier)object;
                        params[i] = s.get();
                    }
                    message = String.format(MessageFormat.format(message, params), params);
                }
                builder.append(message);
            }
            if (thrown != null) {
                builder.append('\n');
                StringWriter writer = new StringWriter();
                thrown.printStackTrace(new PrintWriter(writer));
                builder.append(writer.getBuffer());
            }
            return builder;
        }
    }
}

