/*
 * Decompiled with CFR 0.152.
 */
package cn.maxpixel.mcdecompiler.util;

import cn.maxpixel.mcdecompiler.util.Utils;
import java.util.concurrent.CompletionException;
import java.util.function.Consumer;
import java.util.function.Function;

public class LambdaUtil {
    public static <E extends Throwable> void rethrowAsRuntime(E throwable) {
        throw Utils.wrapInRuntime(throwable);
    }

    public static <E extends Throwable> void rethrowAsCompletion(E throwable) {
        throw new CompletionException(throwable);
    }

    public static <E extends Throwable> Runnable unwrap(Runnable_WithThrowable<E> runnableWithThrowable) {
        return LambdaUtil.unwrap(runnableWithThrowable, LambdaUtil::rethrowAsRuntime);
    }

    public static <E extends Throwable> Runnable unwrap(Runnable_WithThrowable<E> runnableWithThrowable, Consumer<E> exceptionHandler) {
        return () -> {
            try {
                runnableWithThrowable.run();
            }
            catch (Throwable e) {
                exceptionHandler.accept(e);
            }
        };
    }

    public static <T, R, E extends Throwable> Function<T, R> unwrap(Function_WithThrowable<T, R, E> functionWithThrowable) {
        return LambdaUtil.unwrap(functionWithThrowable, LambdaUtil::rethrowAsRuntime);
    }

    public static <T, R, E extends Throwable> Function<T, R> unwrap(Function_WithThrowable<T, R, E> functionWithThrowable, Consumer<E> exceptionHandler) {
        return t -> {
            try {
                return functionWithThrowable.apply(t);
            }
            catch (Throwable e) {
                exceptionHandler.accept(e);
                return null;
            }
        };
    }

    public static <T, E extends Throwable> Consumer<T> unwrapConsumer(Consumer_WithThrowable<T, E> consumerWithThrowable) {
        return LambdaUtil.unwrapConsumer(consumerWithThrowable, LambdaUtil::rethrowAsRuntime);
    }

    public static <T, E extends Throwable> Consumer<T> unwrapConsumer(Consumer_WithThrowable<T, E> consumerWithThrowable, Consumer<E> exceptionHandler) {
        return t -> {
            try {
                consumerWithThrowable.accept(t);
            }
            catch (Throwable e) {
                exceptionHandler.accept(e);
            }
        };
    }

    @FunctionalInterface
    public static interface Runnable_WithThrowable<E extends Throwable> {
        public void run() throws E;
    }

    @FunctionalInterface
    public static interface Function_WithThrowable<T, R, E extends Throwable> {
        public R apply(T var1) throws E;
    }

    @FunctionalInterface
    public static interface Consumer_WithThrowable<T, E extends Throwable> {
        public void accept(T var1) throws E;
    }
}

