/*
 * Decompiled with CFR 0.152.
 */
package cn.maxpixel.mcdecompiler.util;

import cn.maxpixel.mcdecompiler.util.Logging;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.spi.FileSystemProvider;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JarUtil {
    private static final Logger LOGGER = Logging.getLogger();
    private static final FileSystemProvider JAR_FSP;

    public static FileSystem createZipFs(Path zipPath) throws IOException {
        return JarUtil.createZipFs(zipPath, false);
    }

    public static FileSystem createZipFs(Path zipPath, boolean create) throws IOException {
        LOGGER.log(Level.FINER, "Creating JarFileSystem for \"{0}\"", zipPath);
        return JAR_FSP.newFileSystem(zipPath, Map.of("create", create));
    }

    static {
        FileSystemProvider provider = null;
        for (FileSystemProvider p : FileSystemProvider.installedProviders()) {
            if (!p.getScheme().equalsIgnoreCase("jar")) continue;
            provider = p;
            break;
        }
        if (provider == null) {
            throw new IllegalStateException("jar/zip file system provider does not exist");
        }
        JAR_FSP = provider;
    }
}

