/*
 * Decompiled with CFR 0.152.
 */
package cn.maxpixel.mcdecompiler.util;

import cn.maxpixel.mcdecompiler.util.Utils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.zip.InflaterInputStream;

public class IOUtil {
    private static final Class<?> ZIP_FILESYSTEM;
    private static final Class<?> ENTRY_INPUT_STREAM;

    public static byte[] readAllBytes(Path file) throws IOException {
        if (ZIP_FILESYSTEM != file.getFileSystem().getClass()) {
            throw new IllegalArgumentException();
        }
        InputStream is = Files.newInputStream(file, new OpenOption[0]);
        byte[] bytes = new byte[is.available()];
        if (is instanceof InflaterInputStream) {
            if (bytes.length > 65536) {
                for (int len = 0; len != bytes.length; len += is.read(bytes, len, bytes.length - len)) {
                }
            } else {
                is.read(bytes);
            }
            return bytes;
        }
        if (is.getClass() == ENTRY_INPUT_STREAM) {
            is.read(bytes);
            return bytes;
        }
        throw new UnsupportedOperationException();
    }

    public static BufferedReader asBufferedReader(Reader reader) {
        return IOUtil.asBufferedReader(reader, "reader");
    }

    public static BufferedReader asBufferedReader(Reader reader, String readerName) {
        BufferedReader br;
        Reader reader2 = Objects.requireNonNull(reader, () -> readerName + " cannot be null");
        return reader2 instanceof BufferedReader ? (br = (BufferedReader)reader2) : new BufferedReader(reader);
    }

    static {
        try {
            ZIP_FILESYSTEM = Class.forName("jdk.nio.zipfs.ZipFileSystem");
            ENTRY_INPUT_STREAM = Class.forName("jdk.nio.zipfs.ZipFileSystem$EntryInputStream");
        }
        catch (ClassNotFoundException e) {
            throw Utils.wrapInRuntime(e);
        }
    }
}

