/*
 * Decompiled with CFR 0.152.
 */
package cn.maxpixel.mcdecompiler.util;

import cn.maxpixel.mcdecompiler.util.LambdaUtil;
import cn.maxpixel.mcdecompiler.util.Logging;
import cn.maxpixel.mcdecompiler.util.Utils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class FileUtil {
    private static final Logger LOGGER = Logging.getLogger();

    private FileUtil() {
        throw new AssertionError((Object)"No instances");
    }

    public static void copyFile(@NotNull Path source, @NotNull Path target) {
        if (Files.notExists(source, new LinkOption[0])) {
            LOGGER.log(Level.FINER, "Source \"{0}\" does not exist, skipping this operation...", source);
            return;
        }
        if (Files.isDirectory(source, new LinkOption[0])) {
            throw new IllegalArgumentException("Source isn't a file");
        }
        if (Files.exists(target, new LinkOption[0]) && Files.isDirectory(target, new LinkOption[0])) {
            target = target.resolve(source.getFileName().toString());
        }
        LOGGER.log(Level.FINER, "Coping file {0} to {1} ...", new Object[]{source, target});
        try {
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Error coping file", e);
        }
    }

    public static void deleteIfExists(@NotNull Path path) {
        if (Files.notExists(path, new LinkOption[0])) {
            return;
        }
        try {
            LOGGER.log(Level.FINER, "Deleting \"{0}\"...", path);
            if (Files.isDirectory(path, new LinkOption[0])) {
                try (DirectoryStream<Path> ds = Files.newDirectoryStream(path);){
                    StreamSupport.stream(ds.spliterator(), true).forEach(FileUtil::deleteIfExists);
                }
            }
            Files.deleteIfExists(path);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to delete \"{0}\"", new Object[]{path, e});
        }
    }

    public static Path requireExist(@NotNull Path p) {
        if (Files.notExists(p, new LinkOption[0])) {
            throw new IllegalArgumentException("Path \"" + p + "\"does not exist");
        }
        return p;
    }

    public static Path ensureFileExist(@NotNull Path p) {
        if (Files.notExists(p, new LinkOption[0])) {
            try {
                Path parent = p.getParent();
                if (parent != null) {
                    Files.createDirectories(parent, new FileAttribute[0]);
                }
                Files.createFile(p, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw Utils.wrapInRuntime(e);
            }
        }
        return p;
    }

    public static Stream<Path> iterateFiles(@NotNull Path path) {
        try {
            DirectoryStream<Path> ds = Files.newDirectoryStream(path);
            return (Stream)StreamSupport.stream(ds.spliterator(), true).mapMulti((p, cons) -> {
                if (Files.isDirectory(p, new LinkOption[0])) {
                    FileUtil.iterateFiles(p).forEach((Consumer<Path>)cons);
                } else {
                    cons.accept(p);
                }
            }).onClose(LambdaUtil.unwrap(ds::close));
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Error iterating files", e);
            throw Utils.wrapInRuntime(e);
        }
    }

    public static boolean verify(@NotNull Path path, @NotNull String hash) {
        return FileUtil.verify(path, hash, -1L);
    }

    public static boolean verify(@NotNull Path path, @NotNull String hash, long size) {
        boolean bl;
        block13: {
            if (Files.notExists(path, new LinkOption[0])) {
                return false;
            }
            if (Files.isDirectory(path, new LinkOption[0])) {
                throw new IllegalArgumentException("Verify a directory is not supported");
            }
            if (Objects.requireNonNull(hash, "Why do you want to verify a file with null hash?").isBlank()) {
                throw new IllegalArgumentException("Why do you want to verify a file with no hash?");
            }
            FileChannel fc = FileChannel.open(path, StandardOpenOption.READ);
            try {
                MessageDigest md = MessageDigest.getInstance("SHA-1");
                ByteBuffer buf = ByteBuffer.allocateDirect(65536);
                while (fc.read(buf) != -1) {
                    md.update(buf.flip());
                    buf.clear();
                }
                boolean bl2 = bl = (size < 0L || fc.size() == size) && hash.contentEquals(Utils.createHashString(md));
                if (fc == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (fc != null) {
                        try {
                            fc.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, "Error reading files", e);
                    throw Utils.wrapInRuntime(e);
                }
                catch (NoSuchAlgorithmException e) {
                    LOGGER.warning("Hmm... You need a SHA-1 digest implementation");
                    return false;
                }
            }
            fc.close();
        }
        return bl;
    }
}

