/*
 * Decompiled with CFR 0.152.
 */
package cn.maxpixel.mcdecompiler.util;

import cn.maxpixel.mcdecompiler.Info;
import cn.maxpixel.mcdecompiler.MinecraftDecompiler;
import cn.maxpixel.mcdecompiler.Properties;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.ObjectOpenHashSet;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.ObjectSet;
import cn.maxpixel.mcdecompiler.deps.gson.JsonObject;
import cn.maxpixel.mcdecompiler.util.FileUtil;
import cn.maxpixel.mcdecompiler.util.LambdaUtil;
import cn.maxpixel.mcdecompiler.util.Logging;
import cn.maxpixel.mcdecompiler.util.Utils;
import cn.maxpixel.mcdecompiler.util.VersionManifest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.Blocking;
import org.jetbrains.annotations.NonBlocking;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DownloadingUtil {
    private static final Logger LOGGER = Logging.getLogger();

    @Blocking
    public static Path downloadJarSync(@NotNull String version, @NotNull Info.SideType type) {
        return DownloadingUtil.downloadJar(version, type).join();
    }

    @NonBlocking
    public static CompletableFuture<Path> downloadJar(@NotNull String version, @NotNull Info.SideType type) {
        return ((CompletableFuture)VersionManifest.get(version).thenComposeAsync(object -> {
            JsonObject download;
            String id = object.get("id").getAsString();
            Path p = Properties.DOWNLOAD_DIR.resolve(id).resolve(type + ".jar");
            if (!FileUtil.verify(p, (download = object.getAsJsonObject("downloads").getAsJsonObject(type.toString())).get("sha1").getAsString(), download.get("size").getAsLong())) {
                LOGGER.log(Level.INFO, "Downloading {0} {1} jar...", new Object[]{id, type});
                return MinecraftDecompiler.HTTP_CLIENT.sendAsync(HttpRequest.newBuilder(URI.create(download.get("url").getAsString())).build(), HttpResponse.BodyHandlers.ofFile(FileUtil.ensureFileExist(p), StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING)).thenApply(HttpResponse::body);
            }
            return CompletableFuture.completedFuture(p);
        })).whenComplete((p, ex) -> {
            if (ex != null) {
                LOGGER.log(Level.SEVERE, "Error downloading minecraft jar", (Throwable)ex);
            }
        });
    }

    @Blocking
    public static BufferedReader downloadMappingSync(@NotNull String version, @NotNull Info.SideType type) {
        return DownloadingUtil.downloadMapping(version, type).join();
    }

    @NonBlocking
    public static CompletableFuture<BufferedReader> downloadMapping(@NotNull String version, @NotNull Info.SideType type) {
        return ((CompletableFuture)VersionManifest.get(version).thenComposeAsync(object -> {
            String id = object.get("id").getAsString();
            JsonObject mappings = object.getAsJsonObject("downloads").getAsJsonObject(type + "_mappings");
            if (mappings == null) {
                throw new IllegalArgumentException("Version \"" + id + "\" doesn't have official mappings. Please use 1.14.4 or above");
            }
            Path p = Properties.DOWNLOAD_DIR.resolve(id).resolve(type + "_mappings.txt");
            if (!FileUtil.verify(p, mappings.get("sha1").getAsString(), mappings.get("size").getAsLong())) {
                LOGGER.log(Level.INFO, "Downloading {0} {1} mapping...", new Object[]{id, type});
                return MinecraftDecompiler.HTTP_CLIENT.sendAsync(HttpRequest.newBuilder(URI.create(mappings.get("url").getAsString())).build(), HttpResponse.BodyHandlers.ofFile(FileUtil.ensureFileExist(p), StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING)).thenApply(HttpResponse::body);
            }
            return CompletableFuture.completedFuture(p);
        })).thenApply(LambdaUtil.unwrap(Files::newBufferedReader, LambdaUtil::rethrowAsCompletion));
    }

    @Blocking
    public static InputStream getRemoteResource(@NotNull Path localPath, @NotNull URI remoteResource, @NotNull URI remoteHash) throws IOException {
        try {
            if (!FileUtil.verify(Objects.requireNonNull(localPath), MinecraftDecompiler.HTTP_CLIENT.send(HttpRequest.newBuilder(remoteHash).build(), HttpResponse.BodyHandlers.ofString()).body())) {
                FileUtil.deleteIfExists(localPath);
                LOGGER.fine("Downloading the resource");
                FileUtil.ensureFileExist(localPath);
                MinecraftDecompiler.HTTP_CLIENT.send(HttpRequest.newBuilder(remoteResource).build(), HttpResponse.BodyHandlers.ofFile(localPath, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING));
            }
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.SEVERE, "Download process interrupted", e);
            throw Utils.wrapInRuntime(e);
        }
        return Files.newInputStream(localPath, StandardOpenOption.READ);
    }

    @Blocking
    @NotNull
    public static ObjectSet<Path> downloadLibraries(@Nullable String version, @NotNull Path libDir) {
        if (version == null || version.isBlank()) {
            LOGGER.fine("Invalid version, skipping downloading libs");
            return ObjectOpenHashSet.of();
        }
        LOGGER.log(Level.INFO, "Downloading libs of version {0}", version);
        return StreamSupport.stream(VersionManifest.getSync(version).getAsJsonArray("libraries").spliterator(), true).map(ele -> ele.getAsJsonObject().getAsJsonObject("downloads")).map(obj -> obj.getAsJsonObject("artifact")).filter(Objects::nonNull).map(artifact -> {
            String url = artifact.get("url").getAsString();
            Path file = libDir.resolve(url.substring(url.lastIndexOf(47) + 1));
            if (!FileUtil.verify(file, artifact.get("sha1").getAsString(), artifact.get("size").getAsLong())) {
                LOGGER.log(Level.FINER, "Downloading {0}", url);
                try {
                    MinecraftDecompiler.HTTP_CLIENT.send(HttpRequest.newBuilder(URI.create(url)).build(), HttpResponse.BodyHandlers.ofFile(file, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING));
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, "Error downloading files", e);
                    throw Utils.wrapInRuntime(e);
                }
                catch (InterruptedException e) {
                    LOGGER.log(Level.SEVERE, "Download process interrupted", e);
                    throw Utils.wrapInRuntime(e);
                }
            }
            return file;
        }).collect(ObjectOpenHashSet.toSet());
    }
}

