/*
 * Decompiled with CFR 0.152.
 */
package cn.maxpixel.mcdecompiler.util;

import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class DescriptorUtil {
    public static String getMethodReturnDescriptor(@NotNull String methodDescriptor) {
        int index = methodDescriptor.lastIndexOf(41);
        if (index == -1) {
            throw new IllegalArgumentException("Invalid descriptor");
        }
        return methodDescriptor.substring(index + 1);
    }

    public static int getArgumentCount(@NotNull @Pattern(value="^\\((\\[*([ZBCDFIJS]|L([A-Za-z_]+\\w*[/$]?)+;))*\\)\\[*([ZBCDFIJSV]|L([A-Za-z_]+\\w*[/$]?)+;)$") String descriptor) {
        int count = 0;
        int max = descriptor.lastIndexOf(41);
        block5: for (int i = 1; i < max; ++i) {
            switch (descriptor.charAt(i)) {
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'Z': {
                    ++count;
                    continue block5;
                }
                case 'L': {
                    ++count;
                    i = descriptor.indexOf(59, i);
                    if (i != -1) continue block5;
                    throw new IllegalArgumentException("Invalid method descriptor");
                }
                case '[': {
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Invalid method descriptor");
                }
            }
        }
        return count;
    }
}

