/*
 * Decompiled with CFR 0.152.
 */
package cn.maxpixel.mcdecompiler.reader;

import cn.maxpixel.mcdecompiler.deps.fastutil.Pair;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.Object2ObjectOpenHashMap;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.ObjectArrayList;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.ObjectList;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.ObjectLists;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.ObjectObjectImmutablePair;
import cn.maxpixel.mcdecompiler.mapping.NamespacedMapping;
import cn.maxpixel.mcdecompiler.mapping.PairedMapping;
import cn.maxpixel.mcdecompiler.mapping.collection.ClassMapping;
import cn.maxpixel.mcdecompiler.mapping.component.Documented;
import cn.maxpixel.mcdecompiler.mapping.component.LocalVariableTable;
import cn.maxpixel.mcdecompiler.mapping.component.StaticIdentifiable;
import cn.maxpixel.mcdecompiler.mapping.type.MappingType;
import cn.maxpixel.mcdecompiler.mapping.type.MappingTypes;
import cn.maxpixel.mcdecompiler.reader.MappingProcessor;
import cn.maxpixel.mcdecompiler.util.MappingUtil;
import cn.maxpixel.mcdecompiler.util.NamingUtil;
import java.util.function.Function;

public interface MappingProcessors {
    public static final MappingProcessor.Classified<PairedMapping> SRG = new MappingProcessor.Classified<PairedMapping>(){
        private static final Function<String, Function<String, ClassMapping<PairedMapping>>> MAPPING_FUNC = s -> k -> new ClassMapping<PairedMapping>(new PairedMapping((String)k, 1.getClassName(s)));

        @Override
        public MappingType<PairedMapping, ObjectList<ClassMapping<PairedMapping>>> getType() {
            return MappingTypes.SRG;
        }

        @Override
        public Pair<ObjectList<ClassMapping<PairedMapping>>, ObjectList<PairedMapping>> process(ObjectList<String> content) {
            ObjectObjectImmutablePair<ObjectList<ClassMapping<PairedMapping>>, ObjectList<PairedMapping>> mappings = new ObjectObjectImmutablePair<ObjectList<ClassMapping<PairedMapping>>, ObjectList<PairedMapping>>(new ObjectArrayList(), new ObjectArrayList());
            Object2ObjectOpenHashMap classes = new Object2ObjectOpenHashMap();
            content.parallelStream().forEach(s -> {
                String[] strings = s.split(" ", 6);
                switch (strings[0]) {
                    case "CL:": {
                        ClassMapping<PairedMapping> classMapping = new ClassMapping<PairedMapping>(new PairedMapping(strings[1], strings[2]));
                        Object2ObjectOpenHashMap object2ObjectOpenHashMap = classes;
                        synchronized (object2ObjectOpenHashMap) {
                            classes.putIfAbsent(strings[1], classMapping);
                            break;
                        }
                    }
                    case "FD:": {
                        PairedMapping fieldMapping = MappingUtil.Paired.o(1.getName(strings[1]), 1.getName(strings[2]));
                        String unmClassName = 1.getClassName(strings[1]);
                        Object2ObjectOpenHashMap object2ObjectOpenHashMap = classes;
                        synchronized (object2ObjectOpenHashMap) {
                            classes.computeIfAbsent(unmClassName, MAPPING_FUNC.apply(strings[2])).addField(fieldMapping);
                            break;
                        }
                    }
                    case "MD:": {
                        PairedMapping methodMapping = MappingUtil.Paired.d2o(1.getName(strings[1]), 1.getName(strings[3]), strings[2], strings[4]);
                        String unmClassName = 1.getClassName(strings[1]);
                        Object2ObjectOpenHashMap object2ObjectOpenHashMap = classes;
                        synchronized (object2ObjectOpenHashMap) {
                            classes.computeIfAbsent(unmClassName, MAPPING_FUNC.apply(strings[3])).addMethod(methodMapping);
                            break;
                        }
                    }
                    case "PK:": {
                        ObjectList objectList = (ObjectList)mappings.right();
                        synchronized (objectList) {
                            ((ObjectList)mappings.right()).add(new PairedMapping(strings[1], strings[2]));
                            break;
                        }
                    }
                    default: {
                        throw new IllegalArgumentException("Is this a SRG mapping file?");
                    }
                }
            });
            ((ObjectList)mappings.left()).addAll(classes.values());
            return mappings;
        }

        private static String getClassName(String s) {
            return s.substring(0, s.lastIndexOf(47));
        }

        private static String getName(String s) {
            return s.substring(s.lastIndexOf(47) + 1);
        }
    };
    public static final MappingProcessor.Classified<PairedMapping> CSRG = new MappingProcessor.Classified<PairedMapping>(){
        private static final Function<String, ClassMapping<PairedMapping>> COMPUTE_FUNC = name -> new ClassMapping<PairedMapping>(new PairedMapping((String)name, (String)name));

        @Override
        public MappingType<PairedMapping, ObjectList<ClassMapping<PairedMapping>>> getType() {
            return MappingTypes.CSRG;
        }

        @Override
        public Pair<ObjectList<ClassMapping<PairedMapping>>, ObjectList<PairedMapping>> process(ObjectList<String> content) {
            ObjectObjectImmutablePair<ObjectList<ClassMapping<PairedMapping>>, ObjectList<PairedMapping>> mappings = new ObjectObjectImmutablePair<ObjectList<ClassMapping<PairedMapping>>, ObjectList<PairedMapping>>(new ObjectArrayList(), new ObjectArrayList());
            Object2ObjectOpenHashMap classes = new Object2ObjectOpenHashMap();
            content.parallelStream().forEach(s -> {
                String[] sa = s.split(" ", 5);
                switch (sa.length) {
                    case 2: {
                        if (sa[0].charAt(sa[0].length() - 1) == '/') {
                            ObjectList objectList = (ObjectList)mappings.right();
                            synchronized (objectList) {
                                ((ObjectList)mappings.right()).add(new PairedMapping(sa[0].substring(0, sa[0].length() - 1), sa[1].substring(0, sa[1].length() - 1)));
                                break;
                            }
                        }
                        ClassMapping<PairedMapping> classMapping = new ClassMapping<PairedMapping>(new PairedMapping(sa[0], sa[1]));
                        Object2ObjectOpenHashMap object2ObjectOpenHashMap = classes;
                        synchronized (object2ObjectOpenHashMap) {
                            classes.merge(((PairedMapping)classMapping.mapping).unmappedName, classMapping, (o, n) -> {
                                n.addFields(o.getFields());
                                n.addMethods(o.getMethods());
                                return n;
                            });
                            break;
                        }
                    }
                    case 3: {
                        PairedMapping fieldMapping = MappingUtil.Paired.o(sa[1], sa[2]);
                        Object2ObjectOpenHashMap object2ObjectOpenHashMap = classes;
                        synchronized (object2ObjectOpenHashMap) {
                            classes.computeIfAbsent(sa[0], COMPUTE_FUNC).addField(fieldMapping);
                            break;
                        }
                    }
                    case 4: {
                        PairedMapping methodMapping = MappingUtil.Paired.duo(sa[1], sa[3], sa[2]);
                        Object2ObjectOpenHashMap object2ObjectOpenHashMap = classes;
                        synchronized (object2ObjectOpenHashMap) {
                            classes.computeIfAbsent(sa[0], COMPUTE_FUNC).addMethod(methodMapping);
                            break;
                        }
                    }
                    default: {
                        throw new IllegalArgumentException("Is this a CSRG mapping file?");
                    }
                }
            });
            ((ObjectList)mappings.left()).addAll(classes.values());
            return mappings;
        }
    };
    public static final MappingProcessor.Classified<PairedMapping> TSRG_V1 = new MappingProcessor.Classified<PairedMapping>(){

        @Override
        public MappingType<PairedMapping, ObjectList<ClassMapping<PairedMapping>>> getType() {
            return MappingTypes.TSRG_V1;
        }

        @Override
        public Pair<ObjectList<ClassMapping<PairedMapping>>, ObjectList<PairedMapping>> process(ObjectList<String> content) {
            ObjectObjectImmutablePair<ObjectList<ClassMapping<PairedMapping>>, ObjectList<PairedMapping>> mappings = new ObjectObjectImmutablePair<ObjectList<ClassMapping<PairedMapping>>, ObjectList<PairedMapping>>(new ObjectArrayList(), new ObjectArrayList());
            int i = 0;
            int len = content.size();
            while (i < len) {
                String[] sa = ((String)content.get(i)).split(" ");
                if (sa[0].charAt(0) != '\t') {
                    if (sa[0].charAt(sa[0].length() - 1) == '/') {
                        mappings.right().add(new PairedMapping(sa[0].substring(0, sa[0].length() - 1), sa[1].substring(0, sa[1].length() - 1)));
                        ++i;
                        continue;
                    }
                    ClassMapping<PairedMapping> classMapping = new ClassMapping<PairedMapping>(new PairedMapping(sa[0], sa[1]));
                    i = 3.processTree(i, len, content, classMapping);
                    mappings.left().add(classMapping);
                    continue;
                }
                3.error();
            }
            return mappings;
        }

        private static int processTree(int index, int size, ObjectList<String> content, ClassMapping<PairedMapping> classMapping) {
            String s;
            ++index;
            while (index < size && (s = (String)content.get(index)).charAt(0) == '\t') {
                String[] sa = s.substring(1).split(" ");
                switch (sa.length) {
                    case 2: {
                        classMapping.addField(MappingUtil.Paired.o(sa[0], sa[1]));
                        break;
                    }
                    case 3: {
                        classMapping.addMethod(MappingUtil.Paired.duo(sa[0], sa[2], sa[1]));
                        break;
                    }
                    default: {
                        3.error();
                    }
                }
                ++index;
            }
            return index;
        }

        private static void error() {
            throw new IllegalArgumentException("Is this a TSRG v1 mapping file?");
        }
    };
    public static final MappingProcessor.Classified<NamespacedMapping> TSRG_V2 = new MappingProcessor.Classified<NamespacedMapping>(){

        @Override
        public MappingType<NamespacedMapping, ObjectList<ClassMapping<NamespacedMapping>>> getType() {
            return MappingTypes.TSRG_V2;
        }

        @Override
        public Pair<ObjectList<ClassMapping<NamespacedMapping>>, ObjectList<NamespacedMapping>> process(ObjectList<String> content) {
            ObjectObjectImmutablePair<ObjectList<ClassMapping<NamespacedMapping>>, ObjectList<NamespacedMapping>> mappings = new ObjectObjectImmutablePair<ObjectList<ClassMapping<NamespacedMapping>>, ObjectList<NamespacedMapping>>(new ObjectArrayList(), new ObjectArrayList());
            if (!((String)content.get(0)).startsWith("tsrg2")) {
                4.error();
            }
            String[] namespaces = ((String)content.get(0)).substring(6).split(" ");
            int i = 1;
            int len = content.size();
            while (i < len) {
                String[] sa = ((String)content.get(i)).split(" ");
                if (sa[0].charAt(0) != '\t') {
                    if (sa[0].charAt(sa[0].length() - 1) == '/') {
                        for (int j = 0; j < sa.length; ++j) {
                            sa[j] = sa[j].substring(0, sa[j].length() - 1);
                        }
                        mappings.right().add(new NamespacedMapping(namespaces, sa).setUnmappedNamespace(namespaces[0]));
                        ++i;
                        continue;
                    }
                    ClassMapping<NamespacedMapping> classMapping = new ClassMapping<NamespacedMapping>(new NamespacedMapping(namespaces, sa).setUnmappedNamespace(namespaces[0]));
                    i = 4.processTree(i, len, namespaces, content, classMapping);
                    mappings.left().add(classMapping);
                    continue;
                }
                4.error();
            }
            return mappings;
        }

        private static int processTree(int index, int size, String[] namespaces, ObjectList<String> content, ClassMapping<NamespacedMapping> classMapping) {
            String s;
            ++index;
            while (index < size && (s = (String)content.get(index)).charAt(0) == '\t') {
                String[] sa = s.substring(1).split(" ");
                switch (sa.length - namespaces.length) {
                    case 0: {
                        classMapping.addField(MappingUtil.Namespaced.o(namespaces, sa));
                        break;
                    }
                    case 1: {
                        String desc = sa[1];
                        sa[1] = sa[0];
                        if (desc.charAt(0) == '(') {
                            NamespacedMapping methodMapping = MappingUtil.Namespaced.slduo(namespaces, sa, 1, namespaces[0], desc);
                            index = 4.processTree1(index, size, namespaces, content, methodMapping);
                            classMapping.addMethod(methodMapping);
                            break;
                        }
                        classMapping.addField(MappingUtil.Namespaced.duo(namespaces, sa, 1, namespaces[0], desc));
                        break;
                    }
                    default: {
                        4.error();
                    }
                }
                ++index;
            }
            return index;
        }

        private static int processTree1(int index, int size, String[] namespaces, ObjectList<String> content, NamespacedMapping methodMapping) {
            String s;
            ++index;
            while (index < size && (s = (String)content.get(index)).charAt(1) == '\t') {
                if (s.equals("\t\tstatic")) {
                    methodMapping.getComponent(StaticIdentifiable.class).setStatic(true);
                } else {
                    String[] sa = s.substring(2).split(" ");
                    methodMapping.getComponent(LocalVariableTable.Namespaced.class).setLocalVariable(Integer.parseInt(sa[0]), new NamespacedMapping(namespaces, sa, 1));
                }
                ++index;
            }
            return index - 1;
        }

        private static void error() {
            throw new IllegalArgumentException("Is this a TSRG v2 mapping file?");
        }
    };
    public static final MappingProcessor.Classified<PairedMapping> PROGUARD = new MappingProcessor.Classified<PairedMapping>(){

        @Override
        public MappingType<PairedMapping, ObjectList<ClassMapping<PairedMapping>>> getType() {
            return MappingTypes.PROGUARD;
        }

        @Override
        public Pair<ObjectList<ClassMapping<PairedMapping>>, ObjectList<PairedMapping>> process(ObjectList<String> content) {
            ObjectObjectImmutablePair<ObjectList<ClassMapping<PairedMapping>>, ObjectList<PairedMapping>> mappings = new ObjectObjectImmutablePair<ObjectList<ClassMapping<PairedMapping>>, ObjectList<PairedMapping>>(new ObjectArrayList(), ObjectLists.emptyList());
            int i = 0;
            int len = content.size();
            while (i < len) {
                String s = (String)content.get(i);
                if (!s.startsWith("    ")) {
                    int splitIndex = s.indexOf(" -> ");
                    if (splitIndex <= 0) {
                        5.error();
                    }
                    ClassMapping<PairedMapping> classMapping = new ClassMapping<PairedMapping>(new PairedMapping(NamingUtil.asNativeName(s.substring(splitIndex + 4, s.length() - 1)), NamingUtil.asNativeName(s.substring(0, splitIndex))));
                    i = 5.processTree(i, len, content, classMapping);
                    mappings.left().add(classMapping);
                    continue;
                }
                5.error();
            }
            return mappings;
        }

        private static int processTree(int index, int size, ObjectList<String> content, ClassMapping<PairedMapping> classMapping) {
            String s;
            ++index;
            while (index < size && (s = (String)content.get(index)).startsWith("    ")) {
                if (s.contains("(") && s.contains(")")) {
                    int lineNum = s.indexOf(58);
                    int leftBracket = s.indexOf(40);
                    int rightBracket = s.lastIndexOf(41);
                    StringBuilder descriptor = new StringBuilder("(");
                    int prev = leftBracket;
                    int next = s.indexOf(44, prev + 1);
                    while (next > 0) {
                        descriptor.append(NamingUtil.java2Descriptor(s.substring(prev + 1, next)));
                        prev = next;
                        next = s.indexOf(44, prev + 1);
                    }
                    if (rightBracket - 1 != leftBracket) {
                        descriptor.append(NamingUtil.java2Descriptor(s.substring(prev + 1, rightBracket)));
                    }
                    if (lineNum > 0) {
                        int lineNum1;
                        split1 = s.indexOf(32, 11);
                        if (split1 < 0) {
                            5.error();
                        }
                        if ((lineNum1 = s.indexOf(58, lineNum + 2)) < 0) {
                            5.error();
                        }
                        classMapping.addMethod(MappingUtil.Paired.ldmo(s.substring(rightBracket + 5), s.substring(split1 + 1, leftBracket), descriptor.append(')').append(NamingUtil.java2Descriptor(s.substring(lineNum1 + 1, split1))).toString(), Integer.parseInt(s.substring(4, lineNum)), Integer.parseInt(s.substring(lineNum + 1, lineNum1))));
                    } else {
                        split1 = s.indexOf(32, 7);
                        if (split1 < 0) {
                            5.error();
                        }
                        classMapping.addMethod(MappingUtil.Paired.dmo(s.substring(rightBracket + 5), s.substring(split1 + 1, leftBracket), descriptor.append(')').append(NamingUtil.java2Descriptor(s.substring(4, split1))).toString()));
                    }
                } else {
                    int split2;
                    int split1 = s.indexOf(32, 7);
                    if (split1 < 0) {
                        5.error();
                    }
                    if ((split2 = s.indexOf(" -> ", split1 + 2)) < 0) {
                        5.error();
                    }
                    classMapping.addField(MappingUtil.Paired.dmo(s.substring(split2 + 4), s.substring(split1 + 1, split2), NamingUtil.java2Descriptor(s.substring(4, split1))));
                }
                ++index;
            }
            return index;
        }

        private static void error() {
            throw new IllegalArgumentException("Is this a Proguard mapping file?");
        }
    };
    public static final MappingProcessor.Classified<NamespacedMapping> TINY_V1 = new MappingProcessor.Classified<NamespacedMapping>(){
        private static final Function<String, Function<String, ClassMapping<NamespacedMapping>>> MAPPING_FUNC = k -> key -> new ClassMapping<NamespacedMapping>(new NamespacedMapping((String)k, (String)key).setUnmappedNamespace((String)k));

        @Override
        public MappingType<NamespacedMapping, ObjectList<ClassMapping<NamespacedMapping>>> getType() {
            return MappingTypes.TINY_V1;
        }

        @Override
        public Pair<ObjectList<ClassMapping<NamespacedMapping>>, ObjectList<NamespacedMapping>> process(ObjectList<String> content) {
            ObjectObjectImmutablePair<ObjectList<ClassMapping<NamespacedMapping>>, ObjectList<NamespacedMapping>> mappings = new ObjectObjectImmutablePair<ObjectList<ClassMapping<NamespacedMapping>>, ObjectList<NamespacedMapping>>(new ObjectArrayList(), ObjectLists.emptyList());
            Object2ObjectOpenHashMap classes = new Object2ObjectOpenHashMap();
            if (!((String)content.get(0)).startsWith("v1")) {
                6.error();
            }
            String[] namespaces = ((String)content.get(0)).substring(3).split("\t");
            String k = namespaces[0];
            content.parallelStream().skip(1L).forEach(s -> {
                String[] sa = s.split("\t");
                if (s.startsWith("CLASS")) {
                    ClassMapping<NamespacedMapping> classMapping = new ClassMapping<NamespacedMapping>(new NamespacedMapping(namespaces, sa, 1).setUnmappedNamespace(k));
                    Object2ObjectOpenHashMap object2ObjectOpenHashMap = classes;
                    synchronized (object2ObjectOpenHashMap) {
                        classes.merge(sa[1], classMapping, (o, n) -> n.addFields(o.getFields()).addMethods(o.getMethods()));
                    }
                } else if (s.startsWith("FIELD")) {
                    NamespacedMapping fieldMapping = MappingUtil.Namespaced.duo(namespaces, sa, 3, k, sa[2]);
                    Object2ObjectOpenHashMap object2ObjectOpenHashMap = classes;
                    synchronized (object2ObjectOpenHashMap) {
                        classes.computeIfAbsent(sa[1], MAPPING_FUNC.apply(k)).addField(fieldMapping);
                    }
                } else if (s.startsWith("METHOD")) {
                    NamespacedMapping methodMapping = MappingUtil.Namespaced.duo(namespaces, sa, 3, k, sa[2]);
                    Object2ObjectOpenHashMap object2ObjectOpenHashMap = classes;
                    synchronized (object2ObjectOpenHashMap) {
                        classes.computeIfAbsent(sa[1], MAPPING_FUNC.apply(k)).addMethod(methodMapping);
                    }
                } else {
                    6.error();
                }
            });
            ((ObjectList)mappings.left()).addAll(classes.values());
            return mappings;
        }

        private static void error() {
            throw new IllegalArgumentException("Is this a Tiny v1 mapping file?");
        }
    };
    public static final MappingProcessor.Classified<NamespacedMapping> TINY_V2 = new MappingProcessor.Classified<NamespacedMapping>(){

        @Override
        public MappingType<NamespacedMapping, ObjectList<ClassMapping<NamespacedMapping>>> getType() {
            return MappingTypes.TINY_V2;
        }

        @Override
        public Pair<ObjectList<ClassMapping<NamespacedMapping>>, ObjectList<NamespacedMapping>> process(ObjectList<String> content) {
            ObjectObjectImmutablePair<ObjectList<ClassMapping<NamespacedMapping>>, ObjectList<NamespacedMapping>> mappings = new ObjectObjectImmutablePair<ObjectList<ClassMapping<NamespacedMapping>>, ObjectList<NamespacedMapping>>(new ObjectArrayList(), ObjectLists.emptyList());
            if (!((String)content.get(0)).startsWith("tiny\t2\t0")) {
                7.error();
            }
            String[] namespaces = ((String)content.get(0)).substring(9).split("\t");
            int i = 1;
            int len = content.size();
            while (i < len) {
                String[] sa = ((String)content.get(i)).split("\t");
                if (sa[0].length() == 1 && sa[0].charAt(0) == 'c') {
                    ClassMapping<NamespacedMapping> classMapping = new ClassMapping<NamespacedMapping>(MappingUtil.Namespaced.d(namespaces, sa, 1));
                    i = 7.processTree(i, len, namespaces, content, classMapping);
                    mappings.left().add(classMapping);
                    continue;
                }
                7.error();
            }
            return mappings;
        }

        private static int processTree(int index, int size, String[] namespaces, ObjectList<String> content, ClassMapping<NamespacedMapping> classMapping) {
            String s;
            ++index;
            while (index < size && (s = (String)content.get(index)).charAt(0) == '\t') {
                String[] sa = s.substring(3).split("\t");
                switch (s.charAt(1)) {
                    case 'c': {
                        ((NamespacedMapping)classMapping.mapping).getComponent(Documented.class).setDoc(sa[0]);
                        break;
                    }
                    case 'f': {
                        NamespacedMapping fieldMapping = MappingUtil.Namespaced.dduo(namespaces, sa, 1, namespaces[0], sa[0]);
                        index = 7.processTree1(index, size, namespaces, content, fieldMapping);
                        classMapping.addField(fieldMapping);
                        break;
                    }
                    case 'm': {
                        NamespacedMapping methodMapping = MappingUtil.Namespaced.dlduo(namespaces, sa, 1, namespaces[0], sa[0]);
                        index = 7.processTree1(index, size, namespaces, content, methodMapping);
                        classMapping.addMethod(methodMapping);
                        break;
                    }
                    default: {
                        7.error();
                    }
                }
                ++index;
            }
            return index;
        }

        private static int processTree1(int index, int size, String[] namespaces, ObjectList<String> content, NamespacedMapping mapping) {
            String s;
            ++index;
            while (index < size && (s = (String)content.get(index)).charAt(1) == '\t' && s.charAt(0) == '\t') {
                switch (s.charAt(2)) {
                    case 'c': {
                        mapping.getComponent(Documented.class).setDoc(s.substring(4));
                        break;
                    }
                    case 'p': {
                        String[] sa = s.substring(4).split("\t");
                        NamespacedMapping localVariable = MappingUtil.Namespaced.d(namespaces, sa, 1);
                        mapping.getComponent(LocalVariableTable.Namespaced.class).setLocalVariable(Integer.parseInt(sa[0]), localVariable);
                        index = 7.processTree2(index, size, content, localVariable);
                        break;
                    }
                    default: {
                        7.error();
                    }
                }
                ++index;
            }
            return index - 1;
        }

        private static int processTree2(int index, int size, ObjectList<String> content, NamespacedMapping localVariable) {
            String s;
            if (++index < size && (s = (String)content.get(index)).charAt(2) == '\t' && s.charAt(1) == '\t' && s.charAt(0) == '\t') {
                if (s.charAt(3) == 'c') {
                    localVariable.getComponent(Documented.class).setDoc(s.substring(5));
                } else {
                    7.error();
                }
                return index;
            }
            return index - 1;
        }

        private static void error() {
            throw new IllegalArgumentException("Is this a Tiny v2 mapping file?");
        }
    };
}

