/*
 * Decompiled with CFR 0.152.
 */
package cn.maxpixel.mcdecompiler.reader;

import cn.maxpixel.mcdecompiler.deps.fastutil.Pair;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.ObjectArrayList;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.ObjectList;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.ObjectLists;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.ObjectObjectImmutablePair;
import cn.maxpixel.mcdecompiler.mapping.Mapping;
import cn.maxpixel.mcdecompiler.mapping.collection.ClassMapping;
import cn.maxpixel.mcdecompiler.mapping.collection.UniqueMapping;
import cn.maxpixel.mcdecompiler.mapping.type.MappingType;

public interface MappingProcessor<T extends Mapping, C> {
    public MappingType<T, C> getType();

    default public boolean supportPackage() {
        return this.getType().supportPackage();
    }

    public Pair<C, ObjectList<T>> process(ObjectList<String> var1);

    public Pair<C, ObjectList<T>> process(ObjectList<String> ... var1);

    public static interface Classified<T extends Mapping>
    extends MappingProcessor<T, ObjectList<ClassMapping<T>>> {
        @Override
        default public Pair<ObjectList<ClassMapping<T>>, ObjectList<T>> process(ObjectList<String> ... contents) {
            ObjectObjectImmutablePair<ObjectList<ClassMapping<T>>, ObjectList<T>> pair = new ObjectObjectImmutablePair<ObjectList<ClassMapping<T>>, ObjectList<T>>(new ObjectArrayList(), this.supportPackage() ? new ObjectArrayList() : ObjectLists.emptyList());
            for (ObjectList<String> content : contents) {
                Pair result = this.process(content);
                pair.left().addAll((ObjectList)result.left());
                if (!this.supportPackage()) continue;
                pair.right().addAll(result.right());
            }
            return pair;
        }
    }

    public static interface Unique<T extends Mapping>
    extends MappingProcessor<T, UniqueMapping<T>> {
        @Override
        default public Pair<UniqueMapping<T>, ObjectList<T>> process(ObjectList<String> ... contents) {
            ObjectObjectImmutablePair<UniqueMapping<T>, ObjectList<T>> pair = new ObjectObjectImmutablePair<UniqueMapping<T>, ObjectList<T>>(new UniqueMapping(), this.supportPackage() ? new ObjectArrayList() : ObjectLists.emptyList());
            for (ObjectList<String> content : contents) {
                Pair result = this.process(content);
                pair.left().classes.addAll(((UniqueMapping)result.left()).classes);
                pair.left().fields.addAll(((UniqueMapping)result.left()).fields);
                pair.left().methods.addAll(((UniqueMapping)result.left()).methods);
                if (!this.supportPackage()) continue;
                pair.right().addAll(result.right());
            }
            return pair;
        }
    }
}

