/*
 * Decompiled with CFR 0.152.
 */
package cn.maxpixel.mcdecompiler.reader;

import cn.maxpixel.mcdecompiler.deps.fastutil.Pair;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.ObjectArrayList;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.ObjectList;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.ObjectLists;
import cn.maxpixel.mcdecompiler.mapping.Mapping;
import cn.maxpixel.mcdecompiler.mapping.type.MappingType;
import cn.maxpixel.mcdecompiler.util.IOUtil;
import cn.maxpixel.mcdecompiler.util.Logging;
import cn.maxpixel.mcdecompiler.util.Utils;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.logging.Logger;

public abstract class AbstractMappingReader<M extends Mapping, R, T extends MappingType<M, R>> {
    protected static final Logger LOGGER = Logging.getLogger();
    public final T type;
    public final R mappings;
    public final ObjectList<M> packages;

    public AbstractMappingReader(T type, BufferedReader reader) {
        this.type = (MappingType)Objects.requireNonNull(type);
        Objects.requireNonNull(reader);
        try (BufferedReader bufferedReader = reader;){
            LOGGER.finer("Reading file");
            ObjectArrayList<String> lines = reader.lines().map(s -> {
                if (s.charAt(0) == '#' || s.isBlank()) {
                    return null;
                }
                int index = s.indexOf(35);
                if (index > 0) {
                    return s.substring(0, index);
                }
                if (index == 0) {
                    return null;
                }
                return s;
            }).filter(Objects::nonNull).collect(ObjectArrayList.toList());
            LOGGER.finest("Read file");
            LOGGER.fine("Processing content");
            Pair result = type.getProcessor().process((ObjectList<String>)lines);
            LOGGER.finest("Processed content");
            this.mappings = result.left();
            this.packages = type.supportPackage() ? result.right() : ObjectLists.emptyList();
        }
        catch (IOException e) {
            throw Utils.wrapInRuntime(e);
        }
    }

    public AbstractMappingReader(T type, Reader rd) {
        this(type, IOUtil.asBufferedReader(rd));
    }

    public AbstractMappingReader(T type, InputStream is) {
        this(type, (Reader)new InputStreamReader(is, StandardCharsets.UTF_8));
    }

    public AbstractMappingReader(T type, String path) throws FileNotFoundException {
        this(type, (InputStream)new FileInputStream(path));
    }

    public AbstractMappingReader(T type, BufferedReader ... readers) {
        this.type = (MappingType)Objects.requireNonNull(type);
        LOGGER.finer("Reading files");
        ObjectArrayList[] contents = Utils.mapArray(readers, ObjectArrayList[]::new, reader -> {
            ObjectArrayList objectArrayList;
            block8: {
                BufferedReader bufferedReader = reader;
                try {
                    objectArrayList = reader.lines().map(s -> {
                        if (s.charAt(0) == '#' || s.isBlank()) {
                            return null;
                        }
                        int index = s.indexOf(35);
                        if (index > 0) {
                            return s.substring(0, index);
                        }
                        if (index == 0) {
                            return null;
                        }
                        return s;
                    }).filter(Objects::nonNull).collect(ObjectArrayList.toList());
                    if (bufferedReader == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (bufferedReader != null) {
                            try {
                                bufferedReader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw Utils.wrapInRuntime(e);
                    }
                }
                bufferedReader.close();
            }
            return objectArrayList;
        });
        LOGGER.finest("Read files");
        LOGGER.fine("Processing contents");
        Pair result = type.getProcessor().process(contents);
        LOGGER.finest("Processed contents");
        this.mappings = result.left();
        this.packages = type.supportPackage() ? result.right() : ObjectLists.emptyList();
    }

    public AbstractMappingReader(T type, Reader ... rd) {
        this(type, Utils.mapArray(rd, BufferedReader[]::new, IOUtil::asBufferedReader));
    }

    public AbstractMappingReader(T type, InputStream ... is) {
        this(type, Utils.mapArray(is, InputStreamReader[]::new, i -> new InputStreamReader((InputStream)i, StandardCharsets.UTF_8)));
    }

    public AbstractMappingReader(T type, String ... path) throws FileNotFoundException {
        this(type, Utils.mapArray(path, FileInputStream[]::new, FileInputStream::new));
    }

    public boolean isNamespaced() {
        return this.type.isNamespaced();
    }

    public boolean supportPackage() {
        return this.type.supportPackage();
    }
}

