/*
 * Decompiled with CFR 0.152.
 */
package cn.maxpixel.mcdecompiler.mapping.component;

import cn.maxpixel.mcdecompiler.asm.ClassifiedMappingRemapper;
import cn.maxpixel.mcdecompiler.deps.fastutil.ints.Int2ObjectOpenHashMap;
import cn.maxpixel.mcdecompiler.deps.fastutil.ints.IntSet;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.ObjectCollection;
import cn.maxpixel.mcdecompiler.mapping.NameGetter;
import cn.maxpixel.mcdecompiler.mapping.NamespacedMapping;
import cn.maxpixel.mcdecompiler.mapping.PairedMapping;
import cn.maxpixel.mcdecompiler.mapping.component.Component;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public class LocalVariableTable
implements Component {
    @NotNull
    private final Int2ObjectOpenHashMap<PairedMapping> lvt = new Int2ObjectOpenHashMap();
    @NotNull
    private final IntSet keys = this.lvt.keySet();
    @NotNull
    private final @NotNull ObjectCollection<@NotNull PairedMapping> values = this.lvt.values();

    public PairedMapping getLocalVariable(@Range(from=0L, to=255L) int index) {
        return this.lvt.get(index);
    }

    public void setLocalVariable(@Range(from=0L, to=255L) int index, @Nullable(value="To remove the previous mapping") @Nullable(value="To remove the previous mapping") PairedMapping mapping) {
        this.lvt.put(index, mapping);
    }

    @NotNull
    public IntSet getLocalVariableIndexes() {
        return this.keys;
    }

    public void reverseAll(ClassifiedMappingRemapper remapper) {
        this.values.forEach(v -> v.reverse(remapper));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LocalVariableTable)) {
            return false;
        }
        LocalVariableTable that = (LocalVariableTable)o;
        return Objects.equals(this.lvt, that.lvt);
    }

    public int hashCode() {
        return Objects.hashCode(this.lvt);
    }

    public static class Namespaced
    implements Component,
    NameGetter.Namespaced {
        private String unmappedNamespace;
        private String mappedNamespace;
        @NotNull
        private final Int2ObjectOpenHashMap<NamespacedMapping> lvt = new Int2ObjectOpenHashMap();
        @NotNull
        private final IntSet keys = this.lvt.keySet();
        @NotNull
        private final @NotNull ObjectCollection<@NotNull NamespacedMapping> values = this.lvt.values();

        public NamespacedMapping getLocalVariable(@Range(from=0L, to=255L) int index) {
            return this.lvt.get(index);
        }

        public void setLocalVariable(@Range(from=0L, to=255L) int index, @Nullable(value="To remove the previous mapping") @Nullable(value="To remove the previous mapping") NamespacedMapping mapping) {
            this.lvt.put(index, mapping);
        }

        @NotNull
        public IntSet getLocalVariableIndexes() {
            return this.keys;
        }

        public void swapAll(@NotNull String fromNamespace, @NotNull String toNamespace, ClassifiedMappingRemapper remapper) {
            this.values.forEach(value -> value.swap(remapper, fromNamespace, toNamespace));
        }

        @Override
        public String getUnmappedNamespace() {
            return this.unmappedNamespace;
        }

        @Override
        public String getMappedNamespace() {
            return this.mappedNamespace;
        }

        public Namespaced setUnmappedNamespace(@NotNull String namespace) {
            this.unmappedNamespace = Objects.requireNonNull(namespace);
            this.values.forEach(v -> v.setMappedNamespace(this.unmappedNamespace));
            return this;
        }

        @Override
        public void setMappedNamespace(@NotNull String namespace) {
            this.mappedNamespace = Objects.requireNonNull(namespace);
            this.values.forEach(v -> v.setMappedNamespace(this.mappedNamespace));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Namespaced)) {
                return false;
            }
            Namespaced that = (Namespaced)o;
            return Objects.equals(this.unmappedNamespace, that.unmappedNamespace) && Objects.equals(this.mappedNamespace, that.mappedNamespace) && Objects.equals(this.lvt, that.lvt);
        }

        public int hashCode() {
            return Objects.hash(this.unmappedNamespace, this.mappedNamespace, this.lvt);
        }
    }
}

