/*
 * Decompiled with CFR 0.152.
 */
package cn.maxpixel.mcdecompiler.mapping.component;

import cn.maxpixel.mcdecompiler.asm.ClassifiedMappingRemapper;
import cn.maxpixel.mcdecompiler.mapping.component.Component;
import java.util.Objects;
import org.intellij.lang.annotations.Subst;
import org.jetbrains.annotations.NotNull;

public class Descriptor
implements Component {
    @Subst(value="()V")
    @NotNull
    public String unmappedDescriptor;

    public Descriptor(@NotNull String unmappedDescriptor) {
        this.unmappedDescriptor = Objects.requireNonNull(unmappedDescriptor);
    }

    public void reverseUnmapped(ClassifiedMappingRemapper remapper) {
        this.unmappedDescriptor = remapper.getMappedDescByUnmappedDesc(this.unmappedDescriptor);
    }

    @NotNull
    public String getUnmappedDescriptor() {
        return this.unmappedDescriptor;
    }

    public void setUnmappedDescriptor(@NotNull String unmappedDescriptor) {
        this.unmappedDescriptor = Objects.requireNonNull(unmappedDescriptor);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Descriptor)) {
            return false;
        }
        Descriptor that = (Descriptor)o;
        return this.unmappedDescriptor.equals(that.unmappedDescriptor);
    }

    public int hashCode() {
        return this.unmappedDescriptor.hashCode();
    }

    public static class Namespaced
    extends Descriptor {
        @NotNull
        public String descriptorNamespace;

        public Namespaced(@NotNull String unmappedDescriptor, @NotNull String descriptorNamespace) {
            super(unmappedDescriptor);
            this.descriptorNamespace = Objects.requireNonNull(descriptorNamespace);
        }

        @NotNull
        public String getDescriptorNamespace() {
            return this.descriptorNamespace;
        }

        public void setDescriptorNamespace(@NotNull String descriptorNamespace) {
            this.descriptorNamespace = Objects.requireNonNull(descriptorNamespace);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Namespaced)) {
                return false;
            }
            Namespaced that = (Namespaced)o;
            if (!super.equals(o)) {
                return false;
            }
            return this.descriptorNamespace.equals(that.descriptorNamespace);
        }

        @Override
        public int hashCode() {
            return 31 * super.hashCode() + this.descriptorNamespace.hashCode();
        }
    }

    public static class Mapped
    implements Component {
        @Subst(value="()V")
        @NotNull
        public String mappedDescriptor;

        public Mapped(@NotNull String mappedDescriptor) {
            this.mappedDescriptor = Objects.requireNonNull(mappedDescriptor);
        }

        public void reverseMapped(ClassifiedMappingRemapper remapper) {
            this.mappedDescriptor = remapper.getUnmappedDescByMappedDesc(this.mappedDescriptor);
        }

        @NotNull
        public String getMappedDescriptor() {
            return this.mappedDescriptor;
        }

        public void setMappedDescriptor(@NotNull String mappedDescriptor) {
            this.mappedDescriptor = Objects.requireNonNull(mappedDescriptor);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Mapped)) {
                return false;
            }
            Mapped mapped = (Mapped)o;
            return this.mappedDescriptor.equals(mapped.mappedDescriptor);
        }

        public int hashCode() {
            return this.mappedDescriptor.hashCode();
        }
    }
}

