/*
 * Decompiled with CFR 0.152.
 */
package cn.maxpixel.mcdecompiler.mapping.collection;

import cn.maxpixel.mcdecompiler.asm.ClassifiedMappingRemapper;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.Object2ObjectOpenHashMap;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.ObjectArrayList;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.ObjectList;
import cn.maxpixel.mcdecompiler.mapping.Mapping;
import cn.maxpixel.mcdecompiler.mapping.NameGetter;
import cn.maxpixel.mcdecompiler.mapping.NamespacedMapping;
import cn.maxpixel.mcdecompiler.mapping.PairedMapping;
import cn.maxpixel.mcdecompiler.mapping.component.Descriptor;
import cn.maxpixel.mcdecompiler.mapping.component.Owned;
import cn.maxpixel.mcdecompiler.util.NamingUtil;
import cn.maxpixel.mcdecompiler.util.Utils;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;

public class ClassMapping<T extends Mapping> {
    public T mapping;
    private final ObjectArrayList<T> methods = new ObjectArrayList();
    private final ObjectArrayList<T> fields = new ObjectArrayList();

    public ClassMapping(T mapping) {
        this.mapping = (Mapping)Objects.requireNonNull(mapping);
    }

    public ClassMapping<T> addFields(T ... fields) {
        for (T field : fields) {
            this.addField(field);
        }
        return this;
    }

    public ClassMapping<T> addFields(Collection<? extends T> fields) {
        fields.forEach(this::addField);
        return this;
    }

    public ClassMapping<T> addMethods(T ... methods) {
        for (T method : methods) {
            this.addMethod(method);
        }
        return this;
    }

    public ClassMapping<T> addMethods(Collection<? extends T> methods) {
        methods.forEach(this::addMethod);
        return this;
    }

    public ClassMapping<T> addField(T field) {
        if (!((Mapping)field).hasComponent(Owned.class)) {
            throw new UnsupportedOperationException();
        }
        ((Mapping)field).getComponent(Owned.class).setOwner(this);
        this.fields.add(field);
        return this;
    }

    public ClassMapping<T> addMethod(T method) {
        if (!((Mapping)method).hasComponent(Owned.class)) {
            throw new UnsupportedOperationException();
        }
        if (!(((Mapping)method).hasComponent(Descriptor.class) || ((Mapping)method).hasComponent(Descriptor.Mapped.class) || ((Mapping)method).hasComponent(Descriptor.Namespaced.class))) {
            throw new UnsupportedOperationException();
        }
        ((Mapping)method).getComponent(Owned.class).setOwner(this);
        this.methods.add(method);
        return this;
    }

    public ObjectList<T> getMethods() {
        return this.methods;
    }

    public ObjectList<T> getFields() {
        return this.fields;
    }

    public static void reverse(ObjectList<ClassMapping<PairedMapping>> mappings) {
        ClassMapping.reverse(mappings, null);
    }

    public static void reverse(ObjectList<ClassMapping<PairedMapping>> mappings, ObjectList<PairedMapping> packages) {
        if (mappings != null && !mappings.isEmpty()) {
            ClassifiedMappingRemapper remapper = new ClassifiedMappingRemapper(mappings);
            mappings.parallelStream().forEach(cm -> ClassMapping.reverse(cm, remapper));
        }
        if (packages != null && !packages.isEmpty()) {
            packages.parallelStream().forEach(PairedMapping::reverse);
        }
    }

    public static void reverse(ClassMapping<PairedMapping> mapping, ClassifiedMappingRemapper remapper) {
        ((PairedMapping)mapping.mapping).reverse(remapper);
        mapping.getMethods().forEach(m -> m.reverse(remapper));
        mapping.getFields().forEach(m -> m.reverse(remapper));
    }

    public static void swap(ObjectList<ClassMapping<NamespacedMapping>> mappings, String targetNamespace) {
        ClassMapping.swap(Objects.requireNonNull(mappings), (ObjectList<NamespacedMapping>)null, targetNamespace);
    }

    public static void swap(ObjectList<ClassMapping<NamespacedMapping>> mappings, String sourceNamespace, String targetNamespace) {
        ClassMapping.swap(mappings, null, sourceNamespace, targetNamespace);
    }

    public static void swap(ObjectList<ClassMapping<NamespacedMapping>> mappings, ObjectList<NamespacedMapping> packages, String targetNamespace) {
        ClassMapping.swap(Objects.requireNonNull(mappings), packages, NamingUtil.findSourceNamespace(mappings), targetNamespace);
    }

    public static void swap(ObjectList<ClassMapping<NamespacedMapping>> mappings, ObjectList<NamespacedMapping> packages, String sourceNamespace, String targetNamespace) {
        if (mappings != null && !mappings.isEmpty()) {
            ClassifiedMappingRemapper remapper = new ClassifiedMappingRemapper(mappings, sourceNamespace, targetNamespace);
            mappings.parallelStream().forEach(cm -> ClassMapping.swap(cm, remapper, sourceNamespace, targetNamespace));
        }
        if (packages != null && !packages.isEmpty()) {
            packages.parallelStream().forEach(nm -> nm.swap(sourceNamespace, targetNamespace));
        }
    }

    @ApiStatus.Internal
    public static ClassMapping<NamespacedMapping> swap(ClassMapping<NamespacedMapping> mapping, ClassifiedMappingRemapper remapper, String sourceNamespace, String targetNamespace) {
        ((NamespacedMapping)mapping.mapping).swap(remapper, sourceNamespace, targetNamespace);
        mapping.getFields().forEach(m -> m.swap(remapper, sourceNamespace, targetNamespace));
        mapping.getMethods().forEach(m -> m.swap(remapper, sourceNamespace, targetNamespace));
        return mapping;
    }

    public static Object2ObjectOpenHashMap<String, Object2ObjectOpenHashMap<String, PairedMapping>> genFieldsByUnmappedNameMap(ObjectList<ClassMapping<PairedMapping>> mapping) {
        return mapping.parallelStream().collect(Collectors.toMap(cm -> ((PairedMapping)cm.mapping).unmappedName, cm -> cm.getFields().parallelStream().collect(Collectors.toMap(m -> m.unmappedName, Function.identity(), Utils::onKeyDuplicate, Object2ObjectOpenHashMap::new)), Utils::onKeyDuplicate, Object2ObjectOpenHashMap::new));
    }

    public static Object2ObjectOpenHashMap<String, ClassMapping<PairedMapping>> genMappingsByUnmappedNameMap(ObjectList<ClassMapping<PairedMapping>> mapping) {
        return mapping.parallelStream().collect(Collectors.toMap(cm -> ((PairedMapping)cm.mapping).unmappedName, Function.identity(), Utils::onKeyDuplicate, Object2ObjectOpenHashMap::new));
    }

    public static Object2ObjectOpenHashMap<String, ClassMapping<PairedMapping>> genMappingsByMappedNameMap(ObjectList<ClassMapping<PairedMapping>> mapping) {
        return mapping.parallelStream().collect(Collectors.toMap(cm -> ((PairedMapping)cm.mapping).mappedName, Function.identity(), Utils::onKeyDuplicate, Object2ObjectOpenHashMap::new));
    }

    public static Object2ObjectOpenHashMap<String, ClassMapping<NamespacedMapping>> genMappingsByNamespaceMap(ObjectList<ClassMapping<NamespacedMapping>> mapping, String namespace) {
        return mapping.parallelStream().collect(Collectors.toMap(m -> ((NamespacedMapping)m.mapping).getName(namespace), Function.identity(), Utils::onKeyDuplicate, Object2ObjectOpenHashMap::new));
    }

    public static void setMappedNamespace(ClassMapping<? extends NameGetter.Namespaced> cm, String namespace) {
        ((NameGetter.Namespaced)cm.mapping).setMappedNamespace(namespace);
        cm.fields.forEach(m -> ((NameGetter.Namespaced)((Object)m)).setMappedNamespace(namespace));
        cm.methods.forEach(m -> ((NameGetter.Namespaced)((Object)m)).setMappedNamespace(namespace));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClassMapping)) {
            return false;
        }
        ClassMapping that = (ClassMapping)o;
        return ((Mapping)this.mapping).equals(that.mapping) && this.methods.equals((Object)that.methods) && this.fields.equals((Object)that.fields);
    }

    public int hashCode() {
        return Objects.hash(this.mapping, this.methods, this.fields);
    }

    public String toString() {
        return "ClassMapping{mapping=" + this.mapping + ", methods=" + this.methods + ", fields=" + this.fields + "}";
    }
}

