/*
 * Decompiled with CFR 0.152.
 */
package cn.maxpixel.mcdecompiler.mapping;

import cn.maxpixel.mcdecompiler.asm.ClassifiedMappingRemapper;
import cn.maxpixel.mcdecompiler.mapping.Mapping;
import cn.maxpixel.mcdecompiler.mapping.component.Component;
import cn.maxpixel.mcdecompiler.mapping.component.Descriptor;
import cn.maxpixel.mcdecompiler.mapping.component.LocalVariableTable;
import cn.maxpixel.mcdecompiler.mapping.component.Owned;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;

public class PairedMapping
extends Mapping {
    public String unmappedName;
    public String mappedName;

    public PairedMapping(String unmappedName, String mappedName, Component ... components) {
        super(components);
        this.unmappedName = unmappedName;
        this.mappedName = mappedName;
    }

    public PairedMapping(String unmappedName, String mappedName) {
        this.unmappedName = unmappedName;
        this.mappedName = mappedName;
    }

    public PairedMapping(Component ... components) {
        super(components);
    }

    public PairedMapping() {
    }

    public Owned<PairedMapping> getOwned() {
        return this.getComponent(Owned.class);
    }

    public PairedMapping reverse() {
        String temp = this.unmappedName;
        this.unmappedName = this.mappedName;
        this.mappedName = temp;
        return this;
    }

    @ApiStatus.Internal
    public void reverse(ClassifiedMappingRemapper remapper) {
        this.reverse();
        boolean supportDesc = this.hasComponent(Descriptor.class);
        boolean supportDescMapped = this.hasComponent(Descriptor.Mapped.class);
        if (supportDesc) {
            Descriptor unmapped = this.getComponent(Descriptor.class);
            if (supportDescMapped) {
                Descriptor.Mapped mapped = this.getComponent(Descriptor.Mapped.class);
                String desc = unmapped.unmappedDescriptor;
                unmapped.unmappedDescriptor = mapped.mappedDescriptor;
                mapped.mappedDescriptor = desc;
            } else {
                unmapped.reverseUnmapped(remapper);
            }
        } else if (supportDescMapped) {
            this.getComponent(Descriptor.Mapped.class).reverseMapped(remapper);
        }
        if (this.hasComponent(LocalVariableTable.class)) {
            this.getComponent(LocalVariableTable.class).reverseAll(remapper);
        }
    }

    @Override
    public String getUnmappedName() {
        return this.unmappedName;
    }

    public void setUnmappedName(String unmappedName) {
        this.unmappedName = unmappedName;
    }

    @Override
    public String getMappedName() {
        return this.mappedName;
    }

    public void setMappedName(String mappedName) {
        this.mappedName = mappedName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PairedMapping)) {
            return false;
        }
        PairedMapping that = (PairedMapping)o;
        if (!super.equals(o)) {
            return false;
        }
        return this.unmappedName.equals(that.unmappedName) && this.mappedName.equals(that.mappedName);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hash(this.unmappedName, this.mappedName);
    }

    @Override
    public String toString() {
        return "PairedMapping{unmappedName='" + this.unmappedName + "', mappedName='" + this.mappedName + "'} " + super.toString();
    }
}

