/*
 * Decompiled with CFR 0.152.
 */
package cn.maxpixel.mcdecompiler.mapping;

import cn.maxpixel.mcdecompiler.asm.ClassifiedMappingRemapper;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.ObjectSet;
import cn.maxpixel.mcdecompiler.mapping.Mapping;
import cn.maxpixel.mcdecompiler.mapping.NameGetter;
import cn.maxpixel.mcdecompiler.mapping.component.Component;
import cn.maxpixel.mcdecompiler.mapping.component.Descriptor;
import cn.maxpixel.mcdecompiler.mapping.component.LocalVariableTable;
import cn.maxpixel.mcdecompiler.mapping.component.Owned;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NamespacedMapping
extends Mapping
implements NameGetter.Namespaced {
    public static final String OBF = "obf";
    public static final String SRG = "srg";
    public static final String OFFICIAL = "official";
    public static final String INTERMEDIARY = "intermediary";
    public static final String YARN = "named";
    private String unmappedNamespace;
    private String mappedNamespace;
    private final Object2ObjectLinkedOpenHashMap<String, String> names = new Object2ObjectLinkedOpenHashMap();

    public NamespacedMapping(Map<String, String> names) {
        if (names.containsKey(null)) {
            throw new IllegalArgumentException();
        }
        this.names.putAll(names);
    }

    public NamespacedMapping(String namespace, String name) {
        this.names.put(Objects.requireNonNull(namespace), name);
    }

    public NamespacedMapping(String[] namespaces, String[] names) {
        if (namespaces.length != names.length) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < namespaces.length; ++i) {
            this.names.put(Objects.requireNonNull(namespaces[i]), names[i]);
        }
    }

    public NamespacedMapping() {
    }

    public NamespacedMapping(String[] namespaces, String[] names, int nameStart) {
        if (nameStart < 0 || nameStart >= names.length || namespaces.length != names.length - nameStart) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < namespaces.length; ++i) {
            this.names.put(Objects.requireNonNull(namespaces[i]), names[i + nameStart]);
        }
    }

    public NamespacedMapping(Map<String, String> names, Component ... components) {
        super(components);
        if (names.containsKey(null)) {
            throw new IllegalArgumentException();
        }
        this.names.putAll(names);
    }

    public NamespacedMapping(String namespace, String name, Component ... components) {
        super(components);
        this.names.put(Objects.requireNonNull(namespace), name);
    }

    public NamespacedMapping(String[] namespaces, String[] names, Component ... components) {
        super(components);
        if (namespaces.length != names.length) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < namespaces.length; ++i) {
            this.names.put(Objects.requireNonNull(namespaces[i]), names[i]);
        }
    }

    public NamespacedMapping(Component ... components) {
        super(components);
    }

    public NamespacedMapping(String[] namespaces, String[] names, int nameStart, Component ... components) {
        super(components);
        if (nameStart < 0 || nameStart >= names.length || namespaces.length != names.length - nameStart) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < namespaces.length; ++i) {
            this.names.put(Objects.requireNonNull(namespaces[i]), names[i + nameStart]);
        }
    }

    public Owned<NamespacedMapping> getOwned() {
        return this.getComponent(Owned.class);
    }

    @NotNull
    public ObjectSet<String> getNamespaces() {
        return this.names.keySet();
    }

    public void setName(@NotNull String namespace, @Nullable String name) {
        this.names.put(Objects.requireNonNull(namespace), name);
    }

    public String getName(@NotNull String namespace) {
        return this.names.get(Objects.requireNonNull(namespace));
    }

    public String getName(@NotNull String namespace, @Nullable String defaultValue) {
        return this.names.getOrDefault(Objects.requireNonNull(namespace), defaultValue);
    }

    public NamespacedMapping swap(@NotNull String fromNamespace, @NotNull String toNamespace) {
        this.names.put(Objects.requireNonNull(toNamespace), this.names.put(Objects.requireNonNull(fromNamespace), this.names.get(toNamespace)));
        return this;
    }

    @ApiStatus.Internal
    public void swap(ClassifiedMappingRemapper remapper, String fromNamespace, String toNamespace) {
        this.swap(fromNamespace, toNamespace);
        if (this.hasComponent(Descriptor.Namespaced.class)) {
            Descriptor.Namespaced n = this.getComponent(Descriptor.Namespaced.class);
            if (!n.getDescriptorNamespace().equals(fromNamespace)) {
                throw new IllegalArgumentException();
            }
            n.reverseUnmapped(remapper);
        }
        if (this.hasComponent(LocalVariableTable.Namespaced.class)) {
            this.getComponent(LocalVariableTable.Namespaced.class).swapAll(fromNamespace, toNamespace, remapper);
        }
    }

    public boolean contains(@NotNull String namespace) {
        return this.names.containsKey(Objects.requireNonNull(namespace));
    }

    @Override
    public String getUnmappedName() {
        if (this.unmappedNamespace == null) {
            throw new IllegalStateException("Set a namespace for unmapped name first");
        }
        return this.names.get(this.unmappedNamespace);
    }

    @Override
    public String getMappedName() {
        if (this.mappedNamespace == null) {
            throw new IllegalStateException("Set a namespace for mapped name first");
        }
        return this.names.get(this.mappedNamespace);
    }

    @Override
    public String getUnmappedNamespace() {
        return this.unmappedNamespace;
    }

    @Override
    public String getMappedNamespace() {
        return this.mappedNamespace;
    }

    public NamespacedMapping setUnmappedNamespace(@NotNull String namespace) {
        this.unmappedNamespace = Objects.requireNonNull(namespace);
        return this;
    }

    @Override
    public void setMappedNamespace(@NotNull String namespace) {
        this.mappedNamespace = Objects.requireNonNull(namespace);
        LocalVariableTable.Namespaced n = this.getComponent(LocalVariableTable.Namespaced.class);
        if (n != null) {
            n.setMappedNamespace(namespace);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NamespacedMapping)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NamespacedMapping that = (NamespacedMapping)o;
        return this.names.equals(that.names);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hash(this.names);
    }

    @Override
    public String toString() {
        return "NamespacedMapping{names=" + this.names + "} " + super.toString();
    }
}

