/*
 * Decompiled with CFR 0.152.
 */
package cn.maxpixel.mcdecompiler.mapping;

import cn.maxpixel.mcdecompiler.deps.fastutil.objects.Object2ObjectOpenHashMap;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.ObjectCollection;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.ObjectCollections;
import cn.maxpixel.mcdecompiler.mapping.NameGetter;
import cn.maxpixel.mcdecompiler.mapping.component.Component;
import cn.maxpixel.mcdecompiler.mapping.component.Owned;
import org.jetbrains.annotations.NotNull;

public abstract class Mapping
implements NameGetter {
    private final Object2ObjectOpenHashMap<Class<? extends Component>, Component> components = new Object2ObjectOpenHashMap();

    protected Mapping(Component ... components) {
        for (Component component : components) {
            this.components.put(component.getClass(), component);
        }
    }

    protected Mapping() {
    }

    public final <C extends Component> C getComponent(@NotNull Class<? super C> component) {
        return (C)this.components.get(component);
    }

    protected Owned<? extends Mapping> getOwned() {
        return this.getComponent(Owned.class);
    }

    public final boolean hasComponent(@NotNull Class<? extends Component> component) {
        return this.components.containsKey(component);
    }

    @NotNull
    public final ObjectCollection<? extends Component> getComponents() {
        return ObjectCollections.unmodifiable(this.components.values());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Mapping)) {
            return false;
        }
        Mapping mapping = (Mapping)o;
        return this.components.equals(mapping.components);
    }

    public int hashCode() {
        return this.components.hashCode();
    }

    public String toString() {
        return "Mapping{components=" + this.components + "}";
    }
}

