/*
 * Decompiled with CFR 0.152.
 */
package cn.maxpixel.mcdecompiler.decompiler.thread;

import java.util.EnumMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.util.TextUtil;

class ThreadedLogger
extends IFernflowerLogger {
    private static final EnumMap<IFernflowerLogger.Severity, Level> LEVEL_MAP = new EnumMap(IFernflowerLogger.Severity.class);
    private final Logger logger;
    private final ThreadLocal<AtomicInteger> indent = ThreadLocal.withInitial(AtomicInteger::new);

    public ThreadedLogger(Logger logger) {
        this.logger = logger;
    }

    public void writeMessage(String message, IFernflowerLogger.Severity severity) {
        Level l = LEVEL_MAP.get(severity);
        if (this.accepts(severity) && this.logger.isLoggable(l)) {
            this.logger.log(l, "{0}: {1}{2}{3}", new Object[]{Thread.currentThread().getName(), severity.prefix, TextUtil.getIndentString((int)this.indent.get().get()), message});
        }
    }

    public void writeMessage(String message, IFernflowerLogger.Severity severity, Throwable t) {
        Level l = LEVEL_MAP.get(severity);
        if (this.accepts(severity) && this.logger.isLoggable(l)) {
            this.writeMessage(message, severity);
            this.logger.log(l, null, t);
        }
    }

    public void startProcessingClass(String className) {
        if (this.accepts(IFernflowerLogger.Severity.INFO)) {
            this.writeMessage("PreProcessing class " + className, IFernflowerLogger.Severity.INFO);
            this.indent.get().incrementAndGet();
        }
    }

    public void endProcessingClass() {
        if (this.accepts(IFernflowerLogger.Severity.INFO)) {
            this.indent.get().decrementAndGet();
            this.writeMessage("... done", IFernflowerLogger.Severity.INFO);
        }
    }

    public void startReadingClass(String className) {
        if (this.accepts(IFernflowerLogger.Severity.INFO)) {
            this.writeMessage("Decompiling class " + className, IFernflowerLogger.Severity.INFO);
            this.indent.get().incrementAndGet();
        }
    }

    public void endReadingClass() {
        if (this.accepts(IFernflowerLogger.Severity.INFO)) {
            this.indent.get().decrementAndGet();
            this.writeMessage("... done", IFernflowerLogger.Severity.INFO);
        }
    }

    public void startClass(String className) {
        if (this.accepts(IFernflowerLogger.Severity.INFO)) {
            this.writeMessage("Processing class " + className, IFernflowerLogger.Severity.TRACE);
            this.indent.get().decrementAndGet();
        }
    }

    public void endClass() {
        if (this.accepts(IFernflowerLogger.Severity.INFO)) {
            this.indent.get().decrementAndGet();
            this.writeMessage("... proceeded", IFernflowerLogger.Severity.TRACE);
        }
    }

    public void startMethod(String methodName) {
        if (this.accepts(IFernflowerLogger.Severity.INFO)) {
            this.writeMessage("Processing method " + methodName, IFernflowerLogger.Severity.TRACE);
            this.indent.get().decrementAndGet();
        }
    }

    public void endMethod() {
        if (this.accepts(IFernflowerLogger.Severity.INFO)) {
            this.indent.get().decrementAndGet();
            this.writeMessage("... proceeded", IFernflowerLogger.Severity.TRACE);
        }
    }

    public void startWriteClass(String className) {
        if (this.accepts(IFernflowerLogger.Severity.INFO)) {
            this.writeMessage("Writing class " + className, IFernflowerLogger.Severity.TRACE);
            this.indent.get().decrementAndGet();
        }
    }

    public void endWriteClass() {
        if (this.accepts(IFernflowerLogger.Severity.INFO)) {
            this.indent.get().decrementAndGet();
            this.writeMessage("... written", IFernflowerLogger.Severity.TRACE);
        }
    }

    static {
        LEVEL_MAP.put(IFernflowerLogger.Severity.TRACE, Level.FINEST);
        LEVEL_MAP.put(IFernflowerLogger.Severity.INFO, Level.FINE);
        LEVEL_MAP.put(IFernflowerLogger.Severity.WARN, Level.WARNING);
        LEVEL_MAP.put(IFernflowerLogger.Severity.ERROR, Level.WARNING);
    }
}

