/*
 * Decompiled with CFR 0.152.
 */
package cn.maxpixel.mcdecompiler.decompiler.thread;

import cn.maxpixel.mcdecompiler.deps.fastutil.objects.Object2ObjectOpenHashMap;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.ObjectLists;
import cn.maxpixel.mcdecompiler.util.Logging;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.logging.Logger;
import org.benf.cfr.reader.api.CfrDriver;
import org.benf.cfr.reader.util.getopt.OptionsImpl;

public class CFRDecompileThread
extends Thread {
    private final String source;
    private final String target;
    private final String libs;

    public CFRDecompileThread(String source, String target, String libs) {
        super("CFR-Decompile");
        this.source = source;
        this.target = target;
        this.libs = libs;
    }

    @Override
    public void run() {
        Object2ObjectOpenHashMap<String, String> options = new Object2ObjectOpenHashMap<String, String>();
        options.put(OptionsImpl.FORCE_AGGRESSIVE_EXCEPTION_AGG.getName(), "true");
        options.put(OptionsImpl.CLOBBER_FILES.getName(), "true");
        options.put(OptionsImpl.ECLIPSE.getName(), "false");
        options.put(OptionsImpl.EXTRA_CLASS_PATH.getName(), this.libs);
        options.put(OptionsImpl.OUTPUT_PATH.getName(), this.target);
        options.put(OptionsImpl.REMOVE_BAD_GENERICS.getName(), "false");
        options.put(OptionsImpl.REMOVE_DEAD_CONDITIONALS.getName(), "false");
        options.put(OptionsImpl.JAR_FILTER.getName(), "^(net\\.minecraft|com\\.mojang\\.(blaze3d|math|realmsclient))\\.*");
        CfrDriver cfr = new CfrDriver.Builder().withOptions(options).build();
        PrintStream sysErr = System.err;
        System.setErr(new PrintStream(new OutputStream(){
            private static final Logger LOGGER = Logging.getLogger("CFR");

            @Override
            public void write(int b) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void write(byte[] b, int off, int len) {
                LOGGER.fine(() -> new String(b, off, len - 1));
            }
        }));
        cfr.analyse(ObjectLists.singleton(this.source));
        System.setErr(sysErr);
    }
}

