/*
 * Decompiled with CFR 0.152.
 */
package cn.maxpixel.mcdecompiler.decompiler;

import cn.maxpixel.mcdecompiler.Properties;
import cn.maxpixel.mcdecompiler.decompiler.IDecompiler;
import cn.maxpixel.mcdecompiler.decompiler.ILibRecommendedDecompiler;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.ObjectArrayList;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.ObjectList;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.ObjectLists;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.ObjectSet;
import cn.maxpixel.mcdecompiler.util.FileUtil;
import cn.maxpixel.mcdecompiler.util.Utils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class UserDefinedDecompiler
implements ILibRecommendedDecompiler {
    public static final String NAME = "user-defined";
    public static final UserDefinedDecompiler NONE = new UserDefinedDecompiler(){

        @Override
        public void decompile(@NotNull Path source, @NotNull Path target) {
            throw new RuntimeException("User decompiler not found. Please make sure you have put correct config file in \"decompiler\" directory");
        }
    };
    private IDecompiler.SourceType sourceType;
    private Path decompilerPath;
    private List<String> options;
    private ObjectList<String> libs = ObjectLists.emptyList();

    private UserDefinedDecompiler() {
    }

    UserDefinedDecompiler(@NotNull IDecompiler.SourceType sourceType, @NotNull Path decompilerPath, @NotNull List<String> options) {
        this.sourceType = sourceType;
        this.decompilerPath = FileUtil.requireExist(decompilerPath);
        this.options = options;
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    @NotNull
    public IDecompiler.SourceType getSourceType() {
        return this.sourceType;
    }

    @Override
    public void decompile(@NotNull Path source, @NotNull Path target) throws IOException {
        this.checkArgs(source, target);
        ObjectArrayList<String> arrayList = new ObjectArrayList<String>();
        arrayList.add("java");
        arrayList.add("-jar");
        arrayList.add(this.decompilerPath.toString());
        arrayList.addAll((ObjectList<String>)this.resolveArgs(source, target, this.options));
        Utils.waitForProcess(Runtime.getRuntime().exec(arrayList.toArray((K[])new String[0])));
    }

    private ObjectArrayList<String> resolveArgs(@NotNull Path source, @NotNull Path target, @NotNull List<String> options) {
        ObjectArrayList<String> resolvedOptions = new ObjectArrayList<String>();
        for (int i = 0; i < options.size(); ++i) {
            String s = options.get(i);
            if (s.contains("%source%")) {
                s = s.replace("%source%", source.toString());
            }
            if (s.contains("%target%")) {
                s = s.replace("%target%", target.toString());
            }
            if (s.contains("%lib_all%")) {
                s = s.replace("%lib_all%", String.join((CharSequence)File.pathSeparator, this.libs));
            }
            if (s.contains("%abstract_params%")) {
                Path p = Properties.TEMP_DIR.resolve("fernflower_abstract_parameter_names.txt").toAbsolutePath().normalize();
                s = s.replace("%abstract_params%", Files.exists(p, new LinkOption[0]) ? p.toString() : "");
            }
            if (s.contains("%lib_repeat%")) {
                for (int j = 0; j < this.libs.size(); ++j) {
                    if (s.equals("%lib_repeat%")) {
                        resolvedOptions.add(options.get(i - 1));
                        resolvedOptions.add((String)this.libs.get(j));
                        continue;
                    }
                    resolvedOptions.add(s.replace("%lib_repeat%", (CharSequence)this.libs.get(j)));
                }
                continue;
            }
            resolvedOptions.add(s);
        }
        return resolvedOptions;
    }

    @Override
    public void receiveLibs(@NotNull ObjectSet<Path> libs) {
        this.libs = libs.stream().map(p -> p.toAbsolutePath().normalize().toString()).collect(ObjectArrayList.toListWithExpectedSize(libs.size()));
    }
}

