/*
 * Decompiled with CFR 0.152.
 */
package cn.maxpixel.mcdecompiler.decompiler;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;

public interface IDecompiler {
    public String name();

    public SourceType getSourceType();

    public void decompile(@NotNull Path var1, @NotNull Path var2) throws IOException;

    default public void checkArgs(@NotNull Path source, @NotNull Path target) {
        if (!Files.isDirectory(target, new LinkOption[0])) {
            throw new IllegalArgumentException("target must be directory");
        }
        if (this.getSourceType() == SourceType.FILE && Files.isDirectory(source, new LinkOption[0])) {
            throw new IllegalArgumentException("source must be file");
        }
        if (this.getSourceType() == SourceType.DIRECTORY && !Files.isDirectory(source, new LinkOption[0])) {
            throw new IllegalArgumentException("source must be directory!");
        }
    }

    public static enum SourceType {
        FILE,
        DIRECTORY;

    }
}

