/*
 * Decompiled with CFR 0.152.
 */
package cn.maxpixel.mcdecompiler.decompiler;

import cn.maxpixel.mcdecompiler.Info;
import cn.maxpixel.mcdecompiler.Properties;
import cn.maxpixel.mcdecompiler.decompiler.IDecompiler;
import cn.maxpixel.mcdecompiler.decompiler.IExternalResourcesDecompiler;
import cn.maxpixel.mcdecompiler.decompiler.ILibRecommendedDecompiler;
import cn.maxpixel.mcdecompiler.decompiler.thread.ExternalJarClassLoader;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.ObjectSet;
import cn.maxpixel.mcdecompiler.util.DownloadingUtil;
import cn.maxpixel.mcdecompiler.util.Logging;
import cn.maxpixel.mcdecompiler.util.Utils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.logging.Level;
import org.jetbrains.annotations.NotNull;

public class ForgeFlowerDecompiler
implements IExternalResourcesDecompiler,
ILibRecommendedDecompiler {
    private static final String VERSION = Properties.getProperty("ForgeFlower-Version", "forgeflower.version");
    private static final URI RESOURCE = URI.create("https://maven.minecraftforge.net/net/minecraftforge/forgeflower/" + VERSION + "/forgeflower-" + VERSION + ".jar");
    private static final URI RESOURCE_HASH = URI.create("https://maven.minecraftforge.net/net/minecraftforge/forgeflower/" + VERSION + "/forgeflower-" + VERSION + ".jar.sha1");
    public static final String FERNFLOWER_ABSTRACT_PARAMETER_NAMES = "fernflower_abstract_parameter_names.txt";
    public static final String NAME = "forgeflower";
    private File[] libs = new File[0];
    private Path decompilerJarPath;

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public IDecompiler.SourceType getSourceType() {
        return IDecompiler.SourceType.DIRECTORY;
    }

    @Override
    public void extractTo(Path extractPath) throws IOException {
        this.decompilerJarPath = extractPath.resolve("decompiler.jar");
        Files.copy(DownloadingUtil.getRemoteResource(Properties.getDownloadedDecompilerPath(Info.DecompilerType.FORGEFLOWER), RESOURCE, RESOURCE_HASH), this.decompilerJarPath, StandardCopyOption.REPLACE_EXISTING);
    }

    @Override
    public void decompile(@NotNull Path source, @NotNull Path target) throws IOException {
        this.checkArgs(source, target);
        try (ExternalJarClassLoader cl = new ExternalJarClassLoader(new URL[]{this.decompilerJarPath.toUri().toURL()});){
            Path abstractMethodParameterNames = Properties.TEMP_DIR.resolve(FERNFLOWER_ABSTRACT_PARAMETER_NAMES);
            File[] sources = Files.exists(abstractMethodParameterNames, new LinkOption[0]) ? new File[]{source.toFile(), abstractMethodParameterNames.toAbsolutePath().normalize().toFile()} : new File[]{source.toFile()};
            Thread thread = (Thread)cl.loadClass("cn.maxpixel.mcdecompiler.decompiler.thread.ForgeFlowerDecompileThread").getConstructor(File[].class, File[].class, File.class).newInstance(sources, this.libs, target.toFile());
            thread.start();
            while (thread.isAlive()) {
                Thread.onSpinWait();
            }
        }
        catch (ReflectiveOperationException e) {
            Logging.getLogger().log(Level.SEVERE, "Failed to load ForgeFlower", e);
            throw Utils.wrapInRuntime(e);
        }
    }

    @Override
    public void receiveLibs(@NotNull ObjectSet<Path> libs) {
        this.libs = (File[])libs.stream().map(Path::toFile).toArray(File[]::new);
    }
}

