/*
 * Decompiled with CFR 0.152.
 */
package cn.maxpixel.mcdecompiler.decompiler;

import cn.maxpixel.mcdecompiler.decompiler.IDecompiler;
import cn.maxpixel.mcdecompiler.decompiler.UserDefinedDecompiler;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.Object2ObjectOpenHashMap;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.ObjectImmutableList;
import cn.maxpixel.mcdecompiler.util.Logging;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Decompilers {
    private static final Logger LOGGER = Logging.getLogger("Decompiler Manager");
    private static final Object2ObjectOpenHashMap<String, IDecompiler> decompilers = new Object2ObjectOpenHashMap();

    private static UserDefinedDecompiler findUserDefined() {
        Path path = Path.of("decompiler", "decompiler.properties");
        if (Files.exists(path, new LinkOption[0])) {
            UserDefinedDecompiler userDefinedDecompiler;
            block9: {
                BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);
                try {
                    Properties decompilerProperties = new Properties();
                    decompilerProperties.load(reader);
                    String decompilerPath = Objects.requireNonNull(decompilerProperties.getProperty("decompiler-file"), "decompiler-file is a required property");
                    String sourceType = Objects.requireNonNull(decompilerProperties.getProperty("source-type"), "source-type is a required property").toUpperCase(Locale.ROOT);
                    String[] args = Objects.requireNonNull(decompilerProperties.getProperty("args"), "args is a required property").split(" ");
                    userDefinedDecompiler = new UserDefinedDecompiler(IDecompiler.SourceType.valueOf(sourceType), Path.of("decompiler", decompilerPath).toAbsolutePath().normalize(), ObjectImmutableList.of(args));
                    if (reader == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, "Error occurred when constructing the user-defined decompiler", e);
                    }
                }
                reader.close();
            }
            return userDefinedDecompiler;
        }
        return UserDefinedDecompiler.NONE;
    }

    public static IDecompiler get(String name) {
        return decompilers.get(name);
    }

    static {
        for (IDecompiler d : ServiceLoader.load(IDecompiler.class)) {
            decompilers.put(d.name(), d);
        }
        decompilers.put("user-defined", Decompilers.findUserDefined());
    }
}

