/*
 * Decompiled with CFR 0.152.
 */
package cn.maxpixel.mcdecompiler.decompiler;

import cn.maxpixel.mcdecompiler.Info;
import cn.maxpixel.mcdecompiler.Properties;
import cn.maxpixel.mcdecompiler.decompiler.IDecompiler;
import cn.maxpixel.mcdecompiler.decompiler.IExternalResourcesDecompiler;
import cn.maxpixel.mcdecompiler.decompiler.ILibRecommendedDecompiler;
import cn.maxpixel.mcdecompiler.decompiler.thread.ExternalJarClassLoader;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.ObjectOpenHashSet;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.ObjectSet;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.ObjectSets;
import cn.maxpixel.mcdecompiler.util.DownloadingUtil;
import cn.maxpixel.mcdecompiler.util.Logging;
import cn.maxpixel.mcdecompiler.util.Utils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.logging.Level;
import org.jetbrains.annotations.NotNull;

public class CFRDecompiler
implements IExternalResourcesDecompiler,
ILibRecommendedDecompiler {
    private static final String VERSION = Properties.getProperty("CFR-Version", "cfr.version");
    private static final URI RESOURCE = URI.create("https://repo1.maven.org/maven2/org/benf/cfr/" + VERSION + "/cfr-" + VERSION + ".jar");
    private static final URI RESOURCE_HASH = URI.create("https://repo1.maven.org/maven2/org/benf/cfr/" + VERSION + "/cfr-" + VERSION + ".jar.sha1");
    private ObjectSet<String> libs = ObjectSets.emptySet();
    private Path decompilerJarPath;
    public static final String NAME = "cfr";

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public IDecompiler.SourceType getSourceType() {
        return IDecompiler.SourceType.FILE;
    }

    @Override
    public void decompile(@NotNull Path source, @NotNull Path target) throws IOException {
        this.checkArgs(source, target);
        try (ExternalJarClassLoader cl = new ExternalJarClassLoader(new URL[]{this.decompilerJarPath.toUri().toURL()});){
            Thread thread = (Thread)cl.loadClass("cn.maxpixel.mcdecompiler.decompiler.thread.CFRDecompileThread").getConstructor(String.class, String.class, String.class).newInstance(source.toString(), target.toString(), String.join((CharSequence)File.pathSeparator, this.libs));
            thread.start();
            while (thread.isAlive()) {
                Thread.onSpinWait();
            }
        }
        catch (ReflectiveOperationException e) {
            Logging.getLogger().log(Level.SEVERE, "Failed to load CFR", e);
            throw Utils.wrapInRuntime(e);
        }
    }

    @Override
    public void extractTo(Path extractPath) throws IOException {
        this.decompilerJarPath = extractPath.resolve("decompiler.jar");
        Files.copy(DownloadingUtil.getRemoteResource(Properties.getDownloadedDecompilerPath(Info.DecompilerType.CFR), RESOURCE, RESOURCE_HASH), this.decompilerJarPath, StandardCopyOption.REPLACE_EXISTING);
    }

    @Override
    public void receiveLibs(@NotNull ObjectSet<Path> libs) {
        this.libs = libs.stream().map(p -> p.toAbsolutePath().normalize().toString()).collect(ObjectOpenHashSet.toSetWithExpectedSize(libs.size()));
    }
}

