/*
 * Decompiled with CFR 0.152.
 */
package cn.maxpixel.mcdecompiler.asm.variable;

import cn.maxpixel.mcdecompiler.asm.variable.ForgeFlowerAbstractParametersRecorder;
import cn.maxpixel.mcdecompiler.asm.variable.Renamer;
import cn.maxpixel.mcdecompiler.asm.variable.VariableNameHandler;
import cn.maxpixel.mcdecompiler.asm.variable.VariableNameProvider;
import cn.maxpixel.mcdecompiler.deps.asm.ClassVisitor;
import cn.maxpixel.mcdecompiler.deps.asm.Handle;
import cn.maxpixel.mcdecompiler.deps.asm.Label;
import cn.maxpixel.mcdecompiler.deps.asm.MethodVisitor;
import cn.maxpixel.mcdecompiler.deps.asm.Type;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.Object2ObjectOpenHashMap;
import cn.maxpixel.mcdecompiler.util.Logging;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VariableNameProcessor
extends ClassVisitor {
    private static final Logger LOGGER = Logging.getLogger();
    private final Object2ObjectOpenHashMap<String, Renamer> sharedRenamers = new Object2ObjectOpenHashMap();
    @NotNull
    private final ForgeFlowerAbstractParametersRecorder recorder;
    @NotNull
    private final VariableNameHandler handler;
    @NotNull
    private final String className;
    private final boolean regenerate;

    public VariableNameProcessor(@Nullable ClassVisitor classVisitor, @NotNull ForgeFlowerAbstractParametersRecorder recorder, @NotNull VariableNameHandler handler, @NotNull String className, boolean regenerate) {
        super(589824, classVisitor);
        this.recorder = recorder;
        this.handler = handler;
        this.className = className;
        this.regenerate = regenerate;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        if ((access & 0x400) != 0 && this.recorder.isRecording() && descriptor.charAt(1) != ')') {
            this.recorder.record(this.className, name, descriptor, this.handler.handleAbstractMethod(access, name, descriptor, signature, exceptions), this.handler.omitThis());
            return super.visitMethod(access, name, descriptor, signature, exceptions);
        }
        VariableNameProvider.RenameFunction func = this.handler.handleMethod(access, name, descriptor, signature, exceptions);
        String method = name.concat(descriptor);
        Renamer renamer = this.regenerate ? ((access & 2) != 0 && (access & 0x1000) != 0 ? this.sharedRenamers.getOrDefault(method, new Renamer()) : new Renamer()) : null;
        return new MethodProcessor(super.visitMethod(access, name, descriptor, signature, exceptions), func, renamer, method, (access & 8) == 0);
    }

    public class MethodProcessor
    extends MethodVisitor {
        private final VariableNameProvider.RenameFunction renameFunction;
        private final Renamer renamer;
        private final String method;
        private final boolean notStatic;
        private final boolean omitThis;
        private boolean skip;

        public MethodProcessor(MethodVisitor methodVisitor, VariableNameProvider.RenameFunction renameFunction, Renamer renamer, String method, boolean notStatic) {
            super(589824, methodVisitor);
            this.renameFunction = renameFunction;
            this.renamer = renamer;
            this.method = method;
            this.notStatic = notStatic;
            this.omitThis = VariableNameProcessor.this.handler.omitThis();
        }

        @Override
        public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
            super.visitInvokeDynamicInsn(name, descriptor, bootstrapMethodHandle, bootstrapMethodArguments);
            if (this.skip) {
                return;
            }
            switch (bootstrapMethodHandle.getOwner()) {
                case "java/lang/runtime/ObjectMethods": {
                    this.skip = true;
                    break;
                }
                case "java/lang/invoke/LambdaMetafactory": {
                    if (!VariableNameProcessor.this.regenerate) {
                        return;
                    }
                    Handle lambdaImpl = (Handle)bootstrapMethodArguments[1];
                    if (!lambdaImpl.getOwner().equals(VariableNameProcessor.this.className) || VariableNameProcessor.this.sharedRenamers.putIfAbsent(lambdaImpl.getName().concat(lambdaImpl.getDesc()), this.renamer) != null) break;
                    LOGGER.log(Level.FINEST, "Method {0} is going to share renamer with {1}{2}", new Object[]{this.method, lambdaImpl.getName(), lambdaImpl.getDesc()});
                }
            }
        }

        @Override
        public void visitLocalVariable(String name, String descriptor, String signature, Label start, Label end, int index) {
            if (this.skip || index == 0 && this.notStatic) {
                super.visitLocalVariable(name, descriptor, signature, start, end, index);
            } else {
                String newName;
                String string = this.renameFunction != null ? this.renameFunction.getName(name, descriptor, signature, start, end, this.notStatic && this.omitThis ? index - 1 : index) : (newName = null);
                super.visitLocalVariable(VariableNameProcessor.this.regenerate ? (newName != null ? this.renamer.addExistingName(newName) : this.renamer.getVarName(Type.getType(descriptor))) : (newName != null ? newName : name), descriptor, signature, start, end, index);
            }
        }
    }
}

