/*
 * Decompiled with CFR 0.152.
 */
package cn.maxpixel.mcdecompiler.asm.variable;

import cn.maxpixel.mcdecompiler.asm.variable.VariableNameProvider;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.ObjectArrayList;

public class VariableNameHandler {
    private final ObjectArrayList<VariableNameProvider> providers = new ObjectArrayList();
    private boolean omitThis;

    public void addProvider(VariableNameProvider provider) {
        this.providers.add(provider);
    }

    public VariableNameProvider.RenameFunction handleMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        if (this.providers.isEmpty()) {
            return VariableNameProvider.RenameFunction.NOP;
        }
        ObjectArrayList<VariableNameProvider.RenameFunction> functions = new ObjectArrayList<VariableNameProvider.RenameFunction>();
        for (VariableNameProvider provider : this.providers) {
            VariableNameProvider.RenameFunction function = provider.forMethod(access, name, descriptor, signature, exceptions);
            if (function == VariableNameProvider.RenameFunction.NOP) continue;
            functions.add(function);
        }
        return (originalName, descriptor1, signature1, start, end, index) -> {
            for (VariableNameProvider.RenameFunction function : functions) {
                String n = function.getName(originalName, descriptor1, signature1, start, end, index);
                if (n == null) continue;
                return n;
            }
            return null;
        };
    }

    public VariableNameProvider.RenameAbstractFunction handleAbstractMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        if (this.providers.isEmpty()) {
            return VariableNameProvider.RenameAbstractFunction.NOP;
        }
        ObjectArrayList<VariableNameProvider.RenameAbstractFunction> functions = new ObjectArrayList<VariableNameProvider.RenameAbstractFunction>();
        for (VariableNameProvider provider : this.providers) {
            VariableNameProvider.RenameAbstractFunction function = provider.forAbstractMethod(access, name, descriptor, signature, exceptions);
            if (function == VariableNameProvider.RenameAbstractFunction.NOP) continue;
            functions.add(function);
        }
        return (index, type) -> {
            for (VariableNameProvider.RenameAbstractFunction function : functions) {
                String n = function.getName(index, type);
                if (n == null) continue;
                return n;
            }
            return null;
        };
    }

    public void setOmitThis() {
        this.omitThis = true;
    }

    public boolean omitThis() {
        return this.omitThis;
    }
}

