/*
 * Decompiled with CFR 0.152.
 */
package cn.maxpixel.mcdecompiler.asm.variable;

import cn.maxpixel.mcdecompiler.deps.asm.Type;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.Object2IntOpenHashMap;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.Serializable;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public class Renamer {
    private static final Object2ObjectOpenHashMap<String, Holder> PREDEF = new Object2ObjectOpenHashMap();
    private final Object2IntOpenHashMap<String> vars = new Object2IntOpenHashMap();

    public Renamer() {
        this.vars.defaultReturnValue(0);
    }

    public String addExistingName(String name) {
        if (this.vars.addTo(name, 1) > 0) {
            throw new IllegalArgumentException("Duplicated var name");
        }
        return name;
    }

    public String getVarName(Type type) {
        int count;
        Holder holder;
        boolean isArray = false;
        if (type.getSort() == 9) {
            type = type.getElementType();
            isArray = true;
        }
        Object varBaseName = type.getClassName();
        if (type.getSort() == 10) {
            varBaseName = ((String)varBaseName).substring(((String)varBaseName).lastIndexOf(46) + 1);
        }
        Holder holder2 = holder = isArray ? null : PREDEF.get(varBaseName);
        if (holder != null) {
            int i = 0;
            while (true) {
                for (String s : holder.names) {
                    if (i < this.vars.getInt(s)) continue;
                    int j = this.vars.addTo(s, 1);
                    return s + (Serializable)(j == 0 && holder.skipZero ? "" : Integer.valueOf(j));
                }
                ++i;
            }
        }
        varBaseName = ((String)varBaseName).replace('$', '_').toLowerCase(Locale.ENGLISH);
        if (isArray) {
            varBaseName = "a" + (String)varBaseName;
        }
        return (String)varBaseName + (Serializable)((count = this.vars.addTo((String)varBaseName, 1)) > 0 ? Integer.valueOf(count) : "");
    }

    static {
        Holder h = new Holder("i", "j", "k", "l");
        PREDEF.put("int", h);
        PREDEF.put("long", h);
        PREDEF.put("byte", new Holder(false, "b"));
        PREDEF.put("char", new Holder(false, "c"));
        PREDEF.put("short", new Holder(false, "short"));
        PREDEF.put("double", new Holder(false, "d"));
        PREDEF.put("boolean", new Holder("flag"));
        PREDEF.put("float", new Holder("f"));
        PREDEF.put("String", new Holder("s"));
        PREDEF.put("Class", new Holder("oclass"));
        PREDEF.put("Long", new Holder("olong"));
        PREDEF.put("Byte", new Holder("obyte"));
        PREDEF.put("Short", new Holder("oshort"));
        PREDEF.put("Boolean", new Holder("obool"));
        PREDEF.put("Float", new Holder("ofloat"));
        PREDEF.put("Double", new Holder("odouble"));
        PREDEF.put("Package", new Holder("opackage"));
        PREDEF.put("Enum", new Holder("oenum"));
        PREDEF.put("Void", new Holder("ovoid"));
    }

    private record Holder(boolean skipZero, @NotNull String[] names) {
        private Holder(String ... names) {
            this(true, names);
        }
    }
}

