/*
 * Decompiled with CFR 0.152.
 */
package cn.maxpixel.mcdecompiler.asm.variable;

import cn.maxpixel.mcdecompiler.asm.variable.VariableNameProvider;
import cn.maxpixel.mcdecompiler.deps.asm.ClassVisitor;
import cn.maxpixel.mcdecompiler.deps.asm.RecordComponentVisitor;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.ObjectArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class RecordNameRemapper
extends ClassVisitor
implements VariableNameProvider {
    private final ObjectArrayList<String> recordNames = new ObjectArrayList();
    private final StringBuilder recordDesc = new StringBuilder("(");
    private boolean done;

    public RecordNameRemapper(ClassVisitor classVisitor) {
        super(589824, classVisitor);
    }

    @Override
    public RecordComponentVisitor visitRecordComponent(String name, String descriptor, String signature) {
        this.recordNames.add(name);
        this.recordDesc.append(descriptor);
        return super.visitRecordComponent(name, descriptor, signature);
    }

    @Override
    @NotNull
    public VariableNameProvider.RenameFunction forMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        if (name.equals("<init>")) {
            if (!this.done) {
                this.recordDesc.append(")V");
                this.done = true;
            }
            if (descriptor.contentEquals(this.recordDesc)) {
                AtomicInteger i = new AtomicInteger();
                return (originalName, descriptor1, signature1, start, end, index) -> {
                    if (index > 0 && i.get() < this.recordNames.size()) {
                        return this.recordNames.get(i.getAndIncrement());
                    }
                    return null;
                };
            }
        }
        return VariableNameProvider.RenameFunction.NOP;
    }
}

