/*
 * Decompiled with CFR 0.152.
 */
package cn.maxpixel.mcdecompiler.asm;

import cn.maxpixel.mcdecompiler.deps.asm.AnnotationVisitor;
import cn.maxpixel.mcdecompiler.deps.asm.ClassVisitor;
import cn.maxpixel.mcdecompiler.deps.asm.MethodVisitor;
import cn.maxpixel.mcdecompiler.util.DescriptorUtil;
import cn.maxpixel.mcdecompiler.util.Logging;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.intellij.lang.annotations.Subst;

public class RuntimeParameterAnnotationFixer
extends ClassVisitor {
    private static final Logger LOGGER = Logging.getLogger();
    private int removeCount;
    private final String className;
    private String toProcess;

    public RuntimeParameterAnnotationFixer(ClassVisitor classVisitor, String className, int access) {
        super(589824, classVisitor);
        this.className = className;
        if ((access & 0x4000) != 0) {
            this.removeCount = 2;
            this.toProcess = "(Ljava/lang/String;I";
            LOGGER.log(Level.FINER, "Fixing class {0} because it is an enum", className);
        }
    }

    @Override
    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        if (this.toProcess == null && name.equals(this.className) && (access & 0x208) == 0 && innerName != null) {
            if (outerName == null) {
                int i = this.className.lastIndexOf(36);
                if (i != -1) {
                    this.removeCount = 1;
                    String s = this.className.substring(0, i);
                    this.toProcess = "(L" + s + ";";
                    LOGGER.log(Level.FINER, "Fixing class {0} as its name appears to be an inner class of {1}", new Object[]{name, s});
                }
            } else {
                this.removeCount = 1;
                this.toProcess = "(L" + outerName + ";";
                LOGGER.log(Level.FINER, "Fixing class {0} as its an inner class of {1}", new Object[]{name, outerName});
            }
        }
        super.visitInnerClass(name, outerName, innerName, access);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, final @Subst(value="(Ljava/lang/String;I)V") String descriptor, String signature, String[] exceptions) {
        if (this.toProcess != null && "<init>".equals(name) && descriptor.startsWith(this.toProcess)) {
            return new MethodVisitor(589824, super.visitMethod(access, name, descriptor, signature, exceptions)){
                private final int params;
                private boolean processVisible;
                private boolean processInvisible;
                {
                    super(arg0, arg1);
                    this.params = DescriptorUtil.getArgumentCount(descriptor);
                }

                @Override
                public void visitAnnotableParameterCount(int parameterCount, boolean visible) {
                    if (this.params == parameterCount) {
                        LOGGER.log(Level.FINEST, "Found {0} extra Runtime{1}isibleParameterAnnotations, try removing...", new Object[]{RuntimeParameterAnnotationFixer.this.removeCount, visible ? "V" : "Inv"});
                        if (visible) {
                            this.processVisible = true;
                        } else {
                            this.processInvisible = true;
                        }
                        super.visitAnnotableParameterCount(parameterCount - RuntimeParameterAnnotationFixer.this.removeCount, visible);
                    } else {
                        super.visitAnnotableParameterCount(parameterCount, visible);
                    }
                }

                @Override
                public AnnotationVisitor visitParameterAnnotation(int parameter, String descriptor2, boolean visible) {
                    if (this.processVisible && visible) {
                        if (parameter >= RuntimeParameterAnnotationFixer.this.removeCount) {
                            return super.visitParameterAnnotation(parameter - RuntimeParameterAnnotationFixer.this.removeCount, descriptor2, true);
                        }
                        LOGGER.log(Level.FINEST, "Dropped an annotation(descriptor={0}) on synthetic param {1}", new Object[]{descriptor2, parameter});
                        return null;
                    }
                    if (this.processInvisible && !visible) {
                        if (parameter >= RuntimeParameterAnnotationFixer.this.removeCount) {
                            return super.visitParameterAnnotation(parameter - RuntimeParameterAnnotationFixer.this.removeCount, descriptor2, false);
                        }
                        LOGGER.log(Level.FINEST, "Dropped an annotation(descriptor={0}) on synthetic param {1}", new Object[]{descriptor2, parameter});
                        return null;
                    }
                    return super.visitParameterAnnotation(parameter, descriptor2, visible);
                }
            };
        }
        return super.visitMethod(access, name, descriptor, signature, exceptions);
    }
}

