/*
 * Decompiled with CFR 0.152.
 */
package cn.maxpixel.mcdecompiler.asm;

import cn.maxpixel.mcdecompiler.asm.ClassifiedMappingRemapper;
import cn.maxpixel.mcdecompiler.asm.ExtraClassesInformation;
import cn.maxpixel.mcdecompiler.deps.asm.AnnotationVisitor;
import cn.maxpixel.mcdecompiler.deps.asm.ClassVisitor;
import cn.maxpixel.mcdecompiler.deps.asm.MethodVisitor;
import cn.maxpixel.mcdecompiler.deps.asm.Type;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.Object2ObjectMaps;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.Object2ObjectOpenHashMap;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.ObjectSet;
import cn.maxpixel.mcdecompiler.mapping.PairedMapping;
import cn.maxpixel.mcdecompiler.mapping.collection.ClassMapping;
import cn.maxpixel.mcdecompiler.mapping.component.Descriptor;
import cn.maxpixel.mcdecompiler.util.MixinTargetSelector;
import cn.maxpixel.mcdecompiler.util.Utils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class MixinClassRemapper
extends ClassVisitor {
    private final ClassifiedMappingRemapper remapper;
    private final ExtraClassesInformation info;
    private final Map<String, Map<String, String>> refMap;
    private final ObjectSet<String> skipped;
    private final String className;
    private boolean mixin;

    public MixinClassRemapper(ClassVisitor classVisitor, ClassifiedMappingRemapper remapper, ExtraClassesInformation info, Map<String, Map<String, String>> refMap, ObjectSet<String> skipped, String className) {
        super(589824, classVisitor);
        this.remapper = remapper;
        this.info = info;
        this.refMap = refMap;
        this.skipped = skipped;
        this.className = className;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        if ("Lorg/spongepowered/asm/mixin/Mixin;".equals(descriptor)) {
            this.mixin = true;
            return new AnnotationVisitor(this.api, super.visitAnnotation(descriptor, visible)){

                @Override
                public AnnotationVisitor visitArray(String name) {
                    if ("targets".equals(name)) {
                        return new AnnotationVisitor(this.api, super.visitArray(name)){

                            @Override
                            public void visit(String name, Object value) {
                                if (!(value instanceof String)) {
                                    throw new IllegalArgumentException();
                                }
                                String s = (String)value;
                                super.visit(name, MixinClassRemapper.this.remapper.map(((Map)MixinClassRemapper.this.refMap.getOrDefault(MixinClassRemapper.this.className, Object2ObjectMaps.emptyMap())).getOrDefault(s, s)));
                            }
                        };
                    }
                    return super.visitArray(name);
                }
            };
        }
        return super.visitAnnotation(descriptor, visible);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        if (this.mixin && !this.skipped.contains(name.concat(descriptor))) {
            return new MethodVisitor(this.api, super.visitMethod(access, name, descriptor, signature, exceptions)){

                @Override
                public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                    AnnotationVisitor av = super.visitAnnotation(descriptor, visible);
                    return switch (descriptor) {
                        case "Lorg/spongepowered/asm/mixin/injection/Redirect;", "Lorg/spongepowered/asm/mixin/injection/Inject;", "Lorg/spongepowered/asm/mixin/injection/ModifyVariable;" -> new MixinMethodRemapper(this.api, av);
                        default -> av;
                    };
                }
            };
        }
        return super.visitMethod(access, name, descriptor, signature, exceptions);
    }

    private String remapMethodSelector(String s) {
        if (s.charAt(s.length() - 1) != '/' && s.charAt(0) != '@' && !s.contains("<")) {
            String s1 = ((Map)this.refMap.getOrDefault(this.className, Object2ObjectMaps.emptyMap())).getOrDefault(s, s);
            MixinTargetSelector selector = MixinTargetSelector.parse(s1);
            return Optional.ofNullable(selector.owner()).map(Type::getInternalName).map(List::of).or(() -> Optional.ofNullable(this.info.getSuperNames(this.className))).filter(owners -> selector.name() != null).flatMap(owners -> selector.field() ? Optional.of(owners.parallelStream().map(this.remapper::getClassByUnmappedName).flatMap(cm -> cm.getFields().stream()).collect(Collectors.toMap(cm -> cm.unmappedName, Function.identity(), Utils::onKeyDuplicate, Object2ObjectOpenHashMap::new))).map(map -> (PairedMapping)map.get(selector.name())) : owners.parallelStream().map(this.remapper::getClassByUnmappedName).filter(Objects::nonNull).map(ClassMapping::getMethods).flatMap(Collection::stream).filter(mm -> {
                String descriptor;
                if (!Objects.equals(selector.name(), mm.unmappedName)) {
                    return false;
                }
                if (selector.descriptor() == null) {
                    return true;
                }
                if (mm.hasComponent(Descriptor.class)) {
                    descriptor = mm.getComponent(Descriptor.class).unmappedDescriptor;
                } else if (mm.hasComponent(Descriptor.Mapped.class)) {
                    descriptor = this.remapper.getUnmappedDescByMappedDesc(mm.getComponent(Descriptor.Mapped.class).mappedDescriptor);
                } else {
                    return false;
                }
                return descriptor.equals(selector.descriptor());
            }).findAny()).map(mm -> selector.remap(this.remapper, mm.mappedName).toSelectorString()).orElse(s1);
        }
        return s;
    }

    private class MethodTargetSelectorArrayRemapper
    extends AnnotationVisitor {
        private MethodTargetSelectorArrayRemapper(int api, AnnotationVisitor annotationVisitor) {
            super(api, annotationVisitor);
        }

        @Override
        public void visit(String name, Object value) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException();
            }
            String s = (String)value;
            super.visit(name, MixinClassRemapper.this.remapMethodSelector(s));
        }
    }

    private class MixinMethodRemapper
    extends AnnotationVisitor {
        private MixinMethodRemapper(int api, AnnotationVisitor annotationVisitor) {
            super(api, annotationVisitor);
        }

        @Override
        public AnnotationVisitor visitAnnotation(String name, String descriptor) {
            if (name.equals("at")) {
                return new AnnotationVisitor(this.api, super.visitAnnotation(name, descriptor)){

                    @Override
                    public void visit(String name, Object value) {
                        if (name.equals("target")) {
                            super.visit(name, MixinClassRemapper.this.remapMethodSelector((String)value));
                        } else {
                            super.visit(name, value);
                        }
                    }
                };
            }
            return super.visitAnnotation(name, descriptor);
        }

        @Override
        public AnnotationVisitor visitArray(String name) {
            if (name.equals("method")) {
                return new MethodTargetSelectorArrayRemapper(this.api, super.visitArray(name));
            }
            return super.visitArray(name);
        }
    }
}

