/*
 * Decompiled with CFR 0.152.
 */
package cn.maxpixel.mcdecompiler.asm;

import cn.maxpixel.mcdecompiler.deps.asm.AnnotationVisitor;
import cn.maxpixel.mcdecompiler.deps.asm.ClassReader;
import cn.maxpixel.mcdecompiler.deps.asm.ClassVisitor;
import cn.maxpixel.mcdecompiler.deps.asm.FieldVisitor;
import cn.maxpixel.mcdecompiler.deps.asm.MethodVisitor;
import cn.maxpixel.mcdecompiler.deps.asm.Type;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.Object2IntMap;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.Object2IntOpenHashMap;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.Object2ObjectMaps;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.Object2ObjectOpenHashMap;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.ObjectArrayList;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.ObjectList;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.ObjectOpenHashSet;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.ObjectSet;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.ObjectSets;
import cn.maxpixel.mcdecompiler.util.IOUtil;
import cn.maxpixel.mcdecompiler.util.Logging;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class ExtraClassesInformation
implements Consumer<Path> {
    private static final Logger LOGGER = Logging.getLogger();
    private final Object2ObjectOpenHashMap<String, ObjectArrayList<String>> superClassMap = new Object2ObjectOpenHashMap();
    private final Object2ObjectOpenHashMap<String, Object2IntOpenHashMap<String>> accessMap = new Object2ObjectOpenHashMap();
    private final Map<String, Map<String, String>> refMap;
    public final Object2ObjectOpenHashMap<String, ObjectSet<String>> dontRemap = new Object2ObjectOpenHashMap();

    public ExtraClassesInformation() {
        this(Object2ObjectMaps.emptyMap());
    }

    public ExtraClassesInformation(Stream<Path> classes) {
        this(classes, false);
    }

    public ExtraClassesInformation(Stream<Path> classes, boolean close) {
        this(Object2ObjectMaps.emptyMap(), classes, close);
    }

    public ExtraClassesInformation(Map<String, Map<String, String>> refMap) {
        this.refMap = refMap;
    }

    public ExtraClassesInformation(Map<String, Map<String, String>> refMap, Stream<Path> classes) {
        this(refMap, classes, false);
    }

    public ExtraClassesInformation(Map<String, Map<String, String>> refMap, Stream<Path> classes, boolean close) {
        this.refMap = refMap;
        if (close) {
            try (Stream<Path> stream = classes;){
                classes.forEach(this);
            }
        } else {
            classes.forEach(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(Path classFilePath) {
        try {
            ClassReader reader = new ClassReader(IOUtil.readAllBytes(classFilePath));
            final String className = reader.getClassName();
            final boolean needToRecord = (reader.getAccess() & 0x10200) == 0;
            final boolean notEnum = (reader.getAccess() & 0x4000) == 0;
            String superName = reader.getSuperName();
            String[] interfaces = reader.getInterfaces();
            int itfLen = interfaces.length;
            if (needToRecord && !superName.startsWith("java/")) {
                ObjectArrayList<String> list = new ObjectArrayList<String>(itfLen + 1);
                list.add(superName);
                if (itfLen > 0) {
                    for (String itf : interfaces) {
                        if (itf.startsWith("java/")) continue;
                        list.add(itf);
                    }
                }
                Object2ObjectOpenHashMap<String, ObjectArrayList<String>> object = this.superClassMap;
                synchronized (object) {
                    this.superClassMap.put(className, list);
                }
            }
            if (itfLen > 0) {
                ObjectArrayList<String> list = new ObjectArrayList<String>(itfLen);
                for (String itf : interfaces) {
                    if (itf.startsWith("java/")) continue;
                    list.add(itf);
                }
                Object2ObjectOpenHashMap<String, ObjectArrayList<String>> object2ObjectOpenHashMap = this.superClassMap;
                synchronized (object2ObjectOpenHashMap) {
                    this.superClassMap.put(className, list);
                }
            }
            reader.accept(new ClassVisitor(589824){
                private final boolean recordAccess;
                private final Object2IntOpenHashMap<String> map;
                private boolean isMixin;
                {
                    super(arg0);
                    this.recordAccess = needToRecord && notEnum;
                    this.map = this.recordAccess ? new Object2IntOpenHashMap() : null;
                }

                @Override
                public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                    if ("Lorg/spongepowered/asm/mixin/Mixin;".equals(descriptor)) {
                        this.isMixin = true;
                        final ObjectArrayList list = ExtraClassesInformation.this.superClassMap.computeIfAbsent(className, s -> new ObjectArrayList());
                        return new AnnotationVisitor(this.api){

                            @Override
                            public AnnotationVisitor visitArray(String name) {
                                return switch (name) {
                                    case "value" -> new AnnotationVisitor(this.api){

                                        @Override
                                        public void visit(String name, Object value) {
                                            Type t;
                                            if (!(value instanceof Type) || (t = (Type)value).getSort() != 10) {
                                                throw new IllegalArgumentException();
                                            }
                                            list.add(t.getInternalName());
                                        }
                                    };
                                    case "targets" -> new AnnotationVisitor(this.api){

                                        @Override
                                        public void visit(String name, Object value) {
                                            if (!(value instanceof String)) {
                                                throw new IllegalArgumentException();
                                            }
                                            String s = (String)value;
                                            list.add(((Map)ExtraClassesInformation.this.refMap.getOrDefault(className, Object2ObjectMaps.emptyMap())).getOrDefault(s, s));
                                        }
                                    };
                                    default -> null;
                                };
                            }

                            @Override
                            public void visit(String name, Object value) {
                                Boolean b;
                                if ("remap".equals(name) && value instanceof Boolean && !(b = (Boolean)value).booleanValue()) {
                                    ExtraClassesInformation.this.dontRemap.put(className, ObjectSets.emptySet());
                                }
                            }
                        };
                    }
                    return null;
                }

                @Override
                public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
                    if (this.recordAccess && (access & 1) == 0) {
                        this.map.put(name, access);
                    }
                    return !this.isMixin || ExtraClassesInformation.this.dontRemap.get(className) == ObjectSets.emptySet() ? null : new FieldVisitor(this.api){

                        @Override
                        public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                            return new AnnotationVisitor(this.api){

                                @Override
                                public void visit(String name, Object value) {
                                    Boolean b;
                                    if ("remap".equals(name) && value instanceof Boolean && !(b = (Boolean)value).booleanValue()) {
                                        ExtraClassesInformation.this.dontRemap.computeIfAbsent(className, k -> new ObjectOpenHashSet()).add(name);
                                    }
                                }
                            };
                        }
                    };
                }

                @Override
                public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                    if (this.recordAccess && (access & 1) == 0) {
                        this.map.put(name.concat(descriptor), access);
                    }
                    return !this.isMixin || ExtraClassesInformation.this.dontRemap.get(className) == ObjectSets.emptySet() ? null : new MethodVisitor(this.api){

                        @Override
                        public AnnotationVisitor visitAnnotation(final String descriptor, boolean visible) {
                            return new AnnotationVisitor(this.api){

                                @Override
                                public void visit(String name, Object value) {
                                    Boolean b;
                                    if ("remap".equals(name) && value instanceof Boolean && !(b = (Boolean)value).booleanValue()) {
                                        ExtraClassesInformation.this.dontRemap.computeIfAbsent(className, k -> new ObjectOpenHashSet()).add(name.concat(descriptor));
                                    }
                                }
                            };
                        }
                    };
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void visitEnd() {
                    if (this.recordAccess && !this.map.isEmpty()) {
                        this.map.defaultReturnValue(1);
                        Object2ObjectOpenHashMap<String, Object2IntOpenHashMap<String>> object2ObjectOpenHashMap = ExtraClassesInformation.this.accessMap;
                        synchronized (object2ObjectOpenHashMap) {
                            ExtraClassesInformation.this.accessMap.put(className, this.map);
                        }
                    }
                }
            }, 7);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Error when generating extra classes information", e);
        }
    }

    public ObjectList<String> getSuperNames(String name) {
        return this.superClassMap.get(name);
    }

    public int getAccessFlags(String className, String combinedMemberName) {
        Object2IntMap map = this.accessMap.get(className);
        if (map == null) {
            return 1;
        }
        return map.getInt(combinedMemberName);
    }
}

