/*
 * Decompiled with CFR 0.152.
 */
package cn.maxpixel.mcdecompiler.asm;

import cn.maxpixel.mcdecompiler.asm.ExtraClassesInformation;
import cn.maxpixel.mcdecompiler.deps.asm.Type;
import cn.maxpixel.mcdecompiler.deps.asm.commons.Remapper;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.Object2ObjectOpenHashMap;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.ObjectArrayList;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.ObjectCollection;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.ObjectList;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.ObjectOpenHashSet;
import cn.maxpixel.mcdecompiler.mapping.NamespacedMapping;
import cn.maxpixel.mcdecompiler.mapping.PairedMapping;
import cn.maxpixel.mcdecompiler.mapping.collection.ClassMapping;
import cn.maxpixel.mcdecompiler.mapping.component.Descriptor;
import cn.maxpixel.mcdecompiler.util.DescriptorUtil;
import cn.maxpixel.mcdecompiler.util.Logging;
import cn.maxpixel.mcdecompiler.util.MappingUtil;
import cn.maxpixel.mcdecompiler.util.NamingUtil;
import cn.maxpixel.mcdecompiler.util.Utils;
import java.lang.reflect.Modifier;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.intellij.lang.annotations.Pattern;
import org.intellij.lang.annotations.Subst;
import org.jetbrains.annotations.NotNull;

public class ClassifiedMappingRemapper
extends Remapper {
    private static final Logger LOGGER = Logging.getLogger();
    private ExtraClassesInformation extraClassesInformation;
    private final Object2ObjectOpenHashMap<String, Object2ObjectOpenHashMap<String, PairedMapping>> fieldByUnm;
    private final Object2ObjectOpenHashMap<String, Object2ObjectOpenHashMap<String, Object2ObjectOpenHashMap<String, PairedMapping>>> methodsByUnm;
    private final Object2ObjectOpenHashMap<String, ClassMapping<PairedMapping>> mappingByUnm;
    private final Object2ObjectOpenHashMap<String, ClassMapping<PairedMapping>> mappingByMap;

    public ClassifiedMappingRemapper(ObjectList<ClassMapping<PairedMapping>> mappings) {
        this.fieldByUnm = ClassMapping.genFieldsByUnmappedNameMap(mappings);
        this.mappingByUnm = ClassMapping.genMappingsByUnmappedNameMap(mappings);
        this.mappingByMap = ClassMapping.genMappingsByMappedNameMap(mappings);
        this.methodsByUnm = mappings.parallelStream().collect(Collectors.toMap(cm -> ((PairedMapping)cm.mapping).unmappedName, cm -> {
            Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
            cm.getMethods().forEach(mm -> {
                Object2ObjectOpenHashMap m = map.computeIfAbsent(mm.unmappedName, k -> new Object2ObjectOpenHashMap());
                if (m.putIfAbsent(this.getUnmappedDesc((PairedMapping)mm), mm) != null) {
                    throw new IllegalArgumentException("Method duplicated... This should not happen!");
                }
            });
            return map;
        }, Utils::onKeyDuplicate, Object2ObjectOpenHashMap::new));
    }

    public ClassifiedMappingRemapper(ObjectList<ClassMapping<NamespacedMapping>> mappings, String targetNamespace) {
        this(mappings, NamingUtil.findSourceNamespace(mappings), targetNamespace);
    }

    public ClassifiedMappingRemapper(ObjectList<ClassMapping<NamespacedMapping>> mappings, String sourceNamespace, String targetNamespace) {
        this(mappings.parallelStream().map((? super T old) -> {
            if (!((NamespacedMapping)old.mapping).contains(targetNamespace)) {
                ObjectOpenHashSet<String> availableNamespaces = new ObjectOpenHashSet<String>((ObjectCollection<String>)((NamespacedMapping)old.mapping).getNamespaces());
                availableNamespaces.remove(sourceNamespace);
                throw new IllegalArgumentException(String.format("Target namespace \"%s\" does not exist. Available namespaces: %s", targetNamespace, availableNamespaces));
            }
            ClassMapping<PairedMapping> cm = new ClassMapping<PairedMapping>(new PairedMapping(((NamespacedMapping)old.mapping).getName(sourceNamespace), ((NamespacedMapping)old.mapping).getName(targetNamespace)));
            old.getFields().forEach(m -> cm.addField(MappingUtil.Paired.o(m.getName(sourceNamespace), m.getName(targetNamespace))));
            old.getMethods().forEach(m -> {
                if (!m.getComponent(Descriptor.Namespaced.class).getDescriptorNamespace().equals(sourceNamespace)) {
                    throw new IllegalArgumentException();
                }
                cm.addMethod(MappingUtil.Paired.duo(m.getName(sourceNamespace), m.getName(targetNamespace), m.getComponent(Descriptor.Namespaced.class).getUnmappedDescriptor()));
            });
            return cm;
        }).collect(ObjectArrayList.toList()));
    }

    public ClassifiedMappingRemapper setExtraClassesInformation(ExtraClassesInformation extraClassesInformation) {
        this.extraClassesInformation = Objects.requireNonNull(extraClassesInformation);
        return this;
    }

    public ExtraClassesInformation getExtraClassesInformation() {
        return this.extraClassesInformation;
    }

    public ClassMapping<PairedMapping> getClassByUnmappedName(String unmappedName) {
        return this.mappingByUnm.get(unmappedName);
    }

    @Override
    public String map(String internalName) {
        ClassMapping<PairedMapping> classMapping = this.mappingByUnm.get(internalName);
        if (classMapping != null) {
            return ((PairedMapping)classMapping.mapping).mappedName;
        }
        return internalName;
    }

    public String mapToUnmapped(@NotNull Type mappedType) {
        return switch (mappedType.getSort()) {
            case 9 -> "[".repeat(mappedType.getDimensions()) + this.mapToUnmapped(mappedType.getElementType());
            case 10 -> Optional.ofNullable(this.mappingByMap.get(mappedType.getInternalName())).map((? super T cm) -> Type.getObjectType(((PairedMapping)cm.mapping).unmappedName)).orElse(mappedType).getDescriptor();
            default -> mappedType.getDescriptor();
        };
    }

    public String getUnmappedDescByMappedDesc(@Subst(value="()V") @NotNull @Pattern(value="^\\((\\[*([ZBCDFIJS]|L([A-Za-z_]+\\w*[/$]?)+;))*\\)\\[*([ZBCDFIJSV]|L([A-Za-z_]+\\w*[/$]?)+;)$") String mappedDescriptor) {
        if (mappedDescriptor.charAt(1) == ')') {
            if (mappedDescriptor.charAt(2) != 'L' && mappedDescriptor.charAt(2) != '[') {
                return mappedDescriptor;
            }
            return "()".concat(this.mapToUnmapped(Type.getType(DescriptorUtil.getMethodReturnDescriptor(mappedDescriptor))));
        }
        StringBuilder stringBuilder = new StringBuilder("(");
        for (Type argumentType : Type.getArgumentTypes(mappedDescriptor)) {
            stringBuilder.append(this.mapToUnmapped(argumentType));
        }
        return stringBuilder.append(')').append(this.mapToUnmapped(Type.getType(DescriptorUtil.getMethodReturnDescriptor(mappedDescriptor)))).toString();
    }

    public String mapToMapped(@NotNull Type unmappedType) {
        return switch (unmappedType.getSort()) {
            case 9 -> "[".repeat(Math.max(0, unmappedType.getDimensions())) + this.mapToMapped(unmappedType.getElementType());
            case 10 -> Optional.ofNullable(this.mappingByUnm.get(unmappedType.getInternalName())).map((? super T cm) -> Type.getObjectType(((PairedMapping)cm.mapping).mappedName)).orElse(unmappedType).getDescriptor();
            default -> unmappedType.getDescriptor();
        };
    }

    public String getMappedDescByUnmappedDesc(@Subst(value="()V") @NotNull @Pattern(value="^\\((\\[*([ZBCDFIJS]|L([A-Za-z_]+\\w*[/$]?)+;))*\\)\\[*([ZBCDFIJSV]|L([A-Za-z_]+\\w*[/$]?)+;)$") String unmappedDescriptor) {
        if (unmappedDescriptor.startsWith("()") && unmappedDescriptor.charAt(2) != 'L' && unmappedDescriptor.charAt(2) != '[') {
            return unmappedDescriptor;
        }
        StringBuilder stringBuilder = new StringBuilder("(");
        if (unmappedDescriptor.charAt(1) != ')') {
            for (Type argumentType : Type.getArgumentTypes(unmappedDescriptor)) {
                stringBuilder.append(this.mapToMapped(argumentType));
            }
        }
        return stringBuilder.append(')').append(this.mapToMapped(Type.getReturnType(unmappedDescriptor))).toString();
    }

    private String getUnmappedDesc(PairedMapping mapping) {
        if (mapping.hasComponent(Descriptor.class)) {
            return mapping.getComponent(Descriptor.class).unmappedDescriptor;
        }
        if (mapping.hasComponent(Descriptor.Mapped.class)) {
            return this.getUnmappedDescByMappedDesc(mapping.getComponent(Descriptor.Mapped.class).mappedDescriptor);
        }
        throw new IllegalArgumentException("Mapping for methods must support at least one of Descriptor or Descriptor.Mapped");
    }

    @Override
    public String mapMethodName(String owner, String name, String descriptor) {
        if (name.charAt(0) != '<') {
            return Optional.ofNullable(this.methodsByUnm.get(owner)).map((? super T map) -> (Object2ObjectOpenHashMap)map.get(name)).map((? super T map) -> (PairedMapping)map.get(descriptor)).or(() -> this.processSuperMethod(owner, name, descriptor)).map((? super T m) -> m.mappedName).orElse(name);
        }
        return name;
    }

    private Optional<PairedMapping> processSuperMethod(String owner, String name, String descriptor) {
        if (this.extraClassesInformation == null) {
            throw new UnsupportedOperationException("ExtraClassesInformation not present");
        }
        return Optional.ofNullable(this.extraClassesInformation.getSuperNames(owner)).flatMap(superNames -> superNames.parallelStream().map(this.methodsByUnm::get).filter(Objects::nonNull).map((? super T map) -> (Object2ObjectOpenHashMap)map.get(name)).filter(Objects::nonNull).map((? super T map) -> (PairedMapping)map.get(descriptor)).filter(Objects::nonNull).reduce(this::reduceMethod).or(() -> superNames.parallelStream().map((? super T n) -> this.processSuperMethod((String)n, name, descriptor)).filter(Optional::isPresent).map(Optional::get).reduce(this::reduceMethod)));
    }

    private PairedMapping reduceMethod(@NotNull PairedMapping left, @NotNull PairedMapping right) {
        if (left == right || ClassifiedMappingRemapper.nameAndDescEquals(left, right)) {
            return left;
        }
        int leftAcc = this.extraClassesInformation.getAccessFlags(((PairedMapping)left.getOwned().getOwner().mapping).unmappedName, left.unmappedName.concat(this.getUnmappedDesc(left)));
        int rightAcc = this.extraClassesInformation.getAccessFlags(((PairedMapping)right.getOwned().getOwner().mapping).unmappedName, right.unmappedName.concat(this.getUnmappedDesc(right)));
        if ((leftAcc & 5) != 0) {
            if ((rightAcc & 5) != 0) {
                throw new IllegalArgumentException("This can't happen!");
            }
            return left;
        }
        if ((rightAcc & 5) != 0) {
            return right;
        }
        if (Modifier.isPrivate(leftAcc) || Modifier.isPrivate(rightAcc)) {
            throw new IllegalArgumentException("This can't happen!");
        }
        throw new IllegalArgumentException("Method duplicated... This should not happen!");
    }

    private static boolean nameAndDescEquals(@NotNull PairedMapping left, @NotNull PairedMapping right) {
        if (left.unmappedName.equals(right.unmappedName) && left.mappedName.equals(right.mappedName)) {
            boolean leftD = left.hasComponent(Descriptor.class);
            boolean leftDM = left.hasComponent(Descriptor.Mapped.class);
            boolean rightD = right.hasComponent(Descriptor.class);
            boolean rightDM = right.hasComponent(Descriptor.Mapped.class);
            if (leftD && rightD) {
                boolean b = left.getComponent(Descriptor.class).equals(right.getComponent(Descriptor.class));
                if (leftDM && rightDM) {
                    return b && left.getComponent(Descriptor.Mapped.class).equals(right.getComponent(Descriptor.Mapped.class));
                }
                if (leftDM || rightDM) {
                    return false;
                }
                return b;
            }
            if (leftD || rightD) {
                return false;
            }
            if (leftDM && rightDM) {
                return left.getComponent(Descriptor.Mapped.class).equals(right.getComponent(Descriptor.Mapped.class));
            }
        }
        return false;
    }

    @Override
    public String mapRecordComponentName(String owner, String name, String descriptor) {
        return this.mapFieldName(owner, name, descriptor);
    }

    @Override
    public String mapFieldName(String owner, String name, String descriptor) {
        return Optional.ofNullable(this.fieldByUnm.get(owner)).map((? super T map) -> (PairedMapping)map.get(name)).or(() -> this.processSuperField(owner, name)).map(PairedMapping::getMappedName).orElse(name);
    }

    private Optional<PairedMapping> processSuperField(String owner, String name) {
        if (this.extraClassesInformation == null) {
            throw new UnsupportedOperationException("ExtraClassesInformation not present");
        }
        return Optional.ofNullable(this.extraClassesInformation.getSuperNames(owner)).flatMap(superNames -> superNames.parallelStream().map(this.fieldByUnm::get).filter(Objects::nonNull).map((? super T map) -> (PairedMapping)map.get(name)).filter(Objects::nonNull).reduce(this::reduceField).or(() -> superNames.parallelStream().map((? super T n) -> this.processSuperField((String)n, name)).filter(Optional::isPresent).map(Optional::get).reduce(this::reduceField)));
    }

    private PairedMapping reduceField(PairedMapping left, PairedMapping right) {
        if (left == right) {
            return left;
        }
        int leftAcc = this.extraClassesInformation.getAccessFlags(((PairedMapping)left.getOwned().owner.mapping).unmappedName, left.unmappedName) & 7;
        int rightAcc = this.extraClassesInformation.getAccessFlags(((PairedMapping)right.getOwned().owner.mapping).unmappedName, right.unmappedName) & 7;
        if ((leftAcc & 5) != 0) {
            if ((rightAcc & 5) != 0) {
                throw new IllegalArgumentException("This can't happen!");
            }
            return left;
        }
        if ((rightAcc & 5) != 0) {
            return right;
        }
        if (Modifier.isPrivate(leftAcc) || Modifier.isPrivate(rightAcc)) {
            throw new IllegalArgumentException("This can't happen!");
        }
        throw new IllegalArgumentException("Field duplicated... This should not happen!");
    }
}

