/*
 * Decompiled with CFR 0.152.
 */
package cn.maxpixel.mcdecompiler.asm;

import cn.maxpixel.mcdecompiler.ClassifiedDeobfuscator;
import cn.maxpixel.mcdecompiler.Properties;
import cn.maxpixel.mcdecompiler.asm.ClassifiedMappingRemapper;
import cn.maxpixel.mcdecompiler.asm.ExtraClassesInformation;
import cn.maxpixel.mcdecompiler.asm.IndyRemapper;
import cn.maxpixel.mcdecompiler.asm.MixinClassRemapper;
import cn.maxpixel.mcdecompiler.asm.RuntimeParameterAnnotationFixer;
import cn.maxpixel.mcdecompiler.asm.variable.ForgeFlowerAbstractParametersRecorder;
import cn.maxpixel.mcdecompiler.asm.variable.MappingVariableNameProvider;
import cn.maxpixel.mcdecompiler.asm.variable.RecordNameRemapper;
import cn.maxpixel.mcdecompiler.asm.variable.VariableNameHandler;
import cn.maxpixel.mcdecompiler.asm.variable.VariableNameProcessor;
import cn.maxpixel.mcdecompiler.deps.asm.ClassReader;
import cn.maxpixel.mcdecompiler.deps.asm.ClassVisitor;
import cn.maxpixel.mcdecompiler.deps.asm.ClassWriter;
import cn.maxpixel.mcdecompiler.deps.asm.commons.ClassRemapper;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.ObjectSet;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.ObjectSets;
import cn.maxpixel.mcdecompiler.mapping.Mapping;
import cn.maxpixel.mcdecompiler.mapping.NameGetter;
import cn.maxpixel.mcdecompiler.mapping.collection.ClassMapping;
import java.io.IOException;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class ClassProcessor {
    private static final ServiceLoader<Process> LOADER = ServiceLoader.load(Process.class);
    private static final Process[] BEFORE = (Process[])LOADER.stream().map(ServiceLoader.Provider::get).filter(pro -> pro.getState() == Process.State.BEFORE).toArray(Process[]::new);
    private static final Process[] AFTER = (Process[])LOADER.stream().map(ServiceLoader.Provider::get).filter(pro -> pro.getState() == Process.State.AFTER).toArray(Process[]::new);

    private ClassProcessor() {
        throw new AssertionError((Object)"No instances");
    }

    public static void registerCommandLineOptions(OptionParser parser) {
        CoreProcess.INSTANCE.registerCommandLineOptions(parser::accepts, parser::accepts);
        for (Process process : LOADER) {
            process.registerCommandLineOptions(option -> parser.accepts(process.getName() + "." + option), (option, description) -> parser.accepts(process.getName() + "." + option, (String)description));
        }
    }

    public static void acceptCommandLineValues(OptionSet options) {
        CoreProcess.INSTANCE.acceptCommandLineValues(options::has, options::hasArgument, options::valueOf, options::valuesOf);
        for (Process process : LOADER) {
            process.acceptCommandLineValues(options::has, options::hasArgument, options::valueOf, options::valuesOf);
        }
    }

    public static void fetchOptions() {
        for (Process process : LOADER) {
            process.fetchOptions();
        }
    }

    public static void beforeRunning(ClassifiedDeobfuscator.DeobfuscateOptions options, @Nullable String targetNamespace, ClassifiedMappingRemapper mappingRemapper) throws IOException {
        CoreProcess.INSTANCE.beforeRunning(options, targetNamespace, mappingRemapper);
        for (Process process : LOADER) {
            process.beforeRunning(options, targetNamespace, mappingRemapper);
        }
    }

    public static void afterRunning(ClassifiedDeobfuscator.DeobfuscateOptions options, @Nullable String targetNamespace, ClassifiedMappingRemapper mappingRemapper) throws IOException {
        CoreProcess.INSTANCE.afterRunning(options, targetNamespace, mappingRemapper);
        for (Process process : LOADER) {
            process.afterRunning(options, targetNamespace, mappingRemapper);
        }
    }

    public static ClassVisitor getVisitor(ClassWriter writer, ClassifiedDeobfuscator.DeobfuscateOptions options, ClassReader reader, @Nullable ClassMapping<? extends Mapping> mapping, String targetNamespace, ClassifiedMappingRemapper mappingRemapper) {
        ClassVisitor cv = writer;
        for (Process process : AFTER) {
            cv = process.getVisitor(options, reader, mapping, targetNamespace, mappingRemapper).apply(cv);
        }
        cv = CoreProcess.INSTANCE.getVisitor(options, reader, mapping, targetNamespace, mappingRemapper).apply(cv);
        for (Process process : BEFORE) {
            cv = process.getVisitor(options, reader, mapping, targetNamespace, mappingRemapper).apply(cv);
        }
        return cv;
    }

    private static enum CoreProcess implements Process
    {
        INSTANCE;

        private final ForgeFlowerAbstractParametersRecorder recorder = new ForgeFlowerAbstractParametersRecorder();

        @Override
        public String getName() {
            return "core";
        }

        @Override
        public Process.State getState() {
            return Process.State.CORE;
        }

        @Override
        public void beforeRunning(ClassifiedDeobfuscator.DeobfuscateOptions options, String targetNamespace, ClassifiedMappingRemapper mappingRemapper) {
            if (options.rvn()) {
                this.recorder.startRecord();
            }
        }

        @Override
        public void afterRunning(ClassifiedDeobfuscator.DeobfuscateOptions options, String targetNamespace, ClassifiedMappingRemapper mappingRemapper) throws IOException {
            if (options.rvn()) {
                this.recorder.endRecord(Properties.TEMP_DIR.resolve("fernflower_abstract_parameter_names.txt"));
            }
        }

        @Override
        public Function<ClassVisitor, ClassVisitor> getVisitor(ClassifiedDeobfuscator.DeobfuscateOptions options, ClassReader reader, ClassMapping<? extends Mapping> mapping, String targetNamespace, ClassifiedMappingRemapper mappingRemapper) {
            return parent -> {
                String className = reader.getClassName();
                int access = reader.getAccess();
                ClassVisitor cv = parent;
                VariableNameHandler handler = new VariableNameHandler();
                if (mapping != null) {
                    MappingVariableNameProvider provider;
                    if (mapping.mapping instanceof NameGetter.Namespaced) {
                        ClassMapping.setMappedNamespace(mapping, targetNamespace);
                    }
                    if ((provider = new MappingVariableNameProvider(mapping, mappingRemapper)).omitThis()) {
                        handler.setOmitThis();
                    }
                    handler.addProvider(provider);
                }
                if ((access & 0x10000) != 0) {
                    RecordNameRemapper r = new RecordNameRemapper(cv);
                    cv = r;
                    handler.addProvider(r);
                }
                cv = new VariableNameProcessor(cv, this.recorder, handler, mappingRemapper.map(className), options.rvn());
                cv = new ClassRemapper(cv, mappingRemapper);
                cv = new IndyRemapper(cv, mappingRemapper);
                ExtraClassesInformation eci = mappingRemapper.getExtraClassesInformation();
                if (eci.dontRemap.containsKey(className)) {
                    ObjectSet<String> skipped = eci.dontRemap.get(className);
                    if (!skipped.isEmpty()) {
                        cv = new MixinClassRemapper(cv, mappingRemapper, eci, options.refMap(), skipped, className);
                    }
                } else {
                    cv = new MixinClassRemapper(cv, mappingRemapper, eci, options.refMap(), ObjectSets.emptySet(), className);
                }
                return new RuntimeParameterAnnotationFixer(cv, className, access);
            };
        }
    }

    public static interface Process {
        public String getName();

        public State getState();

        default public void registerCommandLineOptions(Function<String, OptionSpecBuilder> accept, BiFunction<String, String, OptionSpecBuilder> acceptWithDescription) {
        }

        default public void acceptCommandLineValues(Predicate<OptionSpec<?>> has, Predicate<OptionSpec<?>> hasArgument, Function<OptionSpec<?>, ?> valueOf, Function<OptionSpec<?>, List<?>> valuesOf) {
        }

        default public void fetchOptions() {
        }

        default public void beforeRunning(ClassifiedDeobfuscator.DeobfuscateOptions options, @Nullable String targetNamespace, ClassifiedMappingRemapper mappingRemapper) throws IOException {
        }

        default public void afterRunning(ClassifiedDeobfuscator.DeobfuscateOptions options, @Nullable String targetNamespace, ClassifiedMappingRemapper mappingRemapper) throws IOException {
        }

        public Function<ClassVisitor, ClassVisitor> getVisitor(ClassifiedDeobfuscator.DeobfuscateOptions var1, ClassReader var2, @Nullable ClassMapping<? extends Mapping> var3, @Nullable String var4, ClassifiedMappingRemapper var5);

        public static enum State {
            BEFORE,
            AFTER,
            CORE;

        }
    }
}

