/*
 * Decompiled with CFR 0.152.
 */
package cn.maxpixel.mcdecompiler;

import cn.maxpixel.mcdecompiler.Info;
import java.nio.file.Path;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class Properties {
    public static Path TEMP_DIR = Path.of("temp", new String[0]);
    public static Path DOWNLOAD_DIR = Path.of("downloads", new String[0]);

    public static Path getDownloadedDecompilerPath(@NotNull Info.DecompilerType type) {
        if (type == Info.DecompilerType.USER_DEFINED) {
            throw new UnsupportedOperationException();
        }
        return DOWNLOAD_DIR.resolve("decompiler").resolve((Object)((Object)Objects.requireNonNull(type)) + ".jar");
    }

    public static String getProperty(String name, String prop) {
        if (Info.IS_DEV || Info.MANIFEST == null) {
            return Objects.requireNonNull(System.getProperty(prop), "System property \"" + prop + "\" is not set");
        }
        return Objects.requireNonNull(Info.MANIFEST.getMainAttributes().getValue(name), "Guess you forgot to add the " + name + " property to the manifest!");
    }
}

