/*
 * Decompiled with CFR 0.152.
 */
package cn.maxpixel.mcdecompiler;

import cn.maxpixel.mcdecompiler.ClassifiedDeobfuscator;
import cn.maxpixel.mcdecompiler.Info;
import cn.maxpixel.mcdecompiler.Properties;
import cn.maxpixel.mcdecompiler.decompiler.Decompilers;
import cn.maxpixel.mcdecompiler.decompiler.IDecompiler;
import cn.maxpixel.mcdecompiler.decompiler.IExternalResourcesDecompiler;
import cn.maxpixel.mcdecompiler.decompiler.ILibRecommendedDecompiler;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.Object2ObjectMaps;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.Object2ObjectOpenHashMap;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.ObjectList;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.ObjectOpenHashSet;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.ObjectSet;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.ObjectSets;
import cn.maxpixel.mcdecompiler.deps.gson.JsonObject;
import cn.maxpixel.mcdecompiler.deps.gson.JsonParser;
import cn.maxpixel.mcdecompiler.reader.AbstractMappingReader;
import cn.maxpixel.mcdecompiler.reader.ClassifiedMappingReader;
import cn.maxpixel.mcdecompiler.util.DownloadingUtil;
import cn.maxpixel.mcdecompiler.util.FileUtil;
import cn.maxpixel.mcdecompiler.util.IOUtil;
import cn.maxpixel.mcdecompiler.util.JarUtil;
import cn.maxpixel.mcdecompiler.util.LambdaUtil;
import cn.maxpixel.mcdecompiler.util.Logging;
import cn.maxpixel.mcdecompiler.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.http.HttpClient;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public class MinecraftDecompiler {
    private static final Logger LOGGER = Logging.getLogger();
    public static final Proxy INTERNAL_PROXY = Info.IS_DEV ? new Proxy(Proxy.Type.HTTP, new InetSocketAddress(1080)) : Proxy.NO_PROXY;
    public static final HttpClient HTTP_CLIENT = HttpClient.newBuilder().proxy(new ProxySelector(){
        private static final Logger LOGGER = Logging.getLogger("Proxy");
        private static final List<Proxy> PROXY_LIST = List.of(INTERNAL_PROXY);

        @Override
        public List<Proxy> select(URI uri) {
            return PROXY_LIST;
        }

        @Override
        public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
            LOGGER.log(Level.WARNING, "Error connecting to {0}", new Object[]{uri, ioe});
        }
    }).connectTimeout(Duration.ofSeconds(10L)).followRedirects(HttpClient.Redirect.NORMAL).build();
    private final Options options;
    private final ClassifiedDeobfuscator deobfuscator;

    public MinecraftDecompiler(Options options) {
        this.options = options;
        this.deobfuscator = options.buildDeobfuscator();
    }

    public void deobfuscate() {
        try {
            this.deobfuscator.deobfuscate(this.options.inputJar(), this.options.outputJar());
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Error deobfuscating", e);
        }
    }

    public void decompile(String decompilerName) {
        this.decompile(decompilerName, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void decompile(String decompilerName, @Nullable Path incrementalJar) {
        IDecompiler decompiler = Decompilers.get(decompilerName);
        if (decompiler == null) {
            throw new IllegalArgumentException("Decompiler \"" + decompilerName + "\" does not exist");
        }
        if (Files.notExists(this.options.outputJar(), new LinkOption[0])) {
            this.deobfuscate();
        }
        LOGGER.log(Level.INFO, "Decompiling using \"{0}\"", decompiler.name());
        Path inputJar = this.options.outputJar();
        Path outputDir = this.options.outputDecompDir();
        try (FileSystem jarFs = JarUtil.createZipFs(inputJar);){
            if (incrementalJar == null) {
                FileUtil.deleteIfExists(outputDir);
            }
            Files.createDirectories(outputDir, new FileAttribute[0]);
            Path libDownloadPath = Files.createDirectories(Properties.DOWNLOAD_DIR.resolve("libs").toAbsolutePath().normalize(), new FileAttribute[0]);
            if (decompiler instanceof IExternalResourcesDecompiler) {
                IExternalResourcesDecompiler erd = (IExternalResourcesDecompiler)decompiler;
                erd.extractTo(Properties.TEMP_DIR.toAbsolutePath().normalize());
            }
            if (decompiler instanceof ILibRecommendedDecompiler) {
                ILibRecommendedDecompiler lrd = (ILibRecommendedDecompiler)decompiler;
                ObjectSet libs = this.options.bundledLibs().map(ObjectOpenHashSet::new).orElseGet(() -> DownloadingUtil.downloadLibraries(this.options.version(), libDownloadPath));
                if (incrementalJar != null && decompiler.getSourceType() == IDecompiler.SourceType.DIRECTORY) {
                    try (FileSystem incrementalFs = JarUtil.createZipFs(incrementalJar);){
                        ObjectOpenHashSet<String> toDecompile = this.deobfuscator.toDecompile;
                        ObjectOpenHashSet possibleInnerClasses = new ObjectOpenHashSet();
                        ObjectOpenHashSet maybeRemoved = new ObjectOpenHashSet();
                        FileUtil.iterateFiles(incrementalFs.getPath("", new String[0])).forEach(p -> {
                            String path = p.toString();
                            if (!path.endsWith(".class")) return;
                            String fileName = p.getFileName().toString();
                            if (toDecompile.contains(path)) {
                                try {
                                    MessageDigest md = MessageDigest.getInstance("SHA-1");
                                    md.update(IOUtil.readAllBytes(p));
                                    StringBuilder hashA = Utils.createHashString(md);
                                    md.update(IOUtil.readAllBytes(jarFs.getPath(path, new String[0])));
                                    StringBuilder hashB = Utils.createHashString(md);
                                    if (hashA.compareTo(hashB) == 0) {
                                        maybeRemoved.add(path);
                                        return;
                                    }
                                    if (fileName.lastIndexOf(36) <= 0) return;
                                    possibleInnerClasses.add(fileName.substring(0, fileName.indexOf(36)));
                                    return;
                                }
                                catch (IOException | NoSuchAlgorithmException e) {
                                    throw Utils.wrapInRuntime(e);
                                }
                            } else {
                                FileUtil.deleteIfExists(outputDir.resolve(path.replace(".class", ".java")));
                            }
                        });
                        for (String entry : maybeRemoved) {
                            int i = entry.indexOf(36);
                            String key = i >= 0 ? entry.substring(0, i) : entry.substring(0, entry.length() - 6);
                            if (possibleInnerClasses.contains(key) || i >= 0 && !maybeRemoved.contains(key + ".class")) continue;
                            toDecompile.remove(entry);
                        }
                    }
                    libs.add(inputJar);
                }
                if (!libs.isEmpty()) {
                    lrd.receiveLibs(libs);
                }
            }
            switch (decompiler.getSourceType()) {
                case DIRECTORY: {
                    Path decompileClasses = Properties.TEMP_DIR.resolve("decompileClasses").toAbsolutePath().normalize();
                    this.deobfuscator.toDecompile.parallelStream().forEach(path -> FileUtil.copyFile(jarFs.getPath((String)path, new String[0]), decompileClasses.resolve((String)path)));
                    decompiler.decompile(decompileClasses, outputDir);
                    return;
                }
                case FILE: {
                    decompiler.decompile(inputJar, outputDir);
                    return;
                }
            }
            return;
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Error when decompiling", e);
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> FileUtil.deleteIfExists(Properties.TEMP_DIR)));
    }

    private static interface Options
    extends ClassifiedDeobfuscator.DeobfuscateOptions {
        public String version();

        public Info.SideType type();

        private ClassifiedDeobfuscator buildDeobfuscator() {
            if (this.mappingReader() != null) {
                AbstractMappingReader<?, ?, ?> abstractMappingReader = this.mappingReader();
                if (abstractMappingReader instanceof ClassifiedMappingReader) {
                    ClassifiedMappingReader reader = (ClassifiedMappingReader)abstractMappingReader;
                    if (reader.isNamespaced()) {
                        return new ClassifiedDeobfuscator(reader, Objects.requireNonNull(this.targetNamespace(), "You are using a namespaced mapping but no target namespace is specified"), (ClassifiedDeobfuscator.DeobfuscateOptions)this);
                    }
                    return new ClassifiedDeobfuscator(reader, this);
                }
                throw new UnsupportedOperationException("Unsupported yet");
            }
            return new ClassifiedDeobfuscator(this.version(), this.type(), (ClassifiedDeobfuscator.DeobfuscateOptions)this);
        }

        @Override
        public boolean includeOthers();

        @Override
        public boolean rvn();

        public AbstractMappingReader<?, ?, ?> mappingReader();

        public Path inputJar();

        public Path outputJar();

        public Path outputDecompDir();

        @Override
        public boolean reverse();

        public String targetNamespace();

        @Override
        public ObjectSet<Path> extraJars();

        @Override
        public ObjectSet<String> extraClasses();

        public Optional<ObjectSet<Path>> bundledLibs();

        @Override
        public Map<String, Map<String, String>> refMap();
    }

    public static final class OptionBuilder {
        private static final Logger LOGGER = Logging.getLogger("Option Builder");
        private String version;
        private Info.SideType type;
        private boolean includeOthers = true;
        private boolean rvn;
        private AbstractMappingReader<?, ?, ?> mappingReader;
        private Path outputJar;
        private Path outputDecompDir;
        private final ObjectSet<Path> extraJars = new ObjectOpenHashSet<Path>();
        private final ObjectSet<String> extraClasses = new ObjectOpenHashSet<String>();
        private Optional<ObjectSet<Path>> bundledLibs = Optional.empty();
        private Map<String, Map<String, String>> refMap = Object2ObjectMaps.emptyMap();
        private Path inputJar;
        private boolean reverse;
        private String targetNamespace;

        public OptionBuilder(String version, Info.SideType type) {
            this.version = Objects.requireNonNull(version, "version cannot be null!");
            this.type = Objects.requireNonNull(type, "type cannot be null!");
            this.preprocess(DownloadingUtil.downloadJarSync(version, type));
            this.outputJar = Path.of("output", version + "_" + type + "_deobfuscated.jar").toAbsolutePath().normalize();
            this.outputDecompDir = Path.of("output", version + "_" + type + "_decompiled").toAbsolutePath().normalize();
        }

        public OptionBuilder(Path inputJar) {
            this(inputJar, false);
        }

        public OptionBuilder(Path inputJar, boolean reverse) {
            this.preprocess(inputJar);
            this.reverse = reverse;
            String outputName = inputJar.getFileName().toString();
            outputName = outputName.substring(0, outputName.lastIndexOf(46));
            this.outputJar = Path.of("output", outputName + "_deobfuscated.jar").toAbsolutePath().normalize();
            this.outputDecompDir = Path.of("output", outputName + "_decompiled").toAbsolutePath().normalize();
        }

        private void preprocess(Path inputJar) {
            FileUtil.deleteIfExists(Properties.TEMP_DIR);
            try (FileSystem jarFs = JarUtil.createZipFs(FileUtil.requireExist(inputJar));){
                Files.createDirectories(Properties.TEMP_DIR, new FileAttribute[0]);
                Path metaInf = jarFs.getPath("META-INF", new String[0]);
                if (Files.exists(jarFs.getPath("/net/minecraft/bundler/Main.class", new String[0]), new LinkOption[0])) {
                    Path extractDir = Files.createDirectories(Properties.TEMP_DIR.resolve("bundleExtract"), new FileAttribute[0]);
                    List<String> jar = Files.readAllLines(metaInf.resolve("versions.list"));
                    if (jar.size() != 1) {
                        throw new IllegalArgumentException("Why multiple versions in a bundle?");
                    }
                    Path versionPath = metaInf.resolve("versions").resolve(jar.get(0).split("\t")[2]);
                    FileUtil.copyFile(versionPath, extractDir);
                    this.inputJar = extractDir.resolve(versionPath.getFileName().toString());
                    ObjectOpenHashSet libs = new ObjectOpenHashSet();
                    try (Stream<String> lines = Files.lines(metaInf.resolve("libraries.list"));){
                        lines.forEach(line -> {
                            Path lib = metaInf.resolve("libraries").resolve(line.split("\t")[2]);
                            FileUtil.copyFile(lib, extractDir);
                            libs.add(extractDir.resolve(lib.getFileName().toString()));
                        });
                    }
                    this.bundledLibs = Optional.of(ObjectSets.unmodifiable(libs));
                } else {
                    this.inputJar = inputJar;
                }
                Path versionJson = jarFs.getPath("/version.json", new String[0]);
                if (this.version == null && Files.exists(versionJson, new LinkOption[0])) {
                    try (InputStreamReader isr = new InputStreamReader(Files.newInputStream(versionJson, new OpenOption[0]), StandardCharsets.UTF_8);){
                        this.version = JsonParser.parseReader(isr).getAsJsonObject().get("id").getAsString();
                    }
                }
                try (InputStream is = Files.newInputStream(metaInf.resolve("MANIFEST.MF"), new OpenOption[0]);){
                    this.refMap = Optional.of(new Manifest(is)).map(man -> man.getMainAttributes().getValue("MixinConfigs")).map(x$0 -> jarFs.getPath((String)x$0, new String[0])).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).flatMap(path -> Optional.of(path).map(LambdaUtil.unwrap(x$0 -> Files.newInputStream(x$0, new OpenOption[0]))).map(inputStream -> new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8)).flatMap(isr -> {
                        Optional<JsonObject> optional;
                        block8: {
                            InputStreamReader inputStreamReader = isr;
                            try {
                                optional = Optional.of(JsonParser.parseReader(isr).getAsJsonObject());
                                if (inputStreamReader == null) break block8;
                            }
                            catch (Throwable throwable) {
                                try {
                                    if (inputStreamReader != null) {
                                        try {
                                            inputStreamReader.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                catch (IOException e) {
                                    return Optional.empty();
                                }
                            }
                            inputStreamReader.close();
                        }
                        return optional;
                    }).map(obj -> jarFs.getPath(obj.get("refmap").getAsString(), new String[0])).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).map(LambdaUtil.unwrap(x$0 -> Files.newInputStream(x$0, new OpenOption[0]))).map(inputStream -> new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8)).flatMap(isr -> {
                        Optional<JsonObject> optional;
                        block8: {
                            InputStreamReader inputStreamReader = isr;
                            try {
                                optional = Optional.of(JsonParser.parseReader(isr).getAsJsonObject());
                                if (inputStreamReader == null) break block8;
                            }
                            catch (Throwable throwable) {
                                try {
                                    if (inputStreamReader != null) {
                                        try {
                                            inputStreamReader.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                catch (IOException e) {
                                    return Optional.empty();
                                }
                            }
                            inputStreamReader.close();
                        }
                        return optional;
                    }).map(obj -> obj.getAsJsonObject("mappings")).map(mappings -> {
                        Object2ObjectOpenHashMap refMap = new Object2ObjectOpenHashMap();
                        refMap.defaultReturnValue(Object2ObjectMaps.emptyMap());
                        mappings.keySet().forEach(key -> {
                            JsonObject value = mappings.getAsJsonObject((String)key);
                            Object2ObjectOpenHashMap mapping = new Object2ObjectOpenHashMap();
                            value.keySet().forEach(k -> mapping.put(k, value.get((String)k).getAsString()));
                            refMap.put(key, mapping);
                        });
                        return refMap;
                    })).orElse(Object2ObjectMaps.emptyMap());
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Error preprocessing jar file {0}", new Object[]{inputJar, e});
                throw Utils.wrapInRuntime(e);
            }
        }

        public OptionBuilder libsUsing(String version) {
            if (this.version != null) {
                throw new IllegalArgumentException("Version already defined, do not define it twice");
            }
            this.version = Objects.requireNonNull(version, "version cannot be null!");
            return this;
        }

        public OptionBuilder withMapping(AbstractMappingReader<?, ?, ?> mappingReader) {
            this.mappingReader = Objects.requireNonNull(mappingReader, "mappingReader cannot be null");
            return this;
        }

        public OptionBuilder output(Path outputJar) {
            this.outputJar = Objects.requireNonNull(outputJar, "outputJar cannot be null").toAbsolutePath().normalize();
            return this;
        }

        public OptionBuilder outputDecomp(Path outputDecompDir) {
            this.outputDecompDir = Objects.requireNonNull(outputDecompDir, "outputDecompDir cannot be null").toAbsolutePath().normalize();
            return this;
        }

        public OptionBuilder targetNamespace(String targetNamespace) {
            this.targetNamespace = Objects.requireNonNull(targetNamespace, "targetNamespace cannot be null");
            return this;
        }

        public OptionBuilder doNotIncludeOthers() {
            this.includeOthers = false;
            return this;
        }

        public OptionBuilder regenerateVariableNames() {
            this.rvn = true;
            return this;
        }

        public OptionBuilder addExtraJar(Path jar) {
            this.extraJars.add(jar);
            return this;
        }

        public OptionBuilder addExtraJars(Collection<Path> jars) {
            this.extraJars.addAll(jars);
            return this;
        }

        public OptionBuilder addExtraJars(ObjectList<Path> jars) {
            this.extraJars.addAll(jars);
            return this;
        }

        public OptionBuilder addExtraClass(String cls) {
            this.extraClasses.add(cls);
            return this;
        }

        public OptionBuilder addExtraClasses(Collection<String> classes) {
            this.extraClasses.addAll(classes);
            return this;
        }

        public OptionBuilder addExtraClasses(ObjectList<String> classes) {
            this.extraClasses.addAll(classes);
            return this;
        }

        public Options build() {
            if (this.outputJar.getParent().equals(this.outputDecompDir)) {
                throw new IllegalArgumentException("The parent directory of outputJar cannot be the same as outputDecomp");
            }
            return new Options(){
                private final ObjectSet<Path> uExtraJars;
                private final ObjectSet<String> uExtraClasses;
                {
                    this.uExtraJars = ObjectSets.unmodifiable(extraJars);
                    this.uExtraClasses = ObjectSets.unmodifiable(extraClasses);
                }

                @Override
                public String version() {
                    return version;
                }

                @Override
                public Info.SideType type() {
                    return type;
                }

                @Override
                public boolean includeOthers() {
                    return includeOthers;
                }

                @Override
                public boolean rvn() {
                    return rvn;
                }

                @Override
                public AbstractMappingReader<?, ?, ?> mappingReader() {
                    return mappingReader;
                }

                @Override
                public Path inputJar() {
                    return inputJar;
                }

                @Override
                public Path outputJar() {
                    return outputJar;
                }

                @Override
                public Path outputDecompDir() {
                    return outputDecompDir;
                }

                @Override
                public boolean reverse() {
                    return reverse;
                }

                @Override
                public String targetNamespace() {
                    return targetNamespace;
                }

                @Override
                public ObjectSet<Path> extraJars() {
                    return this.uExtraJars;
                }

                @Override
                public ObjectSet<String> extraClasses() {
                    return this.uExtraClasses;
                }

                @Override
                public Optional<ObjectSet<Path>> bundledLibs() {
                    return bundledLibs;
                }

                @Override
                public Map<String, Map<String, String>> refMap() {
                    return refMap;
                }
            };
        }
    }
}

