/*
 * Decompiled with CFR 0.152.
 */
package cn.maxpixel.mcdecompiler;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.Manifest;
import org.intellij.lang.annotations.Language;

public interface Info {
    @Language(value="RegExp")
    public static final String METHOD_DESC_PATTERN = "^\\((\\[*([ZBCDFIJS]|L([A-Za-z_]+\\w*[/$]?)+;))*\\)\\[*([ZBCDFIJSV]|L([A-Za-z_]+\\w*[/$]?)+;)$";
    public static final boolean IS_DEV = System.console() == null && Boolean.getBoolean("mcd.isDevEnv");
    public static final int ASM_VERSION = 589824;
    public static final Manifest MANIFEST = Info.getManifest();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Manifest getManifest() {
        try {
            URL location = Info.class.getProtectionDomain().getCodeSource().getLocation();
            if (location == null) return null;
            try (URLClassLoader loader = new URLClassLoader(new URL[]{location}, null);){
                URL url = loader.findResource("META-INF/MANIFEST.MF");
                if (url == null) return null;
                Manifest manifest = new Manifest(url.openStream());
                return manifest;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static enum DecompilerType {
        FERNFLOWER,
        FORGEFLOWER,
        VINEFLOWER,
        CFR,
        USER_DEFINED;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum SideType {
        CLIENT,
        SERVER;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

