/*
 * Decompiled with CFR 0.152.
 */
package cn.maxpixel.mcdecompiler;

import cn.maxpixel.mcdecompiler.Info;
import cn.maxpixel.mcdecompiler.asm.ClassProcessor;
import cn.maxpixel.mcdecompiler.asm.ClassifiedMappingRemapper;
import cn.maxpixel.mcdecompiler.asm.ExtraClassesInformation;
import cn.maxpixel.mcdecompiler.deps.asm.ClassReader;
import cn.maxpixel.mcdecompiler.deps.asm.ClassWriter;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.Object2ObjectMaps;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.Object2ObjectOpenHashMap;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.ObjectList;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.ObjectOpenHashSet;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.ObjectSet;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.ObjectSets;
import cn.maxpixel.mcdecompiler.mapping.Mapping;
import cn.maxpixel.mcdecompiler.mapping.NamespacedMapping;
import cn.maxpixel.mcdecompiler.mapping.PairedMapping;
import cn.maxpixel.mcdecompiler.mapping.collection.ClassMapping;
import cn.maxpixel.mcdecompiler.mapping.type.MappingTypes;
import cn.maxpixel.mcdecompiler.reader.ClassifiedMappingReader;
import cn.maxpixel.mcdecompiler.util.DownloadingUtil;
import cn.maxpixel.mcdecompiler.util.FileUtil;
import cn.maxpixel.mcdecompiler.util.IOUtil;
import cn.maxpixel.mcdecompiler.util.JarUtil;
import cn.maxpixel.mcdecompiler.util.Logging;
import cn.maxpixel.mcdecompiler.util.NamingUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Objects;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class ClassifiedDeobfuscator {
    private static final Logger LOGGER = Logging.getLogger("ClassifiedDeobfuscator");
    private static final DeobfuscateOptions DEFAULT_OPTIONS = new DeobfuscateOptions(){

        @Override
        public boolean includeOthers() {
            return true;
        }

        @Override
        public boolean rvn() {
            return false;
        }

        @Override
        public boolean reverse() {
            return false;
        }
    };
    private final Object2ObjectOpenHashMap<String, ? extends ClassMapping<? extends Mapping>> mappings;
    private final ClassifiedMappingRemapper mappingRemapper;
    private final DeobfuscateOptions options;
    private final String targetNamespace;
    final ObjectOpenHashSet<String> toDecompile = new ObjectOpenHashSet();

    public ClassifiedDeobfuscator(String version, Info.SideType side) {
        this(version, side, DEFAULT_OPTIONS);
    }

    public ClassifiedDeobfuscator(String version, Info.SideType side, DeobfuscateOptions options) {
        this(new ClassifiedMappingReader<PairedMapping>(MappingTypes.PROGUARD, DownloadingUtil.downloadMappingSync(version, side)), options);
    }

    public ClassifiedDeobfuscator(ClassifiedMappingReader<PairedMapping> reader) {
        this(reader, DEFAULT_OPTIONS);
    }

    public ClassifiedDeobfuscator(ClassifiedMappingReader<PairedMapping> reader, DeobfuscateOptions options) {
        this.options = Objects.requireNonNull(options);
        this.targetNamespace = null;
        if (options.reverse()) {
            ClassifiedMappingReader.reverse(Objects.requireNonNull(reader));
        }
        this.mappings = ClassMapping.genMappingsByUnmappedNameMap((ObjectList)reader.mappings);
        this.mappingRemapper = new ClassifiedMappingRemapper((ObjectList)reader.mappings);
    }

    public ClassifiedDeobfuscator(ClassifiedMappingReader<NamespacedMapping> reader, String targetNamespace) {
        this(reader, targetNamespace, DEFAULT_OPTIONS);
    }

    public ClassifiedDeobfuscator(ClassifiedMappingReader<NamespacedMapping> reader, String targetNamespace, DeobfuscateOptions options) {
        this.options = Objects.requireNonNull(options);
        String sourceNamespace = NamingUtil.findSourceNamespace((ObjectList)Objects.requireNonNull(reader).mappings);
        this.targetNamespace = Objects.requireNonNull(targetNamespace);
        if (options.reverse()) {
            ClassifiedMappingReader.swap(reader, sourceNamespace, targetNamespace);
        }
        this.mappings = ClassMapping.genMappingsByNamespaceMap((ObjectList)reader.mappings, sourceNamespace);
        this.mappingRemapper = new ClassifiedMappingRemapper((ObjectList)reader.mappings, sourceNamespace, targetNamespace);
    }

    public ClassifiedDeobfuscator deobfuscate(Path source, Path target) throws IOException {
        LOGGER.info("Deobfuscating...");
        Files.deleteIfExists(target);
        Files.createDirectories(target.getParent(), new FileAttribute[0]);
        try (FileSystem fs = JarUtil.createZipFs(FileUtil.requireExist(source));
             FileSystem targetFs = JarUtil.createZipFs(target, true);
             Stream<Path> paths = FileUtil.iterateFiles(fs.getPath("", new String[0]));){
            ObjectSet<String> extraClasses = this.options.extraClasses();
            boolean deobfAll = extraClasses.contains("*") || extraClasses.contains("*all*");
            boolean extraClassesNotEmpty = !extraClasses.isEmpty();
            ExtraClassesInformation info = new ExtraClassesInformation(this.options.refMap(), FileUtil.iterateFiles(fs.getPath("", new String[0])).filter(p -> {
                String k = NamingUtil.file2Native(p.toString());
                if (deobfAll) {
                    if (p.toString().endsWith(".class")) return true;
                }
                if (this.mappings.containsKey(k)) return true;
                if (!extraClassesNotEmpty) return false;
                if (!extraClasses.stream().anyMatch(k::startsWith)) return false;
                return true;
            }), true);
            this.options.extraJars().forEach(jar -> {
                try (FileSystem jarFs = JarUtil.createZipFs(jar);){
                    FileUtil.iterateFiles(jarFs.getPath("", new String[0])).filter(p -> p.toString().endsWith(".class")).forEach(info);
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Error reading extra jar: {0}", new Object[]{jar, e});
                }
            });
            this.mappingRemapper.setExtraClassesInformation(info);
            ClassProcessor.beforeRunning(this.options, this.targetNamespace, this.mappingRemapper);
            this.toDecompile.clear();
            paths.forEach(path -> {
                block27: {
                    try {
                        String pathString;
                        block29: {
                            String classKeyName;
                            block28: {
                                pathString = path.toString();
                                classKeyName = NamingUtil.file2Native(pathString);
                                if (deobfAll && pathString.endsWith(".class") || this.mappings.containsKey(classKeyName)) break block28;
                                if (!extraClassesNotEmpty) break block29;
                                if (!extraClasses.stream().anyMatch(classKeyName::startsWith)) break block29;
                            }
                            ClassReader reader = new ClassReader(IOUtil.readAllBytes(path));
                            ClassWriter writer = new ClassWriter(0);
                            ClassMapping<? extends Mapping> cm = this.mappings.get(classKeyName);
                            reader.accept(ClassProcessor.getVisitor(writer, this.options, reader, cm, this.targetNamespace, this.mappingRemapper), 0);
                            String mapped = cm != null ? cm.mapping.getMappedName().concat(".class") : pathString;
                            ObjectOpenHashSet<String> objectOpenHashSet = this.toDecompile;
                            synchronized (objectOpenHashSet) {
                                this.toDecompile.add(mapped);
                            }
                            try (OutputStream os = Files.newOutputStream(FileUtil.ensureFileExist(targetFs.getPath(mapped, new String[0])), new OpenOption[0]);){
                                os.write(writer.toByteArray());
                                break block27;
                            }
                        }
                        if (!this.options.includeOthers()) break block27;
                        if (pathString.endsWith(".SF") || pathString.endsWith(".RSA")) {
                            return;
                        }
                        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
                             OutputStream os = Files.newOutputStream(FileUtil.ensureFileExist(targetFs.getPath(pathString, new String[0])), new OpenOption[0]);){
                            if (path.endsWith("META-INF/MANIFEST.MF")) {
                                Manifest man = new Manifest(inputStream);
                                man.getEntries().clear();
                                man.write(os);
                            } else {
                                inputStream.transferTo(os);
                            }
                        }
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.WARNING, "Error when remapping classes or coping files", e);
                    }
                }
            });
            ClassProcessor.afterRunning(this.options, this.targetNamespace, this.mappingRemapper);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Error when deobfuscating", e);
        }
        return this;
    }

    static {
        ClassProcessor.fetchOptions();
    }

    public static interface DeobfuscateOptions {
        public boolean includeOthers();

        public boolean rvn();

        public boolean reverse();

        default public ObjectSet<Path> extraJars() {
            return ObjectSets.emptySet();
        }

        default public ObjectSet<String> extraClasses() {
            return ObjectSets.emptySet();
        }

        default public Map<String, Map<String, String>> refMap() {
            return Object2ObjectMaps.emptyMap();
        }
    }
}

