require "ISUI/ISPanel"

--*********************************************************
--* Глобальные установки UI
--*********************************************************
EtherExploitPanel = ISPanel:derive("EtherExploitPanel"); -- Наследование от ISPanel

--*********************************************************
--* Создание метки
--*********************************************************
function EtherExploitPanel:addLabel(posX, posY, title)
    local label = ISLabel:new(posX, posY + 3, getTextManager():getFontHeight(UIFont.Small), title, 1, 1, 1, 1, UIFont.Small, true)
	self:addChild(label)
    return label
end

--*********************************************************
--* Создание кнопки
--*********************************************************
function EtherExploitPanel:addButton(posX, posY, buttonTitle, onClick, isOnlyInGame)
    local buttonWidth, buttonHeight = 130, 16;
    local button = UIButton:new(posX, posY, buttonWidth, buttonHeight, buttonTitle, onClick)
    button:initialise();
    button:instantiate();
    button:setAnchorLeft(true);
    button:setAnchorRight(false);
    button:setAnchorTop(false);
    button:setAnchorBottom(true);
    button.isOnlyInGame = isOnlyInGame;
    self:addChild(button);
    table.insert(self.buttonList, button);
    return button
end

--*********************************************************
--* Создание слайдера
--*********************************************************
function EtherExploitPanel:addSlider(posX, posY, width, height, value, minValue, maxValue, method)
    local slider = UISlider:new(posX, posY, width, height, value, minValue, maxValue, method)
    slider:initialise();
    slider:instantiate();
    self:addChild(slider);
    return slider
end

--*********************************************************
--* Создание кнопки с заголовком
--*********************************************************
function EtherExploitPanel:addButtonWithLabel(title, buttonTitle, func, isOnlyInGame)
    local rows = self.rows;
    local buttonY = 5 + rows * 25;

    self:addLabel(15, buttonY - 3, title)
    local button = self:addButton(self:getWidth() - 130 - 20, buttonY, buttonTitle, func, isOnlyInGame)

    self:setScrollHeight(self:getScrollHeight() + 21);
    self.rows = self.rows + 1;

    return button;
end

--*********************************************************
--* Создание заголовка с двумя кнопками
--*********************************************************
function EtherExploitPanel:addSliderWithLabel(title, sliderMethod, value, minValue, maxValue)
    local rows = self.rows;
    local buttonY = rows * 24;

    self:addLabel(15, buttonY - 3, title)
    self:addSlider(self:getWidth() - 200 - 50, buttonY + 3, 200, 10, value, minValue, maxValue, sliderMethod)

    self:setScrollHeight(self:getScrollHeight() + 30);

    self.rows = self.rows + 1;
end


--*********************************************************
--* Добавление чекбоксов
--*********************************************************
function EtherExploitPanel:addCheckBox(title, method, isSelected, isOnlyInGame)
    local rows = self.rows;
    local checkboxX = 15;
    local checkboxY = 10 + rows * 20;

    local checkbox = UICheckbox:new(checkboxX, checkboxY, title, isSelected, method);
    checkbox:initialise();
    checkbox:instantiate();
    checkbox:setAnchorLeft(true);
    checkbox:setAnchorRight(false);
    checkbox:setAnchorTop(false);
    checkbox:setAnchorBottom(true);
    checkbox.isOnlyInGame = isOnlyInGame;
    self:addChild(checkbox);

    self:setScrollHeight(self:getScrollHeight() + checkbox.height + 5);

    self.rows = self.rows + 1;

    table.insert(self.checkBoxList, checkbox);
    return checkbox
end


--*********************************************************
--* Обновление панели
--*********************************************************
function EtherExploitPanel:updatePanel()
    for i=1, #self.checkBoxList do
        local item = self.checkBoxList[i];
        if item.isOnlyInGame and self.localPlayer == nil then
            item:setEnable(false);
        end
    end
    for i=1, #self.buttonList do
        local item = self.buttonList[i];
        if item.isOnlyInGame and self.localPlayer == nil then
            item:setEnable(false);
        end
    end
end

--*********************************************************
--* Создание дочерних элементов
--*********************************************************
function EtherExploitPanel:createChildren()
    ISPanel.createChildren(self);

    self:setScrollChildren(true);
    self:setScrollHeight(0);
    self:addScrollBars();

    self:addCheckBox(getTranslate("UI_Exploit_BlockCompileDefaultLua"), function(isChecked) toggleBlockCompileDefaultLua(isChecked) end, isBlockCompileDefaultLua(), false);
    self:addCheckBox(getTranslate("UI_Exploit_BlockCompileLuaAboutEtherHack"), function(isChecked) toggleBlockCompileLuaAboutEtherHack(isChecked) end, isBlockCompileLuaAboutEtherHack(), false);
    self:addCheckBox(getTranslate("UI_Exploit_BlockCompileLuaWithBadWords"), function(isChecked) toggleBlockCompileLuaWithBadWords(isChecked) end, isBlockCompileLuaWithBadWords(), false);

    self:addCheckBox(getTranslate("UI_Exploit_DebugBypass"), function(isChecked) toggleBypassDebugMode(isChecked) end, isBypassDebugMode(), false);

    self:addSliderWithLabel(getTranslate("UI_Exploit_TraitPointTitle"), 
    function (value)
        CharacterCreationProfession.instance.pointToSpend = value - CharacterCreationProfession.instance.cost;
    end, CharacterCreationProfession.instance:PointToSpend(), -1000, 1000);

    self:addButtonWithLabel(getTranslate("UI_Exploit_AdminAccessTitle"), getTranslate("UI_Exploit_AdminAccessButton"), function ()
        hackAdminAccess();
    end, true);
    self:addButtonWithLabel(getTranslate("UI_Exploit_AdminMenuTitle"), getTranslate("UI_Exploit_AdminMenuButton"), function ()
        if EtherAdminMenu.instance then
            EtherAdminMenu.instance:close()
        end
        local modal = EtherAdminMenu:new(200, 200, 350, 400)
        modal:initialise();
        modal:addToUIManager();
    end, true);
    self:addButtonWithLabel(getTranslate("UI_Exploit_DebugMenuTitle"), getTranslate("UI_Exploit_DebugMenuButton"), function ()
        EtherDebugMenu.OnOpenPanel()
    end, true);
    self:addButtonWithLabel(getTranslate("UI_Exploit_GameDebuggerTitle"), getTranslate("UI_Exploit_GameDebuggerButton"), 
    function()
        ISGeneralDebug.OnOpenPanel()
    end, true);

    local mechanics = self:addButtonWithLabel(getTranslate("UI_Exploit_MechanicsMenuTitle"), getTranslate("UI_Exploit_MechanicsMenuButton"), 
    function()
        if (self.localPlayer ~= nil and self.localPlayer:getNearVehicle() ~= nil) then
            UIMechanics.openPanel()
        end
    end, true);
    mechanics.update = function ()
        if (self.localPlayer ~= nil and self.localPlayer:getNearVehicle() ~= nil) then
            mechanics.isEnable = true;
        else
            mechanics.isEnable = false;
        end
    end

    local healthsCheat = self:addButtonWithLabel(getTranslate("UI_Exploit_MedicMenuTitle"), getTranslate("UI_Exploit_MedicMenuButton"),
    function()
        if (self.localPlayer ~= nil) then
            UIHealth.openPanel()
        end
    end, true);
    healthsCheat.update = function ()
        if (self.localPlayer ~= nil) then
            healthsCheat.isEnable = true;
        else
            healthsCheat.isEnable = false;
        end
    end    

    local learlAllRecipes = self:addButtonWithLabel(getTranslate("UI_Exploit_LearnAllRecipesTitle"), getTranslate("UI_Exploit_LearnAllRecipesButton"),
    function()
        if (self.localPlayer ~= nil) then
            learnAllRecipes();
        end
    end, true);
    learlAllRecipes.update = function ()
        if (self.localPlayer ~= nil) then
            learlAllRecipes.isEnable = true;
        else
            learlAllRecipes.isEnable = false;
        end
    end

    local craftCheatIngredients = self:addButtonWithLabel(getTranslate("UI_Exploit_CraftIngredientsCheatTitle"), getTranslate("UI_Exploit_CraftIngredientsCheatButton"),
    function()
        if (self.localPlayer ~= nil) then
            local recipeListBox = getPlayerCraftingUI(0).panel.activeView.view.recipes
            local selectedItem = recipeListBox.items[recipeListBox.selected];
            if selectedItem then selectedItem = selectedItem.item.recipe end
            if selectedItem.evolved then return end

            local recipe = selectedItem
            local items = {}
            local options = {}
            print(recipe:getSource():size())
            options.AvailableItemsAll = RecipeManager.getAvailableItemsAll(recipe, self.localPlayer, getPlayerCraftingUI(0):getContainers(), nil, nil)
            options.MaxItemsPerSource = 10
            options.NoDuplicateKeep = true
            RecipeUtils.CreateSourceItems(recipe, options, items)
            for _,item in ipairs(items) do
                giveItem(item, 1);
            end
        end
    end, true);
    craftCheatIngredients.update = function ()
        if(getPlayerCraftingUI(0) == nil) then
            craftCheatIngredients.isEnable = false;
            return
        end

        local recipeListBox = getPlayerCraftingUI(0).panel.activeView.view.recipes
        local selectedItem = recipeListBox.items[recipeListBox.selected];

        if (self.localPlayer ~= nil or selectedItem ~= nil) then
            craftCheatIngredients.isEnable = true;
        else
            craftCheatIngredients.isEnable = false;
        end
    end

    self:updatePanel();
end

--*********************************************************
--* Обработка событий колесика мыши
--*********************************************************
function EtherExploitPanel:onMouseWheel(del)
	self:setYScroll(self:getYScroll() - (del * 40));
	return true;
end

--*********************************************************
--* Обработка prerender
--*********************************************************
function EtherExploitPanel:prerender()
    self:setStencilRect(0,10,self:getWidth(),self:getHeight() - 20);
    ISPanel.prerender(self);
end

--*********************************************************
--* Обработка render
--*********************************************************
function EtherExploitPanel:render()
    ISPanel.render(self);
    self:clearStencilRect();
end

--*********************************************************
--* Создание нового экземпляра меню
--*********************************************************
function EtherExploitPanel:new(posX, posY, width, height)
    local menuTableData = {};

    menuTableData = ISPanel:new(posX, posY, width, height);
    setmetatable(menuTableData, self);
    menuTableData.background = true;
	menuTableData.backgroundColor = {r=0.0, g=0.0, b=0.0, a=0.0};
	menuTableData.borderColor = {r=0.0, g=0.0, b=0.0, a=0.0};
    menuTableData.moveWithMouse = true;
    menuTableData.localPlayer = getPlayer();
    self.__index = self;

    self.checkBoxList = {}; -- Список всех чекбоксов
    self.buttonList = {}; -- Список всех кнопок
    self.rows = 0;

    return menuTableData;
end