/*
 * Decompiled with CFR 0.152.
 */
package zombie.worldMap.symbols;

import java.io.IOException;
import java.nio.ByteBuffer;
import zombie.GameWindow;
import zombie.core.Translator;
import zombie.network.GameServer;
import zombie.ui.TextManager;
import zombie.ui.UIFont;
import zombie.worldMap.UIWorldMap;
import zombie.worldMap.symbols.WorldMapBaseSymbol;
import zombie.worldMap.symbols.WorldMapSymbols;

public final class WorldMapTextSymbol
extends WorldMapBaseSymbol {
    String m_text;
    boolean m_translated = false;
    UIFont m_font = UIFont.Handwritten;

    public WorldMapTextSymbol(WorldMapSymbols worldMapSymbols) {
        super(worldMapSymbols);
    }

    public void setTranslatedText(String string) {
        this.m_text = string;
        this.m_translated = true;
        if (GameServer.bServer) {
            return;
        }
        this.m_width = TextManager.instance.MeasureStringX(this.m_font, this.getTranslatedText());
        this.m_height = TextManager.instance.getFontHeight(this.m_font);
    }

    public void setUntranslatedText(String string) {
        this.m_text = string;
        this.m_translated = false;
        if (GameServer.bServer) {
            return;
        }
        this.m_width = TextManager.instance.MeasureStringX(this.m_font, this.getTranslatedText());
        this.m_height = TextManager.instance.getFontHeight(this.m_font);
    }

    public String getTranslatedText() {
        return this.m_translated ? this.m_text : Translator.getText(this.m_text);
    }

    public String getUntranslatedText() {
        return this.m_translated ? null : this.m_text;
    }

    @Override
    public WorldMapSymbols.WorldMapSymbolType getType() {
        return WorldMapSymbols.WorldMapSymbolType.Text;
    }

    @Override
    public boolean isVisible() {
        if (this.m_owner.getMiniMapSymbols()) {
            return false;
        }
        return super.isVisible();
    }

    @Override
    public void save(ByteBuffer byteBuffer) throws IOException {
        super.save(byteBuffer);
        GameWindow.WriteString(byteBuffer, this.m_text);
        byteBuffer.put(this.m_translated ? (byte)1 : 0);
    }

    @Override
    public void load(ByteBuffer byteBuffer, int n, int n2) throws IOException {
        super.load(byteBuffer, n, n2);
        this.m_text = GameWindow.ReadString(byteBuffer);
        this.m_translated = byteBuffer.get() == 1;
    }

    @Override
    public void render(UIWorldMap uIWorldMap, float f, float f2) {
        if (this.m_width == 0.0f || this.m_height == 0.0f) {
            this.m_width = TextManager.instance.MeasureStringX(this.m_font, this.getTranslatedText());
            this.m_height = TextManager.instance.getFontHeight(this.m_font);
        }
        if (this.m_collided) {
            this.renderCollided(uIWorldMap, f, f2);
        } else {
            float f3 = f + this.m_layoutX;
            float f4 = f2 + this.m_layoutY;
            if (this.m_scale > 0.0f) {
                uIWorldMap.DrawText(this.m_font, this.getTranslatedText(), (double)f3, (double)f4, (double)this.getDisplayScale(uIWorldMap), (double)this.m_r, (double)this.m_g, (double)this.m_b, (double)this.m_a);
            } else {
                uIWorldMap.DrawText(this.m_font, this.getTranslatedText(), f3, f4, this.m_r, this.m_g, this.m_b, this.m_a);
            }
        }
    }

    @Override
    public void release() {
        this.m_text = null;
    }
}

