/*
 * Decompiled with CFR 0.152.
 */
package zombie.worldMap.symbols;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.joml.Quaternionf;
import zombie.core.Core;
import zombie.core.math.PZMath;
import zombie.core.textures.Texture;
import zombie.iso.IsoUtils;
import zombie.network.GameServer;
import zombie.ui.TextManager;
import zombie.ui.UIFont;
import zombie.vehicles.BaseVehicle;
import zombie.worldMap.UIWorldMap;
import zombie.worldMap.symbols.MapSymbolDefinitions;
import zombie.worldMap.symbols.WorldMapBaseSymbol;
import zombie.worldMap.symbols.WorldMapSymbolCollisions;
import zombie.worldMap.symbols.WorldMapTextSymbol;
import zombie.worldMap.symbols.WorldMapTextureSymbol;

public class WorldMapSymbols {
    public static final int SAVEFILE_VERSION = 1;
    public final float MIN_VISIBLE_ZOOM = 14.5f;
    public static final float COLLAPSED_RADIUS = 3.0f;
    private final ArrayList<WorldMapBaseSymbol> m_symbols = new ArrayList();
    private final WorldMapSymbolCollisions m_collision = new WorldMapSymbolCollisions();
    private float m_layoutWorldScale = 0.0f;
    private final Quaternionf m_layoutRotation = new Quaternionf();
    private boolean m_layoutIsometric = true;
    private boolean m_layoutMiniMapSymbols = false;

    public WorldMapTextSymbol addTranslatedText(String string, UIFont uIFont, float f, float f2, float f3, float f4, float f5, float f6) {
        return this.addText(string, true, uIFont, f, f2, 0.0f, 0.0f, WorldMapBaseSymbol.DEFAULT_SCALE, f3, f4, f5, f6);
    }

    public WorldMapTextSymbol addUntranslatedText(String string, UIFont uIFont, float f, float f2, float f3, float f4, float f5, float f6) {
        return this.addText(string, false, uIFont, f, f2, 0.0f, 0.0f, WorldMapBaseSymbol.DEFAULT_SCALE, f3, f4, f5, f6);
    }

    public WorldMapTextSymbol addText(String string, boolean bl, UIFont uIFont, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        WorldMapTextSymbol worldMapTextSymbol = new WorldMapTextSymbol(this);
        worldMapTextSymbol.m_text = string;
        worldMapTextSymbol.m_translated = bl;
        worldMapTextSymbol.m_font = uIFont;
        worldMapTextSymbol.m_x = f;
        worldMapTextSymbol.m_y = f2;
        if (!GameServer.bServer) {
            worldMapTextSymbol.m_width = TextManager.instance.MeasureStringX(uIFont, worldMapTextSymbol.getTranslatedText());
            worldMapTextSymbol.m_height = TextManager.instance.getFontHeight(uIFont);
        }
        worldMapTextSymbol.m_anchorX = PZMath.clamp(f3, 0.0f, 1.0f);
        worldMapTextSymbol.m_anchorY = PZMath.clamp(f4, 0.0f, 1.0f);
        worldMapTextSymbol.m_scale = f5;
        worldMapTextSymbol.m_r = f6;
        worldMapTextSymbol.m_g = f7;
        worldMapTextSymbol.m_b = f8;
        worldMapTextSymbol.m_a = f9;
        this.m_symbols.add(worldMapTextSymbol);
        this.m_layoutWorldScale = 0.0f;
        return worldMapTextSymbol;
    }

    public WorldMapTextureSymbol addTexture(String string, float f, float f2, float f3, float f4, float f5, float f6) {
        return this.addTexture(string, f, f2, 0.0f, 0.0f, WorldMapBaseSymbol.DEFAULT_SCALE, f3, f4, f5, f6);
    }

    public WorldMapTextureSymbol addTexture(String string, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        WorldMapTextureSymbol worldMapTextureSymbol = new WorldMapTextureSymbol(this);
        worldMapTextureSymbol.setSymbolID(string);
        MapSymbolDefinitions.MapSymbolDefinition mapSymbolDefinition = MapSymbolDefinitions.getInstance().getSymbolById(string);
        if (mapSymbolDefinition == null) {
            worldMapTextureSymbol.m_width = 18.0f;
            worldMapTextureSymbol.m_height = 18.0f;
        } else {
            worldMapTextureSymbol.m_texture = GameServer.bServer ? null : Texture.getSharedTexture(mapSymbolDefinition.getTexturePath());
            worldMapTextureSymbol.m_width = mapSymbolDefinition.getWidth();
            worldMapTextureSymbol.m_height = mapSymbolDefinition.getHeight();
        }
        if (worldMapTextureSymbol.m_texture == null && !GameServer.bServer) {
            worldMapTextureSymbol.m_texture = Texture.getErrorTexture();
        }
        worldMapTextureSymbol.m_x = f;
        worldMapTextureSymbol.m_y = f2;
        worldMapTextureSymbol.m_anchorX = PZMath.clamp(f3, 0.0f, 1.0f);
        worldMapTextureSymbol.m_anchorY = PZMath.clamp(f4, 0.0f, 1.0f);
        worldMapTextureSymbol.m_scale = f5;
        worldMapTextureSymbol.m_r = f6;
        worldMapTextureSymbol.m_g = f7;
        worldMapTextureSymbol.m_b = f8;
        worldMapTextureSymbol.m_a = f9;
        this.m_symbols.add(worldMapTextureSymbol);
        this.m_layoutWorldScale = 0.0f;
        return worldMapTextureSymbol;
    }

    public void removeSymbolByIndex(int n) {
        WorldMapBaseSymbol worldMapBaseSymbol = this.m_symbols.remove(n);
        worldMapBaseSymbol.release();
    }

    public void clear() {
        for (int i = 0; i < this.m_symbols.size(); ++i) {
            this.m_symbols.get(i).release();
        }
        this.m_symbols.clear();
        this.m_layoutWorldScale = 0.0f;
    }

    public void invalidateLayout() {
        this.m_layoutWorldScale = 0.0f;
    }

    public void render(UIWorldMap uIWorldMap) {
        float f = uIWorldMap.getAPI().worldOriginX();
        float f2 = uIWorldMap.getAPI().worldOriginY();
        this.checkLayout(uIWorldMap);
        if (Core.bDebug) {
            // empty if block
        }
        boolean bl = false;
        for (int i = 0; i < this.m_symbols.size(); ++i) {
            WorldMapBaseSymbol worldMapBaseSymbol = this.m_symbols.get(i);
            if (!this.isSymbolVisible(uIWorldMap, worldMapBaseSymbol)) continue;
            float f3 = f + worldMapBaseSymbol.m_layoutX;
            float f4 = f2 + worldMapBaseSymbol.m_layoutY;
            if (f3 + worldMapBaseSymbol.widthScaled(uIWorldMap) <= 0.0f || (double)f3 >= uIWorldMap.getWidth() || f4 + worldMapBaseSymbol.heightScaled(uIWorldMap) <= 0.0f || (double)f4 >= uIWorldMap.getHeight()) continue;
            if (bl) {
                uIWorldMap.DrawTextureScaledColor(null, Double.valueOf(f3), Double.valueOf(f4), Double.valueOf(worldMapBaseSymbol.widthScaled(uIWorldMap)), Double.valueOf(worldMapBaseSymbol.heightScaled(uIWorldMap)), 1.0, 1.0, 1.0, 0.3);
            }
            worldMapBaseSymbol.render(uIWorldMap, f, f2);
        }
    }

    void checkLayout(UIWorldMap uIWorldMap) {
        WorldMapBaseSymbol worldMapBaseSymbol;
        int n;
        Quaternionf quaternionf = ((Quaternionf)BaseVehicle.TL_quaternionf_pool.get().alloc()).setFromUnnormalized(uIWorldMap.getAPI().getRenderer().getModelViewMatrix());
        if (this.m_layoutWorldScale == uIWorldMap.getAPI().getWorldScale() && this.m_layoutIsometric == uIWorldMap.getAPI().getBoolean("Isometric") && this.m_layoutMiniMapSymbols == uIWorldMap.getAPI().getBoolean("MiniMapSymbols") && this.m_layoutRotation.equals(quaternionf)) {
            BaseVehicle.TL_quaternionf_pool.get().release(quaternionf);
            return;
        }
        this.m_layoutWorldScale = uIWorldMap.getAPI().getWorldScale();
        this.m_layoutIsometric = uIWorldMap.getAPI().getBoolean("Isometric");
        this.m_layoutMiniMapSymbols = uIWorldMap.getAPI().getBoolean("MiniMapSymbols");
        this.m_layoutRotation.set(quaternionf);
        BaseVehicle.TL_quaternionf_pool.get().release(quaternionf);
        float f = uIWorldMap.getAPI().worldOriginX();
        float f2 = uIWorldMap.getAPI().worldOriginY();
        this.m_collision.m_boxes.clear();
        boolean bl = false;
        for (n = 0; n < this.m_symbols.size(); ++n) {
            worldMapBaseSymbol = this.m_symbols.get(n);
            worldMapBaseSymbol.layout(uIWorldMap, this.m_collision, f, f2);
            bl |= worldMapBaseSymbol.m_collided;
        }
        if (bl) {
            for (n = 0; n < this.m_symbols.size(); ++n) {
                worldMapBaseSymbol = this.m_symbols.get(n);
                if (worldMapBaseSymbol.m_collided || !this.m_collision.isCollision(n)) continue;
                worldMapBaseSymbol.m_collided = true;
            }
        }
    }

    public int getSymbolCount() {
        return this.m_symbols.size();
    }

    public WorldMapBaseSymbol getSymbolByIndex(int n) {
        return this.m_symbols.get(n);
    }

    boolean isSymbolVisible(UIWorldMap uIWorldMap, WorldMapBaseSymbol worldMapBaseSymbol) {
        return worldMapBaseSymbol.isVisible() && (worldMapBaseSymbol.m_scale <= 0.0f || uIWorldMap.getAPI().getZoomF() >= 14.5f);
    }

    int hitTest(UIWorldMap uIWorldMap, float f, float f2) {
        f -= uIWorldMap.getAPI().worldOriginX();
        f2 -= uIWorldMap.getAPI().worldOriginY();
        this.checkLayout(uIWorldMap);
        float f3 = Float.MAX_VALUE;
        int n = -1;
        for (int i = 0; i < this.m_symbols.size(); ++i) {
            float f4;
            WorldMapBaseSymbol worldMapBaseSymbol = this.m_symbols.get(i);
            if (!this.isSymbolVisible(uIWorldMap, worldMapBaseSymbol)) continue;
            float f5 = worldMapBaseSymbol.m_layoutX;
            float f6 = worldMapBaseSymbol.m_layoutY;
            float f7 = f5 + worldMapBaseSymbol.widthScaled(uIWorldMap);
            float f8 = f6 + worldMapBaseSymbol.heightScaled(uIWorldMap);
            if (worldMapBaseSymbol.m_collided && (f4 = IsoUtils.DistanceToSquared(((f5 += worldMapBaseSymbol.widthScaled(uIWorldMap) / 2.0f - 1.5f) + (f7 = f5 + 6.0f)) / 2.0f, ((f6 += worldMapBaseSymbol.heightScaled(uIWorldMap) / 2.0f - 1.5f) + (f8 = f6 + 6.0f)) / 2.0f, f, f2)) < f3) {
                f3 = f4;
                n = i;
            }
            if (!(f >= f5) || !(f < f7) || !(f2 >= f6) || !(f2 < f8)) continue;
            return i;
        }
        if (n != -1 && f3 < 100.0f) {
            return n;
        }
        return -1;
    }

    public boolean getMiniMapSymbols() {
        return this.m_layoutMiniMapSymbols;
    }

    public float getLayoutWorldScale() {
        return this.m_layoutWorldScale;
    }

    public void save(ByteBuffer byteBuffer) throws IOException {
        byteBuffer.putShort((short)1);
        byteBuffer.putInt(this.m_symbols.size());
        for (int i = 0; i < this.m_symbols.size(); ++i) {
            WorldMapBaseSymbol worldMapBaseSymbol = this.m_symbols.get(i);
            byteBuffer.put((byte)worldMapBaseSymbol.getType().index());
            worldMapBaseSymbol.save(byteBuffer);
        }
    }

    public void load(ByteBuffer byteBuffer, int n) throws IOException {
        short s = byteBuffer.getShort();
        if (s < 1 || s > 1) {
            throw new IOException("unknown map symbols version " + s);
        }
        int n2 = byteBuffer.getInt();
        for (int i = 0; i < n2; ++i) {
            WorldMapBaseSymbol worldMapBaseSymbol;
            byte by = byteBuffer.get();
            if (by == WorldMapSymbolType.Text.index()) {
                worldMapBaseSymbol = new WorldMapTextSymbol(this);
                ((WorldMapTextSymbol)worldMapBaseSymbol).load(byteBuffer, n, s);
                this.m_symbols.add(worldMapBaseSymbol);
                continue;
            }
            if (by == WorldMapSymbolType.Texture.index()) {
                worldMapBaseSymbol = new WorldMapTextureSymbol(this);
                ((WorldMapTextureSymbol)worldMapBaseSymbol).load(byteBuffer, n, s);
                this.m_symbols.add(worldMapBaseSymbol);
                continue;
            }
            throw new IOException("unknown map symbol type " + by);
        }
    }

    public static enum WorldMapSymbolType {
        NONE(-1),
        Text(0),
        Texture(1);

        private final byte m_type;

        private WorldMapSymbolType(int n2) {
            this.m_type = (byte)n2;
        }

        int index() {
            return this.m_type;
        }
    }
}

