/*
 * Decompiled with CFR 0.152.
 */
package zombie.worldMap.symbols;

import java.io.IOException;
import java.nio.ByteBuffer;
import zombie.core.math.PZMath;
import zombie.worldMap.UIWorldMap;
import zombie.worldMap.symbols.WorldMapSymbolCollisions;
import zombie.worldMap.symbols.WorldMapSymbols;

public abstract class WorldMapBaseSymbol {
    public static float DEFAULT_SCALE = 0.666f;
    WorldMapSymbols m_owner;
    float m_x;
    float m_y;
    float m_width;
    float m_height;
    float m_anchorX = 0.0f;
    float m_anchorY = 0.0f;
    float m_scale = DEFAULT_SCALE;
    float m_r;
    float m_g;
    float m_b;
    float m_a;
    boolean m_collide = false;
    boolean m_collided = false;
    float m_layoutX;
    float m_layoutY;
    boolean m_visible = true;

    public WorldMapBaseSymbol(WorldMapSymbols worldMapSymbols) {
        this.m_owner = worldMapSymbols;
    }

    public abstract WorldMapSymbols.WorldMapSymbolType getType();

    public void setAnchor(float f, float f2) {
        this.m_anchorX = PZMath.clamp(f, 0.0f, 1.0f);
        this.m_anchorY = PZMath.clamp(f2, 0.0f, 1.0f);
    }

    public void setPosition(float f, float f2) {
        this.m_x = f;
        this.m_y = f2;
    }

    public void setCollide(boolean bl) {
        this.m_collide = bl;
    }

    public void setRGBA(float f, float f2, float f3, float f4) {
        this.m_r = PZMath.clamp_01(f);
        this.m_g = PZMath.clamp_01(f2);
        this.m_b = PZMath.clamp_01(f3);
        this.m_a = PZMath.clamp_01(f4);
    }

    public void setScale(float f) {
        this.m_scale = f;
    }

    public float getDisplayScale(UIWorldMap uIWorldMap) {
        if (this.m_scale <= 0.0f) {
            return this.m_scale;
        }
        if (this.m_owner.getMiniMapSymbols()) {
            return PZMath.min(this.m_owner.getLayoutWorldScale(), 1.0f);
        }
        return this.m_owner.getLayoutWorldScale() * this.m_scale;
    }

    public void layout(UIWorldMap uIWorldMap, WorldMapSymbolCollisions worldMapSymbolCollisions, float f, float f2) {
        float f3 = uIWorldMap.getAPI().worldToUIX(this.m_x, this.m_y) - f;
        float f4 = uIWorldMap.getAPI().worldToUIY(this.m_x, this.m_y) - f2;
        this.m_layoutX = f3 - this.widthScaled(uIWorldMap) * this.m_anchorX;
        this.m_layoutY = f4 - this.heightScaled(uIWorldMap) * this.m_anchorY;
        this.m_collided = worldMapSymbolCollisions.addBox(this.m_layoutX, this.m_layoutY, this.widthScaled(uIWorldMap), this.heightScaled(uIWorldMap), this.m_collide);
        if (this.m_collided) {
            // empty if block
        }
    }

    public float widthScaled(UIWorldMap uIWorldMap) {
        return this.m_scale <= 0.0f ? this.m_width : this.m_width * this.getDisplayScale(uIWorldMap);
    }

    public float heightScaled(UIWorldMap uIWorldMap) {
        return this.m_scale <= 0.0f ? this.m_height : this.m_height * this.getDisplayScale(uIWorldMap);
    }

    public void setVisible(boolean bl) {
        this.m_visible = bl;
    }

    public boolean isVisible() {
        return this.m_visible;
    }

    public void save(ByteBuffer byteBuffer) throws IOException {
        byteBuffer.putFloat(this.m_x);
        byteBuffer.putFloat(this.m_y);
        byteBuffer.putFloat(this.m_anchorX);
        byteBuffer.putFloat(this.m_anchorY);
        byteBuffer.putFloat(this.m_scale);
        byteBuffer.put((byte)(this.m_r * 255.0f));
        byteBuffer.put((byte)(this.m_g * 255.0f));
        byteBuffer.put((byte)(this.m_b * 255.0f));
        byteBuffer.put((byte)(this.m_a * 255.0f));
        byteBuffer.put(this.m_collide ? (byte)1 : 0);
    }

    public void load(ByteBuffer byteBuffer, int n, int n2) throws IOException {
        this.m_x = byteBuffer.getFloat();
        this.m_y = byteBuffer.getFloat();
        this.m_anchorX = byteBuffer.getFloat();
        this.m_anchorY = byteBuffer.getFloat();
        this.m_scale = byteBuffer.getFloat();
        this.m_r = (float)(byteBuffer.get() & 0xFF) / 255.0f;
        this.m_g = (float)(byteBuffer.get() & 0xFF) / 255.0f;
        this.m_b = (float)(byteBuffer.get() & 0xFF) / 255.0f;
        this.m_a = (float)(byteBuffer.get() & 0xFF) / 255.0f;
        this.m_collide = byteBuffer.get() == 1;
    }

    public abstract void render(UIWorldMap var1, float var2, float var3);

    void renderCollided(UIWorldMap uIWorldMap, float f, float f2) {
        float f3 = f + this.m_layoutX + this.widthScaled(uIWorldMap) / 2.0f;
        float f4 = f2 + this.m_layoutY + this.heightScaled(uIWorldMap) / 2.0f;
        uIWorldMap.DrawTextureScaledCol(null, f3 - 3.0f, f4 - 3.0f, 6.0, 6.0, this.m_r, this.m_g, this.m_b, this.m_a);
    }

    public abstract void release();
}

