/*
 * Decompiled with CFR 0.152.
 */
package zombie.worldMap;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import zombie.SandboxOptions;
import zombie.ZomboidFileSystem;
import zombie.characters.IsoPlayer;
import zombie.core.logger.ExceptionLogger;
import zombie.core.math.PZMath;
import zombie.core.opengl.RenderThread;
import zombie.core.opengl.ShaderProgram;
import zombie.core.textures.TextureID;
import zombie.core.utils.ImageUtils;
import zombie.iso.IsoMetaGrid;
import zombie.iso.IsoWorld;
import zombie.iso.SliceY;
import zombie.iso.Vector2;
import zombie.worldMap.VBOLinesUV;
import zombie.worldMap.WorldMapRenderer;
import zombie.worldMap.styles.WorldMapStyleLayer;

public class WorldMapVisited {
    private static WorldMapVisited instance;
    private int m_minX;
    private int m_minY;
    private int m_maxX;
    private int m_maxY;
    byte[] m_visited;
    boolean m_changed = false;
    int m_changeX1 = 0;
    int m_changeY1 = 0;
    int m_changeX2 = 0;
    int m_changeY2 = 0;
    private final int[] m_updateMinX = new int[4];
    private final int[] m_updateMinY = new int[4];
    private final int[] m_updateMaxX = new int[4];
    private final int[] m_updateMaxY = new int[4];
    private static final int TEXTURE_BPP = 4;
    private TextureID m_textureID;
    private int m_textureW = 0;
    private int m_textureH = 0;
    private ByteBuffer m_textureBuffer;
    private boolean m_textureChanged = false;
    private final WorldMapStyleLayer.RGBAf m_color = new WorldMapStyleLayer.RGBAf().init(0.85882354f, 0.84313726f, 0.7529412f, 1.0f);
    private final WorldMapStyleLayer.RGBAf m_gridColor;
    private boolean m_mainMenu;
    private static ShaderProgram m_shaderProgram;
    private static ShaderProgram m_gridShaderProgram;
    static final int UNITS_PER_CELL = 10;
    static final int SQUARES_PER_CELL = 300;
    static final int SQUARES_PER_UNIT = 30;
    static final int TEXTURE_PAD = 1;
    static final int BIT_VISITED = 1;
    static final int BIT_KNOWN = 2;
    Vector2 m_vector2;

    public WorldMapVisited() {
        this.m_gridColor = new WorldMapStyleLayer.RGBAf().init(this.m_color.r * 0.85f, this.m_color.g * 0.85f, this.m_color.b * 0.85f, 1.0f);
        this.m_mainMenu = false;
        this.m_vector2 = new Vector2();
        Arrays.fill(this.m_updateMinX, -1);
        Arrays.fill(this.m_updateMinY, -1);
        Arrays.fill(this.m_updateMaxX, -1);
        Arrays.fill(this.m_updateMaxY, -1);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (n > n3 || n2 > n4) {
            n4 = 0;
            n2 = 0;
            n3 = 0;
            n = 0;
            this.m_mainMenu = true;
        }
        this.m_minX = n;
        this.m_minY = n2;
        this.m_maxX = n3;
        this.m_maxY = n4;
        this.m_changed = true;
        this.m_changeX1 = 0;
        this.m_changeY1 = 0;
        this.m_changeX2 = this.getWidthInCells() * 10 - 1;
        this.m_changeY2 = this.getHeightInCells() * 10 - 1;
        this.m_visited = new byte[this.getWidthInCells() * 10 * this.getHeightInCells() * 10];
        this.m_textureW = this.calcTextureWidth();
        this.m_textureH = this.calcTextureHeight();
        this.m_textureBuffer = BufferUtils.createByteBuffer((int)(this.m_textureW * this.m_textureH * 4));
        this.m_textureBuffer.limit(this.m_textureBuffer.capacity());
        byte by = SandboxOptions.getInstance().Map.MapAllKnown.getValue() ? (byte)0 : -1;
        byte by2 = -1;
        byte by3 = -1;
        byte by4 = -1;
        for (int i = 0; i < this.m_textureBuffer.limit(); i += 4) {
            this.m_textureBuffer.put(i, by);
            this.m_textureBuffer.put(i + 1, by2);
            this.m_textureBuffer.put(i + 2, by3);
            this.m_textureBuffer.put(i + 3, by4);
        }
        this.m_textureID = new TextureID(this.m_textureW, this.m_textureH, 0);
    }

    public int getMinX() {
        return this.m_minX;
    }

    public int getMinY() {
        return this.m_minY;
    }

    private int getWidthInCells() {
        return this.m_maxX - this.m_minX + 1;
    }

    private int getHeightInCells() {
        return this.m_maxY - this.m_minY + 1;
    }

    private int calcTextureWidth() {
        return ImageUtils.getNextPowerOfTwo(this.getWidthInCells() * 10 + 2);
    }

    private int calcTextureHeight() {
        return ImageUtils.getNextPowerOfTwo(this.getHeightInCells() * 10 + 2);
    }

    public void setKnownInCells(int n, int n2, int n3, int n4) {
        this.setFlags(n * 300, n2 * 300, (n3 + 1) * 300, (n4 + 1) * 300, 2);
    }

    public void clearKnownInCells(int n, int n2, int n3, int n4) {
        this.clearFlags(n * 300, n2 * 300, (n3 + 1) * 300, (n4 + 1) * 300, 2);
    }

    public void setVisitedInCells(int n, int n2, int n3, int n4) {
        this.setFlags(n * 300, n2 * 300, n3 * 300, n4 * 300, 1);
    }

    public void clearVisitedInCells(int n, int n2, int n3, int n4) {
        this.clearFlags(n * 300, n2 * 300, n3 * 300, n4 * 300, 1);
    }

    public void setKnownInSquares(int n, int n2, int n3, int n4) {
        this.setFlags(n, n2, n3, n4, 2);
    }

    public void clearKnownInSquares(int n, int n2, int n3, int n4) {
        this.clearFlags(n, n2, n3, n4, 2);
    }

    public void setVisitedInSquares(int n, int n2, int n3, int n4) {
        this.setFlags(n, n2, n3, n4, 1);
    }

    public void clearVisitedInSquares(int n, int n2, int n3, int n4) {
        this.clearFlags(n, n2, n3, n4, 1);
    }

    private void updateVisitedTexture() {
        this.m_textureID.bind();
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)this.m_textureW, (int)this.m_textureH, (int)0, (int)6408, (int)5121, (ByteBuffer)this.m_textureBuffer);
    }

    public void renderMain() {
        this.m_textureChanged |= this.updateTextureData(this.m_textureBuffer, this.m_textureW);
    }

    private void initShader() {
        m_shaderProgram = ShaderProgram.createShaderProgram("worldMapVisited", false, true);
        if (m_shaderProgram.isCompiled()) {
            // empty if block
        }
    }

    public void render(float f, float f2, int n, int n2, int n3, int n4, float f3, boolean bl) {
        if (this.m_mainMenu) {
            return;
        }
        GL13.glActiveTexture((int)33984);
        GL13.glClientActiveTexture((int)33984);
        GL11.glEnable((int)3553);
        if (this.m_textureChanged) {
            this.m_textureChanged = false;
            this.updateVisitedTexture();
        }
        this.m_textureID.bind();
        int n5 = bl ? 9729 : 9728;
        GL11.glTexParameteri((int)3553, (int)10241, (int)n5);
        GL11.glTexParameteri((int)3553, (int)10240, (int)n5);
        GL11.glEnable((int)3042);
        GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
        GL11.glColor4f((float)this.m_color.r, (float)this.m_color.g, (float)this.m_color.b, (float)this.m_color.a);
        if (m_shaderProgram == null) {
            this.initShader();
        }
        if (!m_shaderProgram.isCompiled()) {
            return;
        }
        m_shaderProgram.Start();
        float f4 = (float)(1 + (n - this.m_minX) * 10) / (float)this.m_textureW;
        float f5 = (float)(1 + (n2 - this.m_minY) * 10) / (float)this.m_textureH;
        float f6 = (float)(1 + (n3 + 1 - this.m_minX) * 10) / (float)this.m_textureW;
        float f7 = (float)(1 + (n4 + 1 - this.m_minY) * 10) / (float)this.m_textureH;
        float f8 = (float)((n - this.m_minX) * 300) * f3;
        float f9 = (float)((n2 - this.m_minY) * 300) * f3;
        float f10 = (float)((n3 + 1 - this.m_minX) * 300) * f3;
        float f11 = (float)((n4 + 1 - this.m_minY) * 300) * f3;
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)f4, (float)f5);
        GL11.glVertex2f((float)(f + f8), (float)(f2 + f9));
        GL11.glTexCoord2f((float)f6, (float)f5);
        GL11.glVertex2f((float)(f + f10), (float)(f2 + f9));
        GL11.glTexCoord2f((float)f6, (float)f7);
        GL11.glVertex2f((float)(f + f10), (float)(f2 + f11));
        GL11.glTexCoord2f((float)f4, (float)f7);
        GL11.glVertex2f((float)(f + f8), (float)(f2 + f11));
        GL11.glEnd();
        m_shaderProgram.End();
    }

    public void renderGrid(float f, float f2, int n, int n2, int n3, int n4, float f3, float f4) {
        int n5;
        if (f4 < 11.0f) {
            return;
        }
        if (m_gridShaderProgram == null) {
            m_gridShaderProgram = ShaderProgram.createShaderProgram("worldMapGrid", false, true);
        }
        if (!m_gridShaderProgram.isCompiled()) {
            return;
        }
        m_gridShaderProgram.Start();
        float f5 = f + (float)(n * 300 - this.m_minX * 300) * f3;
        float f6 = f2 + (float)(n2 * 300 - this.m_minY * 300) * f3;
        float f7 = f5 + (float)((n3 - n + 1) * 300) * f3;
        float f8 = f6 + (float)((n4 - n2 + 1) * 300) * f3;
        VBOLinesUV vBOLinesUV = WorldMapRenderer.m_vboLinesUV;
        vBOLinesUV.setMode(1);
        vBOLinesUV.setLineWidth(0.5f);
        vBOLinesUV.startRun(this.m_textureID);
        float f9 = this.m_gridColor.r;
        float f10 = this.m_gridColor.g;
        float f11 = this.m_gridColor.b;
        float f12 = this.m_gridColor.a;
        int n6 = 1;
        if (f4 < 13.0f) {
            n6 = 8;
        } else if (f4 < 14.0f) {
            n6 = 4;
        } else if (f4 < 15.0f) {
            n6 = 2;
        }
        m_gridShaderProgram.setValue("UVOffset", this.m_vector2.set(0.5f / (float)this.m_textureW, 0.0f));
        for (n5 = n * 10; n5 <= (n3 + 1) * 10; n5 += n6) {
            vBOLinesUV.reserve(2);
            vBOLinesUV.addElement(f + (float)(n5 * 30 - this.m_minX * 300) * f3, f6, 0.0f, (float)(1 + n5 - this.m_minX * 10) / (float)this.m_textureW, 1.0f / (float)this.m_textureH, f9, f10, f11, f12);
            vBOLinesUV.addElement(f + (float)(n5 * 30 - this.m_minX * 300) * f3, f8, 0.0f, (float)(1 + n5 - this.m_minX * 10) / (float)this.m_textureW, (float)(1 + this.getHeightInCells() * 10) / (float)this.m_textureH, f9, f10, f11, f12);
        }
        m_gridShaderProgram.setValue("UVOffset", this.m_vector2.set(0.0f, 0.5f / (float)this.m_textureH));
        for (n5 = n2 * 10; n5 <= (n4 + 1) * 10; n5 += n6) {
            vBOLinesUV.reserve(2);
            vBOLinesUV.addElement(f5, f2 + (float)(n5 * 30 - this.m_minY * 300) * f3, 0.0f, 1.0f / (float)this.m_textureW, (float)(1 + n5 - this.m_minY * 10) / (float)this.m_textureH, f9, f10, f11, f12);
            vBOLinesUV.addElement(f7, f2 + (float)(n5 * 30 - this.m_minY * 300) * f3, 0.0f, (float)(1 + this.getWidthInCells() * 10) / (float)this.m_textureW, (float)(1 + n5 - this.m_minY * 10) / (float)this.m_textureH, f9, f10, f11, f12);
        }
        vBOLinesUV.flush();
        m_gridShaderProgram.End();
    }

    private void destroy() {
        if (this.m_textureID != null) {
            RenderThread.invokeOnRenderContext(this.m_textureID::destroy);
        }
        this.m_textureBuffer = null;
        this.m_visited = null;
    }

    public void save(ByteBuffer byteBuffer) {
        byteBuffer.putInt(this.m_minX);
        byteBuffer.putInt(this.m_minY);
        byteBuffer.putInt(this.m_maxX);
        byteBuffer.putInt(this.m_maxY);
        byteBuffer.putInt(10);
        byteBuffer.put(this.m_visited);
    }

    public void load(ByteBuffer byteBuffer, int n) {
        int n2 = byteBuffer.getInt();
        int n3 = byteBuffer.getInt();
        int n4 = byteBuffer.getInt();
        int n5 = byteBuffer.getInt();
        int n6 = byteBuffer.getInt();
        if (n2 != this.m_minX || n3 != this.m_minY || n4 != this.m_maxX || n5 != this.m_maxY || n6 != 10) {
            byte[] byArray = new byte[(n4 - n2 + 1) * n6 * (n5 - n3 + 1) * n6];
            byteBuffer.get(byArray);
            int n7 = 300 / n6;
            int n8 = (n4 - n2 + 1) * n6;
            for (int i = n3 * n6; i <= n5 * n6; ++i) {
                int n9 = i - n3 * n6;
                for (int j = n2 * n6; j <= n4 * n6; ++j) {
                    int n10 = j - n2 * n6;
                    this.setFlags(j * n7, i * n7, j * n7 + n7 - 1, i * n7 + n7 - 1, byArray[n10 + n9 * n8]);
                }
            }
            return;
        }
        byteBuffer.get(this.m_visited);
    }

    public void save() throws IOException {
        ByteBuffer byteBuffer = SliceY.SliceBuffer;
        byteBuffer.clear();
        byteBuffer.putInt(195);
        this.save(byteBuffer);
        File file = new File(ZomboidFileSystem.instance.getFileNameInCurrentSave("map_visited.bin"));
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);
             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);){
            bufferedOutputStream.write(byteBuffer.array(), 0, byteBuffer.position());
        }
    }

    public void load() throws IOException {
        File file = new File(ZomboidFileSystem.instance.getFileNameInCurrentSave("map_visited.bin"));
        try (FileInputStream fileInputStream = new FileInputStream(file);
             BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);){
            ByteBuffer byteBuffer = SliceY.SliceBuffer;
            byteBuffer.clear();
            int n = bufferedInputStream.read(byteBuffer.array());
            byteBuffer.limit(n);
            int n2 = byteBuffer.getInt();
            this.load(byteBuffer, n2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    private void setFlags(int n, int n2, int n3, int n4, int n5) {
        n -= this.m_minX * 300;
        n2 -= this.m_minY * 300;
        n3 -= this.m_minX * 300;
        n4 -= this.m_minY * 300;
        int n6 = this.getWidthInCells();
        int n7 = this.getHeightInCells();
        n = PZMath.clamp(n, 0, n6 * 300 - 1);
        n2 = PZMath.clamp(n2, 0, n7 * 300 - 1);
        n3 = PZMath.clamp(n3, 0, n6 * 300 - 1);
        n4 = PZMath.clamp(n4, 0, n7 * 300 - 1);
        if (n == n3 || n2 == n4) {
            return;
        }
        int n8 = n / 30;
        int n9 = n3 / 30;
        int n10 = n2 / 30;
        int n11 = n4 / 30;
        if (n3 % 30 == 0) {
            --n9;
        }
        if (n4 % 30 == 0) {
            --n11;
        }
        boolean bl = false;
        int n12 = n6 * 10;
        for (int i = n10; i <= n11; ++i) {
            for (int j = n8; j <= n9; ++j) {
                byte by = this.m_visited[j + i * n12];
                if ((by & n5) == n5) continue;
                this.m_visited[j + i * n12] = (byte)(by | n5);
                bl = true;
            }
        }
        if (bl) {
            this.m_changed = true;
            this.m_changeX1 = PZMath.min(this.m_changeX1, n8);
            this.m_changeY1 = PZMath.min(this.m_changeY1, n10);
            this.m_changeX2 = PZMath.max(this.m_changeX2, n9);
            this.m_changeY2 = PZMath.max(this.m_changeY2, n11);
        }
    }

    private void clearFlags(int n, int n2, int n3, int n4, int n5) {
        n -= this.m_minX * 300;
        n2 -= this.m_minY * 300;
        n3 -= this.m_minX * 300;
        n4 -= this.m_minY * 300;
        int n6 = this.getWidthInCells();
        int n7 = this.getHeightInCells();
        n = PZMath.clamp(n, 0, n6 * 300 - 1);
        n2 = PZMath.clamp(n2, 0, n7 * 300 - 1);
        n3 = PZMath.clamp(n3, 0, n6 * 300 - 1);
        n4 = PZMath.clamp(n4, 0, n7 * 300 - 1);
        if (n == n3 || n2 == n4) {
            return;
        }
        int n8 = n / 30;
        int n9 = n3 / 30;
        int n10 = n2 / 30;
        int n11 = n4 / 30;
        if (n3 % 30 == 0) {
            --n9;
        }
        if (n4 % 30 == 0) {
            --n11;
        }
        boolean bl = false;
        int n12 = n6 * 10;
        for (int i = n10; i <= n11; ++i) {
            for (int j = n8; j <= n9; ++j) {
                byte by = this.m_visited[j + i * n12];
                if ((by & n5) == 0) continue;
                this.m_visited[j + i * n12] = (byte)(by & ~n5);
                bl = true;
            }
        }
        if (bl) {
            this.m_changed = true;
            this.m_changeX1 = PZMath.min(this.m_changeX1, n8);
            this.m_changeY1 = PZMath.min(this.m_changeY1, n10);
            this.m_changeX2 = PZMath.max(this.m_changeX2, n9);
            this.m_changeY2 = PZMath.max(this.m_changeY2, n11);
        }
    }

    private boolean updateTextureData(ByteBuffer byteBuffer, int n) {
        if (!this.m_changed) {
            return false;
        }
        this.m_changed = false;
        int n2 = 4;
        int n3 = this.getWidthInCells() * 10;
        for (int i = this.m_changeY1; i <= this.m_changeY2; ++i) {
            byteBuffer.position((1 + this.m_changeX1) * n2 + (1 + i) * n * n2);
            for (int j = this.m_changeX1; j <= this.m_changeX2; ++j) {
                byte by = this.m_visited[j + i * n3];
                byteBuffer.put((by & 2) != 0 ? (byte)0 : -1);
                byteBuffer.put((by & 1) != 0 ? (byte)0 : -1);
                byteBuffer.put((byte)-1);
                byteBuffer.put((byte)-1);
            }
        }
        byteBuffer.position(0);
        this.m_changeX1 = Integer.MAX_VALUE;
        this.m_changeY1 = Integer.MAX_VALUE;
        this.m_changeX2 = Integer.MIN_VALUE;
        this.m_changeY2 = Integer.MIN_VALUE;
        return true;
    }

    void setUnvisitedRGBA(float f, float f2, float f3, float f4) {
        this.m_color.init(f, f2, f3, f4);
    }

    void setUnvisitedGridRGBA(float f, float f2, float f3, float f4) {
        this.m_gridColor.init(f, f2, f3, f4);
    }

    boolean hasFlags(int n, int n2, int n3, int n4, int n5, boolean bl) {
        n -= this.m_minX * 300;
        n2 -= this.m_minY * 300;
        n3 -= this.m_minX * 300;
        n4 -= this.m_minY * 300;
        int n6 = this.getWidthInCells();
        int n7 = this.getHeightInCells();
        n = PZMath.clamp(n, 0, n6 * 300 - 1);
        n2 = PZMath.clamp(n2, 0, n7 * 300 - 1);
        n3 = PZMath.clamp(n3, 0, n6 * 300 - 1);
        n4 = PZMath.clamp(n4, 0, n7 * 300 - 1);
        if (n == n3 || n2 == n4) {
            return false;
        }
        int n8 = n / 30;
        int n9 = n3 / 30;
        int n10 = n2 / 30;
        int n11 = n4 / 30;
        if (n3 % 30 == 0) {
            --n9;
        }
        if (n4 % 30 == 0) {
            --n11;
        }
        int n12 = n6 * 10;
        for (int i = n10; i <= n11; ++i) {
            for (int j = n8; j <= n9; ++j) {
                byte by = this.m_visited[j + i * n12];
                if (bl) {
                    if ((by & n5) == 0) continue;
                    return true;
                }
                if ((by & n5) == n5) continue;
                return false;
            }
        }
        return !bl;
    }

    boolean isCellVisible(int n, int n2) {
        return this.hasFlags(n * 300, n2 * 300, (n + 1) * 300, (n2 + 1) * 300, 3, true);
    }

    public static WorldMapVisited getInstance() {
        IsoMetaGrid isoMetaGrid = IsoWorld.instance.getMetaGrid();
        if (isoMetaGrid == null) {
            throw new NullPointerException("IsoWorld.instance.MetaGrid is null");
        }
        if (instance == null) {
            instance = new WorldMapVisited();
            instance.setBounds(isoMetaGrid.getMinX(), isoMetaGrid.getMinY(), isoMetaGrid.getMaxX(), isoMetaGrid.getMaxY());
            try {
                instance.load();
                if (SandboxOptions.getInstance().Map.MapAllKnown.getValue()) {
                    instance.setKnownInCells(isoMetaGrid.getMinX(), isoMetaGrid.getMinY(), isoMetaGrid.getMaxX(), isoMetaGrid.getMaxY());
                }
            }
            catch (Throwable throwable) {
                ExceptionLogger.logException(throwable);
            }
        }
        return instance;
    }

    public static void update() {
        if (IsoWorld.instance == null) {
            return;
        }
        WorldMapVisited worldMapVisited = WorldMapVisited.getInstance();
        if (worldMapVisited == null) {
            return;
        }
        for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
            IsoPlayer isoPlayer = IsoPlayer.players[i];
            if (isoPlayer == null || isoPlayer.isDead()) continue;
            int n = 25;
            int n2 = ((int)isoPlayer.x - n) / 30;
            int n3 = ((int)isoPlayer.y - n) / 30;
            int n4 = ((int)isoPlayer.x + n) / 30;
            int n5 = ((int)isoPlayer.y + n) / 30;
            if (((int)isoPlayer.x + n) % 30 == 0) {
                --n4;
            }
            if (((int)isoPlayer.y + n) % 30 == 0) {
                --n5;
            }
            if (n2 == worldMapVisited.m_updateMinX[i] && n3 == worldMapVisited.m_updateMinY[i] && n4 == worldMapVisited.m_updateMaxX[i] && n5 == worldMapVisited.m_updateMaxY[i]) continue;
            worldMapVisited.m_updateMinX[i] = n2;
            worldMapVisited.m_updateMinY[i] = n3;
            worldMapVisited.m_updateMaxX[i] = n4;
            worldMapVisited.m_updateMaxY[i] = n5;
            worldMapVisited.setFlags((int)isoPlayer.x - n, (int)isoPlayer.y - n, (int)isoPlayer.x + n, (int)isoPlayer.y + n, 3);
        }
    }

    public void forget() {
        this.clearKnownInCells(this.m_minX, this.m_minY, this.m_maxX, this.m_maxY);
        this.clearVisitedInCells(this.m_minX, this.m_minY, this.m_maxX, this.m_maxY);
        Arrays.fill(this.m_updateMinX, -1);
        Arrays.fill(this.m_updateMinY, -1);
        Arrays.fill(this.m_updateMaxX, -1);
        Arrays.fill(this.m_updateMaxY, -1);
    }

    public static void SaveAll() {
        WorldMapVisited worldMapVisited = instance;
        if (worldMapVisited != null) {
            try {
                worldMapVisited.save();
            }
            catch (Exception exception) {
                ExceptionLogger.logException(exception);
            }
        }
    }

    public static void Reset() {
        WorldMapVisited worldMapVisited = instance;
        if (worldMapVisited != null) {
            worldMapVisited.destroy();
            instance = null;
        }
    }
}

