/*
 * Decompiled with CFR 0.152.
 */
package zombie.worldMap;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL12;
import org.lwjgl.opengl.GL13;
import zombie.core.VBO.GLVertexBufferObject;
import zombie.core.VBO.IGLBufferObject;

public final class WorldMapVBOs {
    private static final int VERTEX_SIZE = 12;
    private static final int COLOR_SIZE = 16;
    private static final int ELEMENT_SIZE = 28;
    private static final int COLOR_OFFSET = 12;
    public static final int NUM_ELEMENTS = 2340;
    private static final int INDEX_SIZE = 2;
    private static final WorldMapVBOs instance = new WorldMapVBOs();
    private final ArrayList<WorldMapVBO> m_vbos = new ArrayList();
    private ByteBuffer m_elements;
    private ByteBuffer m_indices;

    public static WorldMapVBOs getInstance() {
        return instance;
    }

    public void create() {
        this.m_elements = BufferUtils.createByteBuffer((int)65520);
        this.m_indices = BufferUtils.createByteBuffer((int)4680);
    }

    private void flush() {
        if (this.m_vbos.isEmpty()) {
            WorldMapVBO worldMapVBO = new WorldMapVBO();
            worldMapVBO.create();
            this.m_vbos.add(worldMapVBO);
        }
        this.m_elements.flip();
        this.m_indices.flip();
        this.m_vbos.get(this.m_vbos.size() - 1).flush(this.m_elements, this.m_indices);
        this.m_elements.position(this.m_elements.limit());
        this.m_elements.limit(this.m_elements.capacity());
        this.m_indices.position(this.m_indices.limit());
        this.m_indices.limit(this.m_indices.capacity());
    }

    private void addVBO() {
        WorldMapVBO worldMapVBO = new WorldMapVBO();
        worldMapVBO.create();
        this.m_vbos.add(worldMapVBO);
        this.m_elements.clear();
        this.m_indices.clear();
    }

    public void reserveVertices(int n, int[] nArray) {
        int n2;
        if (this.m_indices == null) {
            this.create();
        }
        if ((n2 = this.m_indices.position() / 2) + n > 2340) {
            this.flush();
            this.addVBO();
        }
        nArray[0] = this.m_vbos.isEmpty() ? 0 : this.m_vbos.size() - 1;
        nArray[1] = this.m_indices.position() / 2;
    }

    public void addElement(float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        this.m_elements.putFloat(f);
        this.m_elements.putFloat(f2);
        this.m_elements.putFloat(f3);
        this.m_elements.putFloat(f4);
        this.m_elements.putFloat(f5);
        this.m_elements.putFloat(f6);
        this.m_elements.putFloat(f7);
        short s = (short)(this.m_indices.position() / 2);
        this.m_indices.putShort(s);
    }

    public void drawElements(int n, int n2, int n3, int n4) {
        int n5;
        if (n2 < 0 || n2 >= this.m_vbos.size()) {
            return;
        }
        WorldMapVBO worldMapVBO = this.m_vbos.get(n2);
        if (n3 < 0 || n3 + n4 > worldMapVBO.m_elementCount) {
            return;
        }
        worldMapVBO.m_vbo.bind();
        worldMapVBO.m_ibo.bind();
        GL11.glEnableClientState((int)32884);
        GL11.glDisableClientState((int)32886);
        GL11.glVertexPointer((int)3, (int)5126, (int)28, (long)0L);
        for (n5 = 7; n5 >= 0; --n5) {
            GL13.glActiveTexture((int)(33984 + n5));
            GL11.glDisable((int)3553);
        }
        GL11.glDisable((int)2929);
        n5 = n3;
        GL12.glDrawRangeElements((int)n, (int)n5, (int)(n5 + n4), (int)n4, (int)5123, (long)(n5 * 2));
        worldMapVBO.m_vbo.bindNone();
        worldMapVBO.m_ibo.bindNone();
    }

    public void reset() {
    }

    private static final class WorldMapVBO {
        GLVertexBufferObject m_vbo;
        GLVertexBufferObject m_ibo;
        int m_elementCount = 0;

        private WorldMapVBO() {
        }

        void create() {
            IGLBufferObject iGLBufferObject = GLVertexBufferObject.funcs;
            this.m_vbo = new GLVertexBufferObject(65520L, iGLBufferObject.GL_ARRAY_BUFFER(), iGLBufferObject.GL_STREAM_DRAW());
            this.m_vbo.create();
            this.m_ibo = new GLVertexBufferObject(4680L, iGLBufferObject.GL_ELEMENT_ARRAY_BUFFER(), iGLBufferObject.GL_STREAM_DRAW());
            this.m_ibo.create();
        }

        void flush(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
            this.m_vbo.bind();
            this.m_vbo.bufferData(byteBuffer);
            this.m_ibo.bind();
            this.m_ibo.bufferData(byteBuffer2);
            this.m_elementCount = byteBuffer2.limit() / 2;
        }
    }
}

