/*
 * Decompiled with CFR 0.152.
 */
package zombie.worldMap;

import gnu.trove.list.array.TIntArrayList;
import zombie.core.math.PZMath;

public final class WorldMapPoints
extends TIntArrayList {
    int m_minX;
    int m_minY;
    int m_maxX;
    int m_maxY;

    public int numPoints() {
        return this.size() / 2;
    }

    public int getX(int n) {
        return this.get(n * 2);
    }

    public int getY(int n) {
        return this.get(n * 2 + 1);
    }

    public void calculateBounds() {
        this.m_minY = Integer.MAX_VALUE;
        this.m_minX = Integer.MAX_VALUE;
        this.m_maxY = Integer.MIN_VALUE;
        this.m_maxX = Integer.MIN_VALUE;
        for (int i = 0; i < this.numPoints(); ++i) {
            int n = this.getX(i);
            int n2 = this.getY(i);
            this.m_minX = PZMath.min(this.m_minX, n);
            this.m_minY = PZMath.min(this.m_minY, n2);
            this.m_maxX = PZMath.max(this.m_maxX, n);
            this.m_maxY = PZMath.max(this.m_maxY, n2);
        }
    }

    public boolean isClockwise() {
        float f = 0.0f;
        for (int i = 0; i < this.numPoints(); ++i) {
            int n = this.getX(i);
            int n2 = this.getY(i);
            int n3 = this.getX((i + 1) % this.numPoints());
            int n4 = this.getY((i + 1) % this.numPoints());
            f += (float)((n3 - n) * (n4 + n2));
        }
        return (double)f > 0.0;
    }
}

