/*
 * Decompiled with CFR 0.152.
 */
package zombie.worldMap;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import zombie.core.math.PZMath;
import zombie.vehicles.Clipper;
import zombie.worldMap.WorldMapPoints;

public final class WorldMapGeometry {
    public Type m_type;
    public final ArrayList<WorldMapPoints> m_points = new ArrayList();
    public int m_minX;
    public int m_minY;
    public int m_maxX;
    public int m_maxY;
    public float[] m_triangles = null;
    public ArrayList<TrianglesPerZoom> m_trianglesPerZoom = null;
    public int m_vboIndex1 = -1;
    public int m_vboIndex2 = -1;
    public int m_vboIndex3 = -1;
    public int m_vboIndex4 = -1;
    private static Clipper s_clipper = null;
    private static ByteBuffer s_vertices = null;

    public void calculateBounds() {
        this.m_minY = Integer.MAX_VALUE;
        this.m_minX = Integer.MAX_VALUE;
        this.m_maxY = Integer.MIN_VALUE;
        this.m_maxX = Integer.MIN_VALUE;
        for (int i = 0; i < this.m_points.size(); ++i) {
            WorldMapPoints worldMapPoints = this.m_points.get(i);
            worldMapPoints.calculateBounds();
            this.m_minX = PZMath.min(this.m_minX, worldMapPoints.m_minX);
            this.m_minY = PZMath.min(this.m_minY, worldMapPoints.m_minY);
            this.m_maxX = PZMath.max(this.m_maxX, worldMapPoints.m_maxX);
            this.m_maxY = PZMath.max(this.m_maxY, worldMapPoints.m_maxY);
        }
    }

    public boolean containsPoint(float f, float f2) {
        if (this.m_type != Type.Polygon || this.m_points.isEmpty()) {
            return false;
        }
        return this.isPointInPolygon_WindingNumber(f, f2, 0) != PolygonHit.Outside;
    }

    public void triangulate(double[] dArray) {
        int n;
        int n2;
        if (s_clipper == null) {
            s_clipper = new Clipper();
        }
        s_clipper.clear();
        WorldMapPoints worldMapPoints = this.m_points.get(0);
        if (s_vertices == null || s_vertices.capacity() < worldMapPoints.size() * 50 * 4) {
            s_vertices = ByteBuffer.allocateDirect(worldMapPoints.size() * 50 * 4);
        }
        s_vertices.clear();
        if (worldMapPoints.isClockwise()) {
            for (n2 = worldMapPoints.numPoints() - 1; n2 >= 0; --n2) {
                s_vertices.putFloat(worldMapPoints.getX(n2));
                s_vertices.putFloat(worldMapPoints.getY(n2));
            }
        } else {
            for (n2 = 0; n2 < worldMapPoints.numPoints(); ++n2) {
                s_vertices.putFloat(worldMapPoints.getX(n2));
                s_vertices.putFloat(worldMapPoints.getY(n2));
            }
        }
        s_clipper.addPath(worldMapPoints.numPoints(), s_vertices, false);
        for (n2 = 1; n2 < this.m_points.size(); ++n2) {
            s_vertices.clear();
            WorldMapPoints worldMapPoints2 = this.m_points.get(n2);
            if (worldMapPoints2.isClockwise()) {
                for (var5_7 = worldMapPoints2.numPoints() - 1; var5_7 >= 0; --var5_7) {
                    s_vertices.putFloat(worldMapPoints2.getX(var5_7));
                    s_vertices.putFloat(worldMapPoints2.getY(var5_7));
                }
            } else {
                for (var5_7 = 0; var5_7 < worldMapPoints2.numPoints(); ++var5_7) {
                    s_vertices.putFloat(worldMapPoints2.getX(var5_7));
                    s_vertices.putFloat(worldMapPoints2.getY(var5_7));
                }
            }
            s_clipper.addPath(worldMapPoints2.numPoints(), s_vertices, true);
        }
        if (this.m_minX < 0 || this.m_minY < 0 || this.m_maxX > 300 || this.m_maxY > 300) {
            n2 = 900;
            float f = -n2;
            float f2 = -n2;
            float f3 = 300 + n2;
            float f4 = -n2;
            float f5 = 300 + n2;
            float f6 = 300 + n2;
            float f7 = -n2;
            float f8 = 300 + n2;
            float f9 = -n2;
            float f10 = 0.0f;
            float f11 = 0.0f;
            float f12 = 0.0f;
            float f13 = 0.0f;
            float f14 = 300.0f;
            float f15 = 300.0f;
            float f16 = 300.0f;
            float f17 = 300.0f;
            float f18 = 0.0f;
            float f19 = -n2;
            float f20 = 0.0f;
            s_vertices.clear();
            s_vertices.putFloat(f).putFloat(f2);
            s_vertices.putFloat(f3).putFloat(f4);
            s_vertices.putFloat(f5).putFloat(f6);
            s_vertices.putFloat(f7).putFloat(f8);
            s_vertices.putFloat(f9).putFloat(f10);
            s_vertices.putFloat(f11).putFloat(f12);
            s_vertices.putFloat(f13).putFloat(f14);
            s_vertices.putFloat(f15).putFloat(f16);
            s_vertices.putFloat(f17).putFloat(f18);
            s_vertices.putFloat(f19).putFloat(f20);
            s_clipper.addPath(10, s_vertices, true);
        }
        if ((n2 = s_clipper.generatePolygons(0.0)) <= 0) {
            return;
        }
        s_vertices.clear();
        int n3 = s_clipper.triangulate(0, s_vertices);
        this.m_triangles = new float[n3 * 2];
        for (n = 0; n < n3; ++n) {
            this.m_triangles[n * 2] = s_vertices.getFloat();
            this.m_triangles[n * 2 + 1] = s_vertices.getFloat();
        }
        if (dArray == null) {
            return;
        }
        for (n = 0; n < dArray.length; ++n) {
            double d = dArray[n] - (n == 0 ? 0.0 : dArray[n - 1]);
            n2 = s_clipper.generatePolygons(d);
            if (n2 <= 0) continue;
            s_vertices.clear();
            n3 = s_clipper.triangulate(0, s_vertices);
            TrianglesPerZoom trianglesPerZoom = new TrianglesPerZoom();
            trianglesPerZoom.m_triangles = new float[n3 * 2];
            trianglesPerZoom.m_delta = dArray[n];
            for (int i = 0; i < n3; ++i) {
                trianglesPerZoom.m_triangles[i * 2] = s_vertices.getFloat();
                trianglesPerZoom.m_triangles[i * 2 + 1] = s_vertices.getFloat();
            }
            if (this.m_trianglesPerZoom == null) {
                this.m_trianglesPerZoom = new ArrayList();
            }
            this.m_trianglesPerZoom.add(trianglesPerZoom);
        }
    }

    TrianglesPerZoom findTriangles(double d) {
        if (this.m_trianglesPerZoom == null) {
            return null;
        }
        for (int i = 0; i < this.m_trianglesPerZoom.size(); ++i) {
            TrianglesPerZoom trianglesPerZoom = this.m_trianglesPerZoom.get(i);
            if (trianglesPerZoom.m_delta != d) continue;
            return trianglesPerZoom;
        }
        return null;
    }

    public void dispose() {
        this.m_points.clear();
        this.m_triangles = null;
    }

    float isLeft(float f, float f2, float f3, float f4, float f5, float f6) {
        return (f3 - f) * (f6 - f2) - (f5 - f) * (f4 - f2);
    }

    PolygonHit isPointInPolygon_WindingNumber(float f, float f2, int n) {
        int n2 = 0;
        WorldMapPoints worldMapPoints = this.m_points.get(0);
        for (int i = 0; i < worldMapPoints.numPoints(); ++i) {
            int n3 = worldMapPoints.getX(i);
            int n4 = worldMapPoints.getY(i);
            int n5 = worldMapPoints.getX((i + 1) % worldMapPoints.numPoints());
            int n6 = worldMapPoints.getY((i + 1) % worldMapPoints.numPoints());
            if ((float)n4 <= f2) {
                if (!((float)n6 > f2) || !(this.isLeft(n3, n4, n5, n6, f, f2) > 0.0f)) continue;
                ++n2;
                continue;
            }
            if (!((float)n6 <= f2) || !(this.isLeft(n3, n4, n5, n6, f, f2) < 0.0f)) continue;
            --n2;
        }
        return n2 == 0 ? PolygonHit.Outside : PolygonHit.Inside;
    }

    public static enum Type {
        LineString,
        Point,
        Polygon;

    }

    private static enum PolygonHit {
        OnEdge,
        Inside,
        Outside;

    }

    public static final class TrianglesPerZoom {
        public float[] m_triangles;
        double m_delta;
    }
}

