/*
 * Decompiled with CFR 0.152.
 */
package zombie.worldMap;

import java.util.ArrayList;
import zombie.worldMap.WorldMapCell;
import zombie.worldMap.WorldMapGeometry;
import zombie.worldMap.WorldMapProperties;

public final class WorldMapFeature {
    public final WorldMapCell m_cell;
    public final ArrayList<WorldMapGeometry> m_geometries = new ArrayList();
    public WorldMapProperties m_properties = null;

    WorldMapFeature(WorldMapCell worldMapCell) {
        this.m_cell = worldMapCell;
    }

    public boolean hasLineString() {
        for (int i = 0; i < this.m_geometries.size(); ++i) {
            if (this.m_geometries.get((int)i).m_type != WorldMapGeometry.Type.LineString) continue;
            return true;
        }
        return false;
    }

    public boolean hasPoint() {
        for (int i = 0; i < this.m_geometries.size(); ++i) {
            if (this.m_geometries.get((int)i).m_type != WorldMapGeometry.Type.Point) continue;
            return true;
        }
        return false;
    }

    public boolean hasPolygon() {
        for (int i = 0; i < this.m_geometries.size(); ++i) {
            if (this.m_geometries.get((int)i).m_type != WorldMapGeometry.Type.Polygon) continue;
            return true;
        }
        return false;
    }

    public boolean containsPoint(float f, float f2) {
        for (int i = 0; i < this.m_geometries.size(); ++i) {
            WorldMapGeometry worldMapGeometry = this.m_geometries.get(i);
            if (!worldMapGeometry.containsPoint(f, f2)) continue;
            return true;
        }
        return false;
    }

    public void dispose() {
        for (WorldMapGeometry worldMapGeometry : this.m_geometries) {
            worldMapGeometry.dispose();
        }
        this.m_properties.clear();
    }
}

