/*
 * Decompiled with CFR 0.152.
 */
package zombie.worldMap;

import java.util.ArrayList;
import zombie.ZomboidFileSystem;
import zombie.asset.Asset;
import zombie.asset.AssetStateObserver;
import zombie.inventory.types.MapItem;
import zombie.iso.IsoMetaGrid;
import zombie.iso.IsoWorld;
import zombie.util.StringUtils;
import zombie.worldMap.WorldMapCell;
import zombie.worldMap.WorldMapData;
import zombie.worldMap.WorldMapImages;
import zombie.worldMap.WorldMapSettings;
import zombie.worldMap.WorldMapVisited;
import zombie.worldMap.symbols.MapSymbolDefinitions;

public final class WorldMap
implements AssetStateObserver {
    public final ArrayList<WorldMapData> m_data = new ArrayList();
    public final ArrayList<WorldMapImages> m_images = new ArrayList();
    public int m_minDataX;
    public int m_minDataY;
    public int m_maxDataX;
    public int m_maxDataY;
    public int m_minX;
    public int m_minY;
    public int m_maxX;
    public int m_maxY;
    private boolean m_boundsFromData = false;
    public final ArrayList<WorldMapData> m_lastDataInDirectory = new ArrayList();

    public void setBoundsInCells(int n, int n2, int n3, int n4) {
        this.setBoundsInSquares(n * 300, n2 * 300, n3 * 300 + 299, n4 * 300 + 299);
    }

    public void setBoundsInSquares(int n, int n2, int n3, int n4) {
        this.m_minX = n;
        this.m_minY = n2;
        this.m_maxX = n3;
        this.m_maxY = n4;
    }

    public void setBoundsFromData() {
        this.m_boundsFromData = true;
        this.setBoundsInCells(this.m_minDataX, this.m_minDataY, this.m_maxDataX, this.m_maxDataY);
    }

    public void setBoundsFromWorld() {
        IsoMetaGrid isoMetaGrid = IsoWorld.instance.getMetaGrid();
        this.setBoundsInCells(isoMetaGrid.getMinX(), isoMetaGrid.getMinY(), isoMetaGrid.getMaxX(), isoMetaGrid.getMaxY());
    }

    public void addData(String string) {
        if (StringUtils.isNullOrWhitespace(string)) {
            return;
        }
        String string2 = ZomboidFileSystem.instance.getString(string);
        WorldMapData worldMapData = WorldMapData.getOrCreateData(string2);
        if (worldMapData != null && !this.m_data.contains(worldMapData)) {
            worldMapData.m_relativeFileName = string;
            this.m_data.add(worldMapData);
            worldMapData.getObserverCb().add(this);
            if (worldMapData.isReady()) {
                this.updateDataBounds();
            }
        }
    }

    public int getDataCount() {
        return this.m_data.size();
    }

    public WorldMapData getDataByIndex(int n) {
        return this.m_data.get(n);
    }

    public void clearData() {
        for (WorldMapData worldMapData : this.m_data) {
            worldMapData.getObserverCb().remove(this);
        }
        this.m_data.clear();
        this.m_lastDataInDirectory.clear();
        this.updateDataBounds();
    }

    public void endDirectoryData() {
        WorldMapData worldMapData;
        if (this.hasData() && !this.m_lastDataInDirectory.contains(worldMapData = this.getDataByIndex(this.getDataCount() - 1))) {
            this.m_lastDataInDirectory.add(worldMapData);
        }
    }

    public boolean isLastDataInDirectory(WorldMapData worldMapData) {
        return this.m_lastDataInDirectory.contains(worldMapData);
    }

    private void updateDataBounds() {
        this.m_minDataX = Integer.MAX_VALUE;
        this.m_minDataY = Integer.MAX_VALUE;
        this.m_maxDataX = Integer.MIN_VALUE;
        this.m_maxDataY = Integer.MIN_VALUE;
        for (int i = 0; i < this.m_data.size(); ++i) {
            WorldMapData worldMapData = this.m_data.get(i);
            if (!worldMapData.isReady()) continue;
            this.m_minDataX = Math.min(this.m_minDataX, worldMapData.m_minX);
            this.m_minDataY = Math.min(this.m_minDataY, worldMapData.m_minY);
            this.m_maxDataX = Math.max(this.m_maxDataX, worldMapData.m_maxX);
            this.m_maxDataY = Math.max(this.m_maxDataY, worldMapData.m_maxY);
        }
        if (this.m_minDataX > this.m_maxDataX) {
            this.m_maxDataY = 0;
            this.m_minDataY = 0;
            this.m_maxDataX = 0;
            this.m_minDataX = 0;
        }
    }

    public boolean hasData() {
        return !this.m_data.isEmpty();
    }

    public void addImages(String string) {
        if (StringUtils.isNullOrWhitespace(string)) {
            return;
        }
        WorldMapImages worldMapImages = WorldMapImages.getOrCreate(string);
        if (worldMapImages != null && !this.m_images.contains(worldMapImages)) {
            this.m_images.add(worldMapImages);
        }
    }

    public boolean hasImages() {
        return !this.m_images.isEmpty();
    }

    public int getImagesCount() {
        return this.m_images.size();
    }

    public WorldMapImages getImagesByIndex(int n) {
        return this.m_images.get(n);
    }

    public int getMinXInCells() {
        return this.m_minX / 300;
    }

    public int getMinYInCells() {
        return this.m_minY / 300;
    }

    public int getMaxXInCells() {
        return this.m_maxX / 300;
    }

    public int getMaxYInCells() {
        return this.m_maxY / 300;
    }

    public int getWidthInCells() {
        return this.getMaxXInCells() - this.getMinXInCells() + 1;
    }

    public int getHeightInCells() {
        return this.getMaxYInCells() - this.getMinYInCells() + 1;
    }

    public int getMinXInSquares() {
        return this.m_minX;
    }

    public int getMinYInSquares() {
        return this.m_minY;
    }

    public int getMaxXInSquares() {
        return this.m_maxX;
    }

    public int getMaxYInSquares() {
        return this.m_maxY;
    }

    public int getWidthInSquares() {
        return this.m_maxX - this.m_minX + 1;
    }

    public int getHeightInSquares() {
        return this.m_maxY - this.m_minY + 1;
    }

    public WorldMapCell getCell(int n, int n2) {
        for (int i = 0; i < this.m_data.size(); ++i) {
            WorldMapCell worldMapCell;
            WorldMapData worldMapData = this.m_data.get(i);
            if (!worldMapData.isReady() || (worldMapCell = worldMapData.getCell(n, n2)) == null) continue;
            return worldMapCell;
        }
        return null;
    }

    public int getDataWidthInCells() {
        return this.m_maxDataX - this.m_minDataX + 1;
    }

    public int getDataHeightInCells() {
        return this.m_maxDataY - this.m_minDataY + 1;
    }

    public int getDataWidthInSquares() {
        return this.getDataWidthInCells() * 300;
    }

    public int getDataHeightInSquares() {
        return this.getDataHeightInCells() * 300;
    }

    public static void Reset() {
        WorldMapSettings.Reset();
        WorldMapVisited.Reset();
        WorldMapData.Reset();
        WorldMapImages.Reset();
        MapSymbolDefinitions.Reset();
        MapItem.Reset();
    }

    @Override
    public void onStateChanged(Asset.State state, Asset.State state2, Asset asset) {
        this.updateDataBounds();
        if (this.m_boundsFromData) {
            this.setBoundsInCells(this.m_minDataX, this.m_minDataY, this.m_maxDataX, this.m_maxDataY);
        }
    }
}

