/*
 * Decompiled with CFR 0.152.
 */
package zombie.worldMap;

import java.util.ArrayList;
import se.krka.kahlua.vm.KahluaTable;
import zombie.Lua.LuaManager;
import zombie.characters.Faction;
import zombie.characters.IsoPlayer;
import zombie.core.Core;
import zombie.core.SpriteRenderer;
import zombie.core.math.PZMath;
import zombie.debug.DebugOptions;
import zombie.input.GameKeyboard;
import zombie.inventory.types.MapItem;
import zombie.iso.BuildingDef;
import zombie.iso.IsoMetaGrid;
import zombie.iso.IsoWorld;
import zombie.iso.RoomDef;
import zombie.iso.areas.SafeHouse;
import zombie.network.GameClient;
import zombie.network.ServerOptions;
import zombie.ui.TextManager;
import zombie.ui.UIElement;
import zombie.ui.UIFont;
import zombie.util.StringUtils;
import zombie.worldMap.UIWorldMapV1;
import zombie.worldMap.WorldMap;
import zombie.worldMap.WorldMapData;
import zombie.worldMap.WorldMapFeature;
import zombie.worldMap.WorldMapPoints;
import zombie.worldMap.WorldMapRemotePlayer;
import zombie.worldMap.WorldMapRemotePlayers;
import zombie.worldMap.WorldMapRenderer;
import zombie.worldMap.WorldMapSettings;
import zombie.worldMap.WorldMapVisited;
import zombie.worldMap.editor.WorldMapEditorState;
import zombie.worldMap.markers.WorldMapGridSquareMarker;
import zombie.worldMap.markers.WorldMapMarkers;
import zombie.worldMap.markers.WorldMapMarkersV1;
import zombie.worldMap.styles.WorldMapStyle;
import zombie.worldMap.styles.WorldMapStyleLayer;
import zombie.worldMap.styles.WorldMapStyleV1;
import zombie.worldMap.symbols.MapSymbolDefinitions;
import zombie.worldMap.symbols.WorldMapSymbols;
import zombie.worldMap.symbols.WorldMapSymbolsV1;

public class UIWorldMap
extends UIElement {
    static final ArrayList<WorldMapFeature> s_tempFeatures = new ArrayList();
    protected final WorldMap m_worldMap = new WorldMap();
    protected final WorldMapStyle m_style = new WorldMapStyle();
    protected final WorldMapRenderer m_renderer = new WorldMapRenderer();
    protected final WorldMapMarkers m_markers = new WorldMapMarkers();
    protected WorldMapSymbols m_symbols = null;
    protected final WorldMapStyleLayer.RGBAf m_color = new WorldMapStyleLayer.RGBAf().init(0.85882354f, 0.84313726f, 0.7529412f, 1.0f);
    protected final UIWorldMapV1 m_APIv1 = new UIWorldMapV1(this);
    private boolean m_dataWasReady = false;
    private final ArrayList<BuildingDef> m_buildingsWithoutFeatures = new ArrayList();
    private boolean m_bBuildingsWithoutFeatures = false;

    public UIWorldMap(KahluaTable kahluaTable) {
        super(kahluaTable);
    }

    public UIWorldMapV1 getAPI() {
        return this.m_APIv1;
    }

    public UIWorldMapV1 getAPIv1() {
        return this.m_APIv1;
    }

    protected void setMapItem(MapItem mapItem) {
        this.m_symbols = mapItem.getSymbols();
    }

    @Override
    public void render() {
        int n;
        double d;
        float f;
        float f2;
        if (!this.isVisible().booleanValue()) {
            return;
        }
        if (this.Parent != null && this.Parent.getMaxDrawHeight() != -1.0 && this.Parent.getMaxDrawHeight() <= this.getY()) {
            return;
        }
        this.DrawTextureScaledColor(null, 0.0, 0.0, this.getWidth(), this.getHeight(), Double.valueOf(this.m_color.r), Double.valueOf(this.m_color.g), Double.valueOf(this.m_color.b), Double.valueOf(this.m_color.a));
        if (!this.m_worldMap.hasData()) {
            // empty if block
        }
        this.setStencilRect(0.0, 0.0, this.getWidth(), this.getHeight());
        this.m_renderer.setMap(this.m_worldMap, this.getAbsoluteX().intValue(), this.getAbsoluteY().intValue(), this.getWidth().intValue(), this.getHeight().intValue());
        this.m_renderer.updateView();
        float f3 = this.m_renderer.getDisplayZoomF();
        float f4 = this.m_renderer.getCenterWorldX();
        float f5 = this.m_renderer.getCenterWorldY();
        float f6 = this.m_APIv1.getWorldScale(f3);
        if (this.m_renderer.getBoolean("HideUnvisited") && WorldMapVisited.getInstance() != null) {
            this.m_renderer.setVisited(WorldMapVisited.getInstance());
        } else {
            this.m_renderer.setVisited(null);
        }
        this.m_renderer.render(this);
        if (this.m_renderer.getBoolean("Symbols")) {
            this.m_symbols.render(this);
        }
        this.m_markers.render(this);
        this.renderLocalPlayers();
        this.renderRemotePlayers();
        int n2 = TextManager.instance.getFontHeight(UIFont.Small);
        if (Core.bDebug && this.m_renderer.getBoolean("DebugInfo")) {
            this.DrawTextureScaledColor(null, 0.0, 0.0, 200.0, (double)n2 * 4.0, 1.0, 1.0, 1.0, 1.0);
            f2 = this.m_APIv1.mouseToWorldX();
            f = this.m_APIv1.mouseToWorldY();
            d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 1.0;
            n = 0;
            this.DrawText("SQUARE = " + (int)f2 + "," + (int)f, 0.0, n, d, d2, d3, d4);
            n += n2;
            this.DrawText("CELL = " + (int)(f2 / 300.0f) + "," + (int)(f / 300.0f), 0.0, n2, d, d2, d3, d4);
            this.DrawText("ZOOM = " + this.m_renderer.getDisplayZoomF(), 0.0, n += n2, d, d2, d3, d4);
            this.DrawText("SCALE = " + this.m_renderer.getWorldScale(this.m_renderer.getZoomF()), 0.0, n += n2, d, d2, d3, d4);
            n += n2;
        }
        this.clearStencilRect();
        this.repaintStencilRect(0.0, 0.0, this.width, this.height);
        if (Core.bDebug && DebugOptions.instance.UIRenderOutline.getValue()) {
            Double d5 = -this.getXScroll().doubleValue();
            Double d6 = -this.getYScroll().doubleValue();
            d = this.isMouseOver() != false ? 0.0 : 1.0;
            this.DrawTextureScaledColor(null, d5, d6, 1.0, Double.valueOf(this.height), d, 1.0, 1.0, 0.5);
            this.DrawTextureScaledColor(null, d5 + 1.0, d6, (double)this.width - 2.0, 1.0, d, 1.0, 1.0, 0.5);
            this.DrawTextureScaledColor(null, d5 + (double)this.width - 1.0, d6, 1.0, Double.valueOf(this.height), d, 1.0, 1.0, 0.5);
            this.DrawTextureScaledColor(null, d5 + 1.0, d6 + (double)this.height - 1.0, (double)this.width - 2.0, 1.0, d, 1.0, 1.0, 0.5);
        }
        if (Core.bDebug && this.m_renderer.getBoolean("HitTest")) {
            f2 = this.m_APIv1.mouseToWorldX();
            f = this.m_APIv1.mouseToWorldY();
            s_tempFeatures.clear();
            for (WorldMapData worldMapData : this.m_worldMap.m_data) {
                if (!worldMapData.isReady()) continue;
                worldMapData.hitTest(f2, f, s_tempFeatures);
            }
            if (!s_tempFeatures.isEmpty()) {
                WorldMapFeature worldMapFeature = s_tempFeatures.get(s_tempFeatures.size() - 1);
                int n3 = worldMapFeature.m_cell.m_x * 300;
                int n4 = worldMapFeature.m_cell.m_y * 300;
                int n5 = this.getAbsoluteX().intValue();
                int n6 = this.getAbsoluteY().intValue();
                WorldMapPoints worldMapPoints = worldMapFeature.m_geometries.get((int)0).m_points.get(0);
                for (int i = 0; i < worldMapPoints.numPoints(); ++i) {
                    int n7 = worldMapPoints.getX(i);
                    n = worldMapPoints.getY(i);
                    int n8 = worldMapPoints.getX((i + 1) % worldMapPoints.numPoints());
                    int n9 = worldMapPoints.getY((i + 1) % worldMapPoints.numPoints());
                    float f7 = this.m_APIv1.worldToUIX(n3 + n7, n4 + n);
                    float f8 = this.m_APIv1.worldToUIY(n3 + n7, n4 + n);
                    float f9 = this.m_APIv1.worldToUIX(n3 + n8, n4 + n9);
                    float f10 = this.m_APIv1.worldToUIY(n3 + n8, n4 + n9);
                    SpriteRenderer.instance.renderline(null, n5 + (int)f7, n6 + (int)f8, n5 + (int)f9, n6 + (int)f10, 1.0f, 0.0f, 0.0f, 1.0f);
                }
            }
        }
        if (Core.bDebug && this.m_renderer.getBoolean("BuildingsWithoutFeatures") && !this.m_renderer.getBoolean("Isometric")) {
            this.renderBuildingsWithoutFeatures();
        }
        super.render();
    }

    private void renderLocalPlayers() {
        if (!this.m_renderer.getBoolean("Players")) {
            return;
        }
        float f = this.m_renderer.getDisplayZoomF();
        if (f >= 20.0f) {
            return;
        }
        for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
            IsoPlayer isoPlayer = IsoPlayer.players[i];
            if (isoPlayer == null || isoPlayer.isDead()) continue;
            float f2 = isoPlayer.x;
            float f3 = isoPlayer.y;
            if (isoPlayer.getVehicle() != null) {
                f2 = isoPlayer.getVehicle().getX();
                f3 = isoPlayer.getVehicle().getY();
            }
            this.renderPlayer(f2, f3);
            if (!GameClient.bClient) continue;
            this.renderPlayerName(f2, f3, isoPlayer.getUsername());
        }
    }

    private void renderRemotePlayers() {
        if (!GameClient.bClient) {
            return;
        }
        if (!this.m_renderer.getBoolean("Players")) {
            return;
        }
        if (!this.m_renderer.getBoolean("RemotePlayers")) {
            return;
        }
        ArrayList<WorldMapRemotePlayer> arrayList = WorldMapRemotePlayers.instance.getPlayers();
        for (int i = 0; i < arrayList.size(); ++i) {
            WorldMapRemotePlayer worldMapRemotePlayer = arrayList.get(i);
            if (!this.shouldShowRemotePlayer(worldMapRemotePlayer)) continue;
            this.renderPlayer(worldMapRemotePlayer.getX(), worldMapRemotePlayer.getY());
            this.renderPlayerName(worldMapRemotePlayer.getX(), worldMapRemotePlayer.getY(), worldMapRemotePlayer.getUsername());
        }
    }

    private boolean shouldShowRemotePlayer(WorldMapRemotePlayer worldMapRemotePlayer) {
        if (!worldMapRemotePlayer.hasFullData()) {
            return false;
        }
        if (worldMapRemotePlayer.isInvisible()) {
            return this.isAdminSeeRemotePlayers();
        }
        if (ServerOptions.getInstance().MapRemotePlayerVisibility.getValue() == 3) {
            return true;
        }
        if (this.isAdminSeeRemotePlayers()) {
            return true;
        }
        if (ServerOptions.getInstance().MapRemotePlayerVisibility.getValue() == 1) {
            return false;
        }
        for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
            IsoPlayer isoPlayer = IsoPlayer.players[i];
            if (isoPlayer == null) continue;
            if (this.isInSameFaction(isoPlayer, worldMapRemotePlayer)) {
                return true;
            }
            if (!this.isInSameSafehouse(isoPlayer, worldMapRemotePlayer)) continue;
            return true;
        }
        return false;
    }

    private boolean isAdminSeeRemotePlayers() {
        for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
            IsoPlayer isoPlayer = IsoPlayer.players[i];
            if (isoPlayer == null || isoPlayer.isAccessLevel("none")) continue;
            return true;
        }
        return false;
    }

    private boolean isInSameFaction(IsoPlayer isoPlayer, WorldMapRemotePlayer worldMapRemotePlayer) {
        Faction faction = Faction.getPlayerFaction(isoPlayer);
        Faction faction2 = Faction.getPlayerFaction(worldMapRemotePlayer.getUsername());
        return faction != null && faction == faction2;
    }

    private boolean isInSameSafehouse(IsoPlayer isoPlayer, WorldMapRemotePlayer worldMapRemotePlayer) {
        ArrayList<SafeHouse> arrayList = SafeHouse.getSafehouseList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SafeHouse safeHouse = arrayList.get(i);
            if (!safeHouse.playerAllowed(isoPlayer.getUsername()) || !safeHouse.playerAllowed(worldMapRemotePlayer.getUsername())) continue;
            return true;
        }
        return false;
    }

    private void renderPlayer(float f, float f2) {
        float f3 = this.m_renderer.getDisplayZoomF();
        float f4 = this.m_renderer.getCenterWorldX();
        float f5 = this.m_renderer.getCenterWorldY();
        float f6 = this.m_APIv1.worldToUIX(f, f2, f3, f4, f5, this.m_renderer.getProjectionMatrix(), this.m_renderer.getModelViewMatrix());
        float f7 = this.m_APIv1.worldToUIY(f, f2, f3, f4, f5, this.m_renderer.getProjectionMatrix(), this.m_renderer.getModelViewMatrix());
        f6 = PZMath.floor(f6);
        f7 = PZMath.floor(f7);
        this.DrawTextureScaledColor(null, (double)f6 - 3.0, (double)f7 - 3.0, 6.0, 6.0, 1.0, 0.0, 0.0, 1.0);
    }

    private void renderPlayerName(float f, float f2, String string) {
        if (!this.m_renderer.getBoolean("PlayerNames")) {
            return;
        }
        if (StringUtils.isNullOrWhitespace(string)) {
            return;
        }
        float f3 = this.m_renderer.getDisplayZoomF();
        float f4 = this.m_renderer.getCenterWorldX();
        float f5 = this.m_renderer.getCenterWorldY();
        float f6 = this.m_APIv1.worldToUIX(f, f2, f3, f4, f5, this.m_renderer.getProjectionMatrix(), this.m_renderer.getModelViewMatrix());
        float f7 = this.m_APIv1.worldToUIY(f, f2, f3, f4, f5, this.m_renderer.getProjectionMatrix(), this.m_renderer.getModelViewMatrix());
        f6 = PZMath.floor(f6);
        f7 = PZMath.floor(f7);
        int n = TextManager.instance.MeasureStringX(UIFont.Small, string) + 16;
        int n2 = TextManager.instance.font.getLineHeight();
        int n3 = (int)Math.ceil((double)n2 * 1.25);
        this.DrawTextureScaledColor(null, (double)f6 - (double)n / 2.0, (double)f7 + 4.0, Double.valueOf(n), Double.valueOf(n3), 0.5, 0.5, 0.5, 0.5);
        this.DrawTextCentre(string, f6, (double)(f7 + 4.0f) + (double)(n3 - n2) / 2.0, 0.0, 0.0, 0.0, 1.0);
    }

    @Override
    public void update() {
        super.update();
    }

    @Override
    public Boolean onMouseDown(double d, double d2) {
        if (GameKeyboard.isKeyDown(42)) {
            this.m_renderer.resetView();
        }
        return super.onMouseDown(d, d2);
    }

    @Override
    public Boolean onMouseUp(double d, double d2) {
        return super.onMouseUp(d, d2);
    }

    @Override
    public void onMouseUpOutside(double d, double d2) {
        super.onMouseUpOutside(d, d2);
    }

    @Override
    public Boolean onMouseMove(double d, double d2) {
        return super.onMouseMove(d, d2);
    }

    @Override
    public Boolean onMouseWheel(double d) {
        return super.onMouseWheel(d);
    }

    public static void setExposed(LuaManager.Exposer exposer) {
        exposer.setExposed(MapItem.class);
        exposer.setExposed(MapSymbolDefinitions.class);
        exposer.setExposed(MapSymbolDefinitions.MapSymbolDefinition.class);
        exposer.setExposed(UIWorldMap.class);
        exposer.setExposed(UIWorldMapV1.class);
        exposer.setExposed(WorldMapGridSquareMarker.class);
        exposer.setExposed(WorldMapMarkers.class);
        exposer.setExposed(WorldMapRenderer.WorldMapBooleanOption.class);
        exposer.setExposed(WorldMapRenderer.WorldMapDoubleOption.class);
        exposer.setExposed(WorldMapVisited.class);
        WorldMapMarkersV1.setExposed(exposer);
        WorldMapStyleV1.setExposed(exposer);
        WorldMapSymbolsV1.setExposed(exposer);
        exposer.setExposed(WorldMapEditorState.class);
        exposer.setExposed(WorldMapSettings.class);
    }

    private void renderBuildingsWithoutFeatures() {
        if (this.m_bBuildingsWithoutFeatures) {
            for (BuildingDef buildingDef : this.m_buildingsWithoutFeatures) {
                this.debugRenderBuilding(buildingDef, 1.0f, 0.0f, 0.0f, 1.0f);
            }
            return;
        }
        this.m_bBuildingsWithoutFeatures = true;
        this.m_buildingsWithoutFeatures.clear();
        IsoMetaGrid isoMetaGrid = IsoWorld.instance.MetaGrid;
        for (int i = 0; i < isoMetaGrid.Buildings.size(); ++i) {
            BuildingDef buildingDef = isoMetaGrid.Buildings.get(i);
            boolean bl = false;
            for (int j = 0; j < buildingDef.rooms.size(); ++j) {
                RoomDef roomDef = buildingDef.rooms.get(j);
                if (roomDef.level > 0) continue;
                ArrayList<RoomDef.RoomRect> arrayList = roomDef.getRects();
                for (int k = 0; k < arrayList.size(); ++k) {
                    RoomDef.RoomRect roomRect = arrayList.get(k);
                    s_tempFeatures.clear();
                    for (WorldMapData worldMapData : this.m_worldMap.m_data) {
                        if (!worldMapData.isReady()) continue;
                        worldMapData.hitTest((float)roomRect.x + (float)roomRect.w / 2.0f, (float)roomRect.y + (float)roomRect.h / 2.0f, s_tempFeatures);
                    }
                    if (s_tempFeatures.isEmpty()) continue;
                    bl = true;
                    break;
                }
                if (bl) break;
            }
            if (bl) continue;
            this.m_buildingsWithoutFeatures.add(buildingDef);
        }
    }

    private void debugRenderBuilding(BuildingDef buildingDef, float f, float f2, float f3, float f4) {
        for (int i = 0; i < buildingDef.rooms.size(); ++i) {
            ArrayList<RoomDef.RoomRect> arrayList = buildingDef.rooms.get(i).getRects();
            for (int j = 0; j < arrayList.size(); ++j) {
                RoomDef.RoomRect roomRect = arrayList.get(j);
                float f5 = this.m_APIv1.worldToUIX(roomRect.x, roomRect.y);
                float f6 = this.m_APIv1.worldToUIY(roomRect.x, roomRect.y);
                float f7 = this.m_APIv1.worldToUIX(roomRect.getX2(), roomRect.getY2());
                float f8 = this.m_APIv1.worldToUIY(roomRect.getX2(), roomRect.getY2());
                this.DrawTextureScaledColor(null, Double.valueOf(f5), Double.valueOf(f6), Double.valueOf(f7 - f5), Double.valueOf(f8 - f6), Double.valueOf(f), Double.valueOf(f2), Double.valueOf(f3), Double.valueOf(f4));
            }
        }
    }
}

