/*
 * Decompiled with CFR 0.152.
 */
package zombie.worldMap;

import java.util.ArrayList;

public class StrokeGeometry {
    static Point s_firstPoint = null;
    static Point s_lastPoint = null;
    static final double EPSILON = 1.0E-4;

    static Point newPoint(double d, double d2) {
        if (s_firstPoint == null) {
            return new Point(d, d2);
        }
        Point point = s_firstPoint;
        s_firstPoint = StrokeGeometry.s_firstPoint.next;
        if (s_lastPoint == point) {
            s_lastPoint = null;
        }
        point.next = null;
        return point.set(d, d2);
    }

    static void release(Point point) {
        if (point.next != null || point == s_lastPoint) {
            return;
        }
        point.next = s_firstPoint;
        s_firstPoint = point;
        if (s_lastPoint == null) {
            s_lastPoint = point;
        }
    }

    static void release(ArrayList<Point> arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            StrokeGeometry.release(arrayList.get(i));
        }
    }

    static ArrayList<Point> getStrokeGeometry(Point[] pointArray, Attrs attrs) {
        if (pointArray.length < 2) {
            return null;
        }
        String string = attrs.cap;
        String string2 = attrs.join;
        float f = attrs.width / 2.0f;
        float f2 = attrs.miterLimit;
        ArrayList<Point> arrayList = new ArrayList<Point>();
        ArrayList<Point> arrayList2 = new ArrayList<Point>();
        boolean bl = false;
        if (pointArray.length == 2) {
            string2 = "bevel";
            StrokeGeometry.createTriangles(pointArray[0], Point.Middle(pointArray[0], pointArray[1]), pointArray[1], arrayList, f, string2, f2);
        } else {
            int n;
            for (n = 0; n < pointArray.length - 1; ++n) {
                if (n == 0) {
                    arrayList2.add(pointArray[0]);
                    continue;
                }
                if (n == pointArray.length - 2) {
                    arrayList2.add(pointArray[pointArray.length - 1]);
                    continue;
                }
                arrayList2.add(Point.Middle(pointArray[n], pointArray[n + 1]));
            }
            for (n = 1; n < arrayList2.size(); ++n) {
                StrokeGeometry.createTriangles((Point)arrayList2.get(n - 1), pointArray[n], (Point)arrayList2.get(n), arrayList, f, string2, f2);
            }
        }
        if (!bl) {
            if (string.equals("round")) {
                Point point = arrayList.get(0);
                Point point2 = arrayList.get(1);
                Point point3 = pointArray[1];
                Point point4 = arrayList.get(arrayList.size() - 1);
                Point point5 = arrayList.get(arrayList.size() - 3);
                Point point6 = pointArray[pointArray.length - 2];
                StrokeGeometry.createRoundCap(pointArray[0], point, point2, point3, arrayList);
                StrokeGeometry.createRoundCap(pointArray[pointArray.length - 1], point4, point5, point6, arrayList);
            } else if (string.equals("square")) {
                Point point = arrayList.get(arrayList.size() - 1);
                Point point7 = arrayList.get(arrayList.size() - 3);
                StrokeGeometry.createSquareCap(arrayList.get(0), arrayList.get(1), Point.Sub(pointArray[0], pointArray[1]).normalize().scalarMult(Point.Sub(pointArray[0], arrayList.get(0)).length()), arrayList);
                StrokeGeometry.createSquareCap(point, point7, Point.Sub(pointArray[pointArray.length - 1], pointArray[pointArray.length - 2]).normalize().scalarMult(Point.Sub(point7, pointArray[pointArray.length - 1]).length()), arrayList);
            }
        }
        return arrayList;
    }

    static void createSquareCap(Point point, Point point2, Point point3, ArrayList<Point> arrayList) {
        arrayList.add(point);
        arrayList.add(Point.Add(point, point3));
        arrayList.add(Point.Add(point2, point3));
        arrayList.add(point2);
        arrayList.add(Point.Add(point2, point3));
        arrayList.add(point);
    }

    static void createRoundCap(Point point, Point point2, Point point3, Point point4, ArrayList<Point> arrayList) {
        double d;
        double d2 = Point.Sub(point, point2).length();
        double d3 = Math.atan2(point3.y - point.y, point3.x - point.x);
        double d4 = Math.atan2(point2.y - point.y, point2.x - point.x);
        double d5 = d3;
        if (d4 > d3) {
            if (d4 - d3 >= 3.141492653589793) {
                d4 -= Math.PI * 2;
            }
        } else if (d3 - d4 >= 3.141492653589793) {
            d3 -= Math.PI * 2;
        }
        if (Math.abs(d = d4 - d3) >= 3.141492653589793 && Math.abs(d) <= 3.1416926535897933) {
            Point point5 = Point.Sub(point, point4);
            if (point5.x == 0.0) {
                if (point5.y > 0.0) {
                    d = -d;
                }
            } else if (point5.x >= -1.0E-4) {
                d = -d;
            }
        }
        int n = (int)(Math.abs(d * d2) / 7.0);
        double d6 = d / (double)(++n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(StrokeGeometry.newPoint(point.x, point.y));
            arrayList.add(StrokeGeometry.newPoint(point.x + d2 * Math.cos(d5 + d6 * (double)i), point.y + d2 * Math.sin(d5 + d6 * (double)i)));
            arrayList.add(StrokeGeometry.newPoint(point.x + d2 * Math.cos(d5 + d6 * (double)(1 + i)), point.y + d2 * Math.sin(d5 + d6 * (double)(1 + i))));
        }
    }

    static double signedArea(Point point, Point point2, Point point3) {
        return (point2.x - point.x) * (point3.y - point.y) - (point3.x - point.x) * (point2.y - point.y);
    }

    static Point lineIntersection(Point point, Point point2, Point point3, Point point4) {
        double d = point2.y - point.y;
        double d2 = point3.x - point4.x;
        double d3 = point4.y - point3.y;
        double d4 = point.x - point2.x;
        double d5 = d * d2 - d3 * d4;
        if (d5 > -1.0E-4 && d5 < 1.0E-4) {
            return null;
        }
        double d6 = d * point.x + d4 * point.y;
        double d7 = d3 * point3.x + d2 * point3.y;
        double d8 = (d2 * d6 - d4 * d7) / d5;
        double d9 = (d * d7 - d3 * d6) / d5;
        return StrokeGeometry.newPoint(d8, d9);
    }

    static void createTriangles(Point point, Point point2, Point point3, ArrayList<Point> arrayList, float f, String string, float f2) {
        Point point4 = Point.Sub(point2, point);
        Point point5 = Point.Sub(point3, point2);
        point4.perpendicular();
        point5.perpendicular();
        if (StrokeGeometry.signedArea(point, point2, point3) > 0.0) {
            point4.invert();
            point5.invert();
        }
        point4.normalize();
        point5.normalize();
        point4.scalarMult(f);
        point5.scalarMult(f);
        Point point6 = StrokeGeometry.lineIntersection(Point.Add(point4, point), Point.Add(point4, point2), Point.Add(point5, point3), Point.Add(point5, point2));
        Point point7 = null;
        double d = Double.MAX_VALUE;
        if (point6 != null) {
            point7 = Point.Sub(point6, point2);
            d = point7.length();
        }
        double d2 = (int)(d / (double)f);
        Point point8 = Point.Sub(point, point2);
        double d3 = point8.length();
        Point point9 = Point.Sub(point2, point3);
        double d4 = point9.length();
        if (d > d3 || d > d4) {
            arrayList.add(Point.Add(point, point4));
            arrayList.add(Point.Sub(point, point4));
            arrayList.add(Point.Add(point2, point4));
            arrayList.add(Point.Sub(point, point4));
            arrayList.add(Point.Add(point2, point4));
            arrayList.add(Point.Sub(point2, point4));
            if (string.equals("round")) {
                StrokeGeometry.createRoundCap(point2, Point.Add(point2, point4), Point.Add(point2, point5), point3, arrayList);
            } else if (string.equals("bevel") || string.equals("miter") && d2 >= (double)f2) {
                arrayList.add(point2);
                arrayList.add(Point.Add(point2, point4));
                arrayList.add(Point.Add(point2, point5));
            } else if (string.equals("miter") && d2 < (double)f2 && point6 != null) {
                arrayList.add(Point.Add(point2, point4));
                arrayList.add(point2);
                arrayList.add(point6);
                arrayList.add(Point.Add(point2, point5));
                arrayList.add(point2);
                arrayList.add(point6);
            }
            arrayList.add(Point.Add(point3, point5));
            arrayList.add(Point.Sub(point2, point5));
            arrayList.add(Point.Add(point2, point5));
            arrayList.add(Point.Add(point3, point5));
            arrayList.add(Point.Sub(point2, point5));
            arrayList.add(Point.Sub(point3, point5));
        } else {
            arrayList.add(Point.Add(point, point4));
            arrayList.add(Point.Sub(point, point4));
            arrayList.add(Point.Sub(point2, point7));
            arrayList.add(Point.Add(point, point4));
            arrayList.add(Point.Sub(point2, point7));
            arrayList.add(Point.Add(point2, point4));
            if (string.equals("round")) {
                Point point10 = Point.Add(point2, point4);
                Point point11 = Point.Add(point2, point5);
                Point point12 = Point.Sub(point2, point7);
                Point point13 = point2;
                arrayList.add(point10);
                arrayList.add(point13);
                arrayList.add(point12);
                StrokeGeometry.createRoundCap(point13, point10, point11, point12, arrayList);
                arrayList.add(point13);
                arrayList.add(point11);
                arrayList.add(point12);
            } else {
                if (string.equals("bevel") || string.equals("miter") && d2 >= (double)f2) {
                    arrayList.add(Point.Add(point2, point4));
                    arrayList.add(Point.Add(point2, point5));
                    arrayList.add(Point.Sub(point2, point7));
                }
                if (string.equals("miter") && d2 < (double)f2) {
                    arrayList.add(point6);
                    arrayList.add(Point.Add(point2, point4));
                    arrayList.add(Point.Add(point2, point5));
                }
            }
            arrayList.add(Point.Add(point3, point5));
            arrayList.add(Point.Sub(point2, point7));
            arrayList.add(Point.Add(point2, point5));
            arrayList.add(Point.Add(point3, point5));
            arrayList.add(Point.Sub(point2, point7));
            arrayList.add(Point.Sub(point3, point5));
        }
    }

    public static final class Point {
        double x;
        double y;
        Point next;

        Point() {
            this.x = 0.0;
            this.y = 0.0;
        }

        Point(double d, double d2) {
            this.x = d;
            this.y = d2;
        }

        Point set(double d, double d2) {
            this.x = d;
            this.y = d2;
            return this;
        }

        Point scalarMult(double d) {
            this.x *= d;
            this.y *= d;
            return this;
        }

        Point perpendicular() {
            double d = this.x;
            this.x = -this.y;
            this.y = d;
            return this;
        }

        Point invert() {
            this.x = -this.x;
            this.y = -this.y;
            return this;
        }

        double length() {
            return Math.sqrt(this.x * this.x + this.y * this.y);
        }

        Point normalize() {
            double d = this.length();
            this.x /= d;
            this.y /= d;
            return this;
        }

        double angle() {
            return this.y / this.x;
        }

        static double Angle(Point point, Point point2) {
            return Math.atan2(point2.x - point.x, point2.y - point.y);
        }

        static Point Add(Point point, Point point2) {
            return StrokeGeometry.newPoint(point.x + point2.x, point.y + point2.y);
        }

        static Point Sub(Point point, Point point2) {
            return StrokeGeometry.newPoint(point.x - point2.x, point.y - point2.y);
        }

        static Point Middle(Point point, Point point2) {
            return Point.Add(point, point2).scalarMult(0.5);
        }
    }

    static class Attrs {
        String cap = "butt";
        String join = "bevel";
        float width = 1.0f;
        float miterLimit = 10.0f;

        Attrs() {
        }
    }
}

