/*
 * Decompiled with CFR 0.152.
 */
package zombie.worldMap;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import zombie.core.Core;
import zombie.core.SpriteRenderer;
import zombie.core.logger.ExceptionLogger;
import zombie.core.math.PZMath;
import zombie.core.opengl.RenderThread;
import zombie.core.textures.ImageData;
import zombie.core.textures.MipMapLevel;
import zombie.core.textures.Texture;
import zombie.core.textures.TextureID;

public final class ImagePyramid {
    String m_directory;
    String m_zipFile;
    FileSystem m_zipFS;
    final HashMap<String, PyramidTexture> m_textures = new HashMap();
    final HashSet<String> m_missing = new HashSet();
    int m_requestNumber = 0;
    int m_minX;
    int m_minY;
    int m_maxX;
    int m_maxY;
    float m_resolution = 1.0f;
    int m_minZ;
    int m_maxZ;
    int MAX_TEXTURES = 100;
    int MAX_REQUEST_NUMBER = Core.bDebug ? 10000 : Integer.MAX_VALUE;

    public void setDirectory(String string) {
        if (this.m_zipFile != null) {
            this.m_zipFile = null;
            if (this.m_zipFS != null) {
                try {
                    this.m_zipFS.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.m_zipFS = null;
            }
        }
        this.m_directory = string;
    }

    public void setZipFile(String string) {
        this.m_directory = null;
        this.m_zipFile = string;
        this.m_zipFS = this.openZipFile();
        this.readInfoFile();
        this.m_minZ = Integer.MAX_VALUE;
        this.m_maxZ = Integer.MIN_VALUE;
        if (this.m_zipFS != null) {
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(this.m_zipFS.getPath("/", new String[0]));){
                for (Path path : directoryStream) {
                    if (!Files.isDirectory(path, new LinkOption[0])) continue;
                    int n = PZMath.tryParseInt(path.getFileName().toString(), -1);
                    this.m_minZ = PZMath.min(this.m_minZ, n);
                    this.m_maxZ = PZMath.max(this.m_maxZ, n);
                }
            }
            catch (IOException iOException) {
                ExceptionLogger.logException(iOException);
            }
        }
    }

    public Texture getImage(int n, int n2, int n3) {
        String string = String.format("%dx%dx%d", n, n2, n3);
        if (this.m_missing.contains(string)) {
            return null;
        }
        File file = new File(this.m_directory, String.format("%s%d%stile%dx%d.png", File.separator, n3, File.separator, n, n2));
        if (!file.exists()) {
            this.m_missing.add(string);
            return null;
        }
        return Texture.getSharedTexture(file.getAbsolutePath());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TextureID getTexture(int n, int n2, int n3) {
        String string = String.format("%dx%dx%d", n, n2, n3);
        if (this.m_textures.containsKey(string)) {
            PyramidTexture pyramidTexture = this.m_textures.get(string);
            pyramidTexture.m_requestNumber = this.m_requestNumber++;
            if (this.m_requestNumber < this.MAX_REQUEST_NUMBER) return pyramidTexture.m_textureID;
            this.resetRequestNumbers();
            return pyramidTexture.m_textureID;
        }
        if (this.m_missing.contains(string)) {
            return null;
        }
        if (this.m_zipFile != null) {
            if (this.m_zipFS == null) return null;
            if (!this.m_zipFS.isOpen()) {
                return null;
            }
            try {
                Path path = this.m_zipFS.getPath(String.valueOf(n3), String.format("tile%dx%d.png", n, n2));
                try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
                    TextureID textureID;
                    ImageData imageData = new ImageData(inputStream, false);
                    PyramidTexture pyramidTexture = this.checkTextureCache(string);
                    if (pyramidTexture.m_textureID == null) {
                        pyramidTexture.m_textureID = textureID = new TextureID(imageData);
                    } else {
                        this.replaceTextureData(pyramidTexture, imageData);
                    }
                    textureID = pyramidTexture.m_textureID;
                    return textureID;
                }
                catch (NoSuchFileException noSuchFileException) {
                    this.m_missing.add(string);
                    return null;
                }
            }
            catch (Exception exception) {
                this.m_missing.add(string);
                exception.printStackTrace();
            }
            return null;
        }
        File file = new File(this.m_directory, String.format("%s%d%stile%dx%d.png", File.separator, n3, File.separator, n, n2));
        if (!file.exists()) {
            this.m_missing.add(string);
            return null;
        }
        Texture texture = Texture.getSharedTexture(file.getAbsolutePath());
        if (texture == null) {
            return null;
        }
        TextureID textureID = texture.getTextureId();
        return textureID;
    }

    private void replaceTextureData(PyramidTexture pyramidTexture, ImageData imageData) {
        int n = GL.getCapabilities().GL_ARB_texture_compression ? 34030 : 6408;
        Texture.lastTextureID = pyramidTexture.m_textureID.getID();
        GL11.glBindTexture((int)3553, (int)Texture.lastTextureID);
        SpriteRenderer.ringBuffer.restoreBoundTextures = true;
        GL11.glTexImage2D((int)3553, (int)0, (int)n, (int)imageData.getWidthHW(), (int)imageData.getHeightHW(), (int)0, (int)6408, (int)5121, (ByteBuffer)imageData.getData().getBuffer());
        imageData.dispose();
    }

    public void generateFiles(String string, String string2) throws Exception {
        ImageData imageData = new ImageData(string);
        if (imageData == null) {
            return;
        }
        int n = 256;
        int n2 = 5;
        for (int i = 0; i < n2; ++i) {
            MipMapLevel mipMapLevel = imageData.getMipMapData(i);
            float f = (float)imageData.getWidth() / (float)(1 << i);
            float f2 = (float)imageData.getHeight() / (float)(1 << i);
            int n3 = (int)Math.ceil(f / (float)n);
            int n4 = (int)Math.ceil(f2 / (float)n);
            for (int j = 0; j < n4; ++j) {
                for (int k = 0; k < n3; ++k) {
                    BufferedImage bufferedImage = this.getBufferedImage(mipMapLevel, k, j, n);
                    this.writeImageToFile(bufferedImage, string2, k, j, i);
                }
            }
        }
    }

    public FileSystem openZipFile() {
        try {
            return FileSystems.newFileSystem(Paths.get(this.m_zipFile, new String[0]));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public void generateZip(String string, String string2) throws Exception {
        ImageData imageData = new ImageData(string);
        if (imageData == null) {
            return;
        }
        int n = 256;
        try (FileOutputStream fileOutputStream = new FileOutputStream(string2);
             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
             ZipOutputStream zipOutputStream = new ZipOutputStream(bufferedOutputStream);){
            int n2 = 5;
            for (int i = 0; i < n2; ++i) {
                MipMapLevel mipMapLevel = imageData.getMipMapData(i);
                float f = (float)imageData.getWidth() / (float)(1 << i);
                float f2 = (float)imageData.getHeight() / (float)(1 << i);
                int n3 = (int)Math.ceil(f / (float)n);
                int n4 = (int)Math.ceil(f2 / (float)n);
                for (int j = 0; j < n4; ++j) {
                    for (int k = 0; k < n3; ++k) {
                        BufferedImage bufferedImage = this.getBufferedImage(mipMapLevel, k, j, n);
                        this.writeImageToZip(bufferedImage, zipOutputStream, k, j, i);
                    }
                }
                if (!(f <= (float)n) || !(f2 <= (float)n)) continue;
                break;
            }
        }
    }

    BufferedImage getBufferedImage(MipMapLevel mipMapLevel, int n, int n2, int n3) {
        BufferedImage bufferedImage = new BufferedImage(n3, n3, 2);
        int[] nArray = new int[n3];
        IntBuffer intBuffer = mipMapLevel.getBuffer().asIntBuffer();
        for (int i = 0; i < n3; ++i) {
            intBuffer.get(n * n3 + (n2 * n3 + i) * mipMapLevel.width, nArray);
            for (int j = 0; j < n3; ++j) {
                int n4 = nArray[j];
                int n5 = n4 & 0xFF;
                int n6 = n4 >> 8 & 0xFF;
                int n7 = n4 >> 16 & 0xFF;
                int n8 = n4 >> 24 & 0xFF;
                nArray[j] = n8 << 24 | n5 << 16 | n6 << 8 | n7;
            }
            bufferedImage.setRGB(0, i, n3, 1, nArray, 0, n3);
        }
        return bufferedImage;
    }

    void writeImageToFile(BufferedImage bufferedImage, String string, int n, int n2, int n3) throws Exception {
        File file = new File(string + File.separator + n3);
        if (!file.exists() && !file.mkdirs()) {
            return;
        }
        file = new File(file, String.format("tile%dx%d.png", n, n2));
        ImageIO.write((RenderedImage)bufferedImage, "png", file);
    }

    void writeImageToZip(BufferedImage bufferedImage, ZipOutputStream zipOutputStream, int n, int n2, int n3) throws Exception {
        zipOutputStream.putNextEntry(new ZipEntry(String.format("%d/tile%dx%d.png", n3, n, n2)));
        ImageIO.write((RenderedImage)bufferedImage, "PNG", zipOutputStream);
        zipOutputStream.closeEntry();
    }

    PyramidTexture checkTextureCache(String string) {
        if (this.m_textures.size() < this.MAX_TEXTURES) {
            PyramidTexture pyramidTexture = new PyramidTexture();
            pyramidTexture.m_key = string;
            pyramidTexture.m_requestNumber = this.m_requestNumber++;
            this.m_textures.put(string, pyramidTexture);
            if (this.m_requestNumber >= this.MAX_REQUEST_NUMBER) {
                this.resetRequestNumbers();
            }
            return pyramidTexture;
        }
        PyramidTexture pyramidTexture = null;
        for (PyramidTexture pyramidTexture2 : this.m_textures.values()) {
            if (pyramidTexture != null && pyramidTexture.m_requestNumber <= pyramidTexture2.m_requestNumber) continue;
            pyramidTexture = pyramidTexture2;
        }
        this.m_textures.remove(pyramidTexture.m_key);
        pyramidTexture.m_key = string;
        pyramidTexture.m_requestNumber = this.m_requestNumber++;
        this.m_textures.put(pyramidTexture.m_key, pyramidTexture);
        if (this.m_requestNumber >= this.MAX_REQUEST_NUMBER) {
            this.resetRequestNumbers();
        }
        return pyramidTexture;
    }

    void resetRequestNumbers() {
        ArrayList<PyramidTexture> arrayList = new ArrayList<PyramidTexture>(this.m_textures.values());
        arrayList.sort(Comparator.comparingInt(pyramidTexture -> pyramidTexture.m_requestNumber));
        this.m_requestNumber = 1;
        for (PyramidTexture pyramidTexture2 : arrayList) {
            ++this.m_requestNumber;
            pyramidTexture2.m_requestNumber = pyramidTexture2.m_requestNumber;
        }
        arrayList.clear();
    }

    private void readInfoFile() {
        if (this.m_zipFS == null || !this.m_zipFS.isOpen()) {
            return;
        }
        Path path = this.m_zipFS.getPath("pyramid.txt", new String[0]);
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
             InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
             BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.startsWith("VERSION=")) {
                    string = string.substring("VERSION=".length());
                    continue;
                }
                if (string.startsWith("bounds=")) {
                    String[] stringArray = (string = string.substring("bounds=".length())).split(" ");
                    if (stringArray.length != 4) continue;
                    this.m_minX = PZMath.tryParseInt(stringArray[0], -1);
                    this.m_minY = PZMath.tryParseInt(stringArray[1], -1);
                    this.m_maxX = PZMath.tryParseInt(stringArray[2], -1);
                    this.m_maxY = PZMath.tryParseInt(stringArray[3], -1);
                    continue;
                }
                if (!string.startsWith("resolution=")) continue;
                string = string.substring("resolution=".length());
                this.m_resolution = PZMath.tryParseFloat(string, 1.0f);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void destroy() {
        if (this.m_zipFS != null) {
            try {
                this.m_zipFS.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.m_zipFS = null;
        }
        RenderThread.invokeOnRenderContext(() -> {
            for (PyramidTexture pyramidTexture : this.m_textures.values()) {
                pyramidTexture.m_textureID.destroy();
            }
        });
        this.m_missing.clear();
        this.m_textures.clear();
    }

    public static final class PyramidTexture {
        String m_key;
        int m_requestNumber;
        TextureID m_textureID;
    }
}

