/*
 * Decompiled with CFR 0.152.
 */
package zombie.world.logger;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import zombie.ZomboidFileSystem;
import zombie.debug.DebugLog;
import zombie.network.GameClient;
import zombie.world.logger.Log;

public class WorldDictionaryLogger {
    private static final ArrayList<Log.BaseLog> _logItems = new ArrayList();

    public static void reset() {
        _logItems.clear();
    }

    public static void startLogging() {
        WorldDictionaryLogger.reset();
    }

    public static void log(Log.BaseLog baseLog) {
        if (GameClient.bClient) {
            return;
        }
        _logItems.add(baseLog);
    }

    public static void log(String string) {
        WorldDictionaryLogger.log(string, true);
    }

    public static void log(String string, boolean bl) {
        if (GameClient.bClient) {
            return;
        }
        if (bl) {
            DebugLog.log("WorldDictionary: " + string);
        }
        _logItems.add(new Log.Comment(string));
    }

    public static void saveLog(String string) throws IOException {
        Log.BaseLog baseLog;
        if (GameClient.bClient) {
            return;
        }
        boolean bl = false;
        for (int i = 0; i < _logItems.size(); ++i) {
            baseLog = _logItems.get(i);
            if (baseLog.isIgnoreSaveCheck()) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return;
        }
        File file = new File(ZomboidFileSystem.instance.getCurrentSaveDir() + File.separator);
        if (file.exists() && file.isDirectory()) {
            String string2 = ZomboidFileSystem.instance.getFileNameInCurrentSave(string);
            File file2 = new File(string2);
            try (FileWriter fileWriter = new FileWriter(file2, true);){
                fileWriter.write("log = log or {};" + System.lineSeparator());
                fileWriter.write("table.insert(log, {" + System.lineSeparator());
                for (int i = 0; i < _logItems.size(); ++i) {
                    baseLog = _logItems.get(i);
                    baseLog.saveAsText(fileWriter, "\t");
                }
                fileWriter.write("};" + System.lineSeparator());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new IOException("Error saving WorldDictionary log.");
            }
        }
    }
}

